/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.grender.support;

import com.bc.ceres.core.Assert;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.ViewportListener;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DefaultViewport
implements Viewport {
    private Rectangle viewBounds;
    private AffineTransform modelToViewTransform;
    private AffineTransform viewToModelTransform;
    private boolean modelYAxisDown;
    private double orientation;
    private ArrayList<ViewportListener> changeListeners;

    public DefaultViewport() {
        this(new Rectangle());
    }

    public DefaultViewport(Rectangle viewBounds) {
        this(viewBounds, false);
    }

    public DefaultViewport(boolean modelYAxisDown) {
        this(new Rectangle(), modelYAxisDown);
    }

    public DefaultViewport(Rectangle viewBounds, boolean modelYAxisDown) {
        Assert.notNull((Object)viewBounds, (String)"viewBounds");
        this.viewBounds = new Rectangle(viewBounds);
        this.modelYAxisDown = modelYAxisDown;
        this.modelToViewTransform = AffineTransform.getScaleInstance(1.0, modelYAxisDown ? 1.0 : -1.0);
        this.viewToModelTransform = AffineTransform.getScaleInstance(1.0, modelYAxisDown ? 1.0 : -1.0);
        this.changeListeners = new ArrayList(3);
    }

    @Override
    public boolean isModelYAxisDown() {
        return this.modelYAxisDown;
    }

    @Override
    public void setModelYAxisDown(boolean modelYAxisDown) {
        if (this.modelYAxisDown != modelYAxisDown) {
            this.modelYAxisDown = modelYAxisDown;
            this.viewToModelTransform.scale(1.0, -1.0);
            this.modelToViewTransform.scale(1.0, -1.0);
            this.fireViewportChanged(false);
        }
    }

    @Override
    public Rectangle getViewBounds() {
        return new Rectangle(this.viewBounds);
    }

    @Override
    public void setViewBounds(Rectangle viewBounds) {
        Assert.notNull((Object)viewBounds, (String)"viewBounds");
        if (!viewBounds.equals(this.viewBounds)) {
            this.viewBounds.setRect(viewBounds);
            this.fireViewportChanged(false);
        }
    }

    @Override
    public AffineTransform getViewToModelTransform() {
        return new AffineTransform(this.viewToModelTransform);
    }

    @Override
    public AffineTransform getModelToViewTransform() {
        return new AffineTransform(this.modelToViewTransform);
    }

    @Override
    public double getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(double orientation) {
        Point2D.Double vc = this.getViewportCenterPoint();
        this.setOrientation(orientation, vc);
    }

    @Override
    public double getOffsetX() {
        return this.viewToModelTransform.getTranslateX();
    }

    @Override
    public double getOffsetY() {
        return this.viewToModelTransform.getTranslateY();
    }

    @Override
    public void setOffset(double offsetX, double offsetY) {
        this.viewToModelTransform.setTransform(this.viewToModelTransform.getScaleX(), this.viewToModelTransform.getShearY(), this.viewToModelTransform.getShearX(), this.viewToModelTransform.getScaleY(), offsetX, offsetY);
        this.updateModelToViewTransform();
        this.fireViewportChanged(false);
    }

    @Override
    public void moveViewDelta(double deltaX, double deltaY) {
        if (deltaX == 0.0 && deltaY == 0.0) {
            return;
        }
        this.viewToModelTransform.translate(-deltaX, -deltaY);
        this.updateModelToViewTransform();
        this.fireViewportChanged(false);
    }

    @Override
    public double getZoomFactor() {
        return Math.sqrt(Math.abs(this.modelToViewTransform.getDeterminant()));
    }

    @Override
    public void setZoomFactor(double zoomFactor) {
        Assert.argument((zoomFactor > 0.0 ? 1 : 0) != 0, (String)"zoomFactor > 0.0");
        this.setZoomFactor(zoomFactor, this.getViewportCenterPoint());
    }

    @Override
    public void zoom(Rectangle2D modelBounds) {
        double viewportWidth = this.viewBounds.width;
        double viewportHeight = this.viewBounds.height;
        double zoomFactor = Math.min(viewportWidth / modelBounds.getWidth(), viewportHeight / modelBounds.getHeight());
        if (zoomFactor > 0.0) {
            this.setZoomFactor(zoomFactor, modelBounds.getCenterX(), modelBounds.getCenterY());
        }
    }

    @Override
    public void setZoomFactor(double zoomFactor, double modelCenterX, double modelCenterY) {
        Assert.argument((zoomFactor > 0.0 ? 1 : 0) != 0, (String)"zoomFactor > 0.0");
        double sx = 1.0;
        double sy = this.modelYAxisDown ? 1.0 : -1.0;
        double viewportWidth = this.viewBounds.width;
        double viewportHeight = this.viewBounds.height;
        double modelOffsetX = modelCenterX - 0.5 * viewportWidth / zoomFactor;
        double modelOffsetY = modelCenterY - 0.5 * sy * viewportHeight / zoomFactor;
        double orientation = this.getOrientation();
        AffineTransform m2v = AffineTransform.getScaleInstance(1.0, sy);
        m2v.scale(zoomFactor, zoomFactor);
        m2v.translate(-modelOffsetX, -modelOffsetY);
        this.modelToViewTransform.setTransform(m2v);
        this.updateViewToModelTransform();
        this.orientation = 0.0;
        this.setOrientation(orientation);
        this.fireViewportChanged(false);
    }

    void setZoomFactor(double zoomFactor, Point2D vc) {
        Assert.argument((zoomFactor > 0.0 ? 1 : 0) != 0, (String)"zoomFactor > 0.0");
        double oldZoomFactor = this.getZoomFactor();
        if (oldZoomFactor != zoomFactor) {
            AffineTransform v2m = this.viewToModelTransform;
            v2m.translate(vc.getX(), vc.getY());
            v2m.scale(oldZoomFactor / zoomFactor, oldZoomFactor / zoomFactor);
            v2m.translate(-vc.getX(), -vc.getY());
            this.updateModelToViewTransform();
            this.fireViewportChanged(false);
        }
    }

    private void setOrientation(double orientation, Point2D vc) {
        double oldOrientation = this.getOrientation();
        if (oldOrientation != orientation) {
            AffineTransform v2m = this.viewToModelTransform;
            v2m.translate(vc.getX(), vc.getY());
            v2m.rotate(orientation - oldOrientation);
            v2m.translate(-vc.getX(), -vc.getY());
            this.updateModelToViewTransform();
            this.orientation = orientation;
            this.fireViewportChanged(true);
        }
    }

    private Point2D.Double getViewportCenterPoint() {
        return new Point2D.Double(this.viewBounds.getCenterX(), this.viewBounds.getCenterY());
    }

    @Override
    public void addListener(ViewportListener listener) {
        Assert.notNull((Object)listener, (String)"listener");
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public void removeListener(ViewportListener listener) {
        this.changeListeners.remove(listener);
    }

    @Override
    public ViewportListener[] getListeners() {
        return this.changeListeners.toArray(new ViewportListener[this.changeListeners.size()]);
    }

    @Override
    public void setTransform(Viewport other) {
        boolean orientationChange;
        this.modelToViewTransform.setTransform(other.getModelToViewTransform());
        this.viewToModelTransform.setTransform(other.getViewToModelTransform());
        this.modelYAxisDown = other.isModelYAxisDown();
        boolean bl = orientationChange = this.orientation != other.getOrientation();
        if (orientationChange) {
            this.orientation = other.getOrientation();
        }
        this.fireViewportChanged(orientationChange);
    }

    protected void fireViewportChanged(boolean orientationChanged) {
        for (ViewportListener listener : this.getListeners()) {
            listener.handleViewportChanged(this, orientationChanged);
        }
    }

    private void updateModelToViewTransform() {
        try {
            this.modelToViewTransform.setTransform(this.viewToModelTransform.createInverse());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateViewToModelTransform() {
        try {
            this.viewToModelTransform.setTransform(this.modelToViewTransform.createInverse());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[viewToModelTransform=" + this.viewToModelTransform + "]";
    }

    @Override
    public Viewport clone() {
        try {
            DefaultViewport vp = (DefaultViewport)super.clone();
            vp.viewBounds = new Rectangle(this.viewBounds);
            vp.changeListeners = new ArrayList(3);
            return vp;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

