/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.LineStringEncoder;
import org.geotools.gml2.simple.LinearRingEncoder;
import org.geotools.gml2.simple.MultiLineStringEncoder;
import org.geotools.gml2.simple.MultiPointEncoder;
import org.geotools.gml2.simple.MultiPolygonEncoder;
import org.geotools.gml2.simple.PointEncoder;
import org.geotools.gml2.simple.PolygonEncoder;
import org.geotools.xml.Encoder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.xml.sax.helpers.AttributesImpl;

public class GenericGeometryEncoder
extends GeometryEncoder<Geometry> {
    Encoder encoder;
    String gmlPrefix;

    public GenericGeometryEncoder(Encoder encoder) {
        super(encoder);
        this.encoder = encoder;
    }

    public GenericGeometryEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.encoder = encoder;
        this.gmlPrefix = gmlPrefix;
    }

    @Override
    public void encode(Geometry geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        if (geometry instanceof LineString) {
            LineStringEncoder lineString = new LineStringEncoder(this.encoder, LineStringEncoder.LINE_STRING);
            lineString.encode((LineString)geometry, atts, handler);
        } else if (geometry instanceof Point) {
            PointEncoder pt = new PointEncoder(this.encoder, this.gmlPrefix == null ? "gml" : this.gmlPrefix);
            pt.encode((Point)geometry, atts, handler);
        } else if (geometry instanceof Polygon) {
            PolygonEncoder polygon = new PolygonEncoder(this.encoder, this.gmlPrefix);
            polygon.encode((Polygon)geometry, atts, handler);
        } else if (geometry instanceof MultiLineString) {
            MultiLineStringEncoder multiLineString = new MultiLineStringEncoder(this.encoder, this.gmlPrefix);
            multiLineString.encode((MultiLineString)geometry, atts, handler);
        } else if (geometry instanceof MultiPoint) {
            MultiPointEncoder multiPoint = new MultiPointEncoder(this.encoder, this.gmlPrefix);
            multiPoint.encode((MultiPoint)geometry, atts, handler);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygonEncoder multiPolygon = new MultiPolygonEncoder(this.encoder, this.gmlPrefix);
            multiPolygon.encode((MultiPolygon)geometry, atts, handler);
        } else if (geometry instanceof LinearRing) {
            LinearRingEncoder linearRing = new LinearRingEncoder(this.encoder, this.gmlPrefix);
            linearRing.encode((LinearRing)geometry, atts, handler);
        } else {
            throw new Exception("Unsupported geometry " + geometry.toString());
        }
    }
}

