/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.util.Range;

class AffineNearestOpImage
extends AffineOpImage {
    public AffineNearestOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
    }

    protected Range performScanlineClipping(float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        long l;
        long l2;
        long l3;
        long l4;
        int n11 = n5;
        int n12 = n6;
        long l5 = this.incx * 0x100000 + this.ifracdx;
        if (l5 != 0L) {
            l4 = (long)f + (long)n7;
            l3 = (long)f3 - (long)n8;
            l2 = (l4 - (long)n) * 0x100000L - (long)n3 + (long)n5 * l5;
            l = (l3 - (long)n) * 0x100000L - (long)n3 + (long)n5 * l5;
            if (l5 < 0L) {
                long l6 = l2;
                l2 = l;
                l = l6;
            }
            int n13 = AffineNearestOpImage.ceilRatio(l2, l5);
            n11 = Math.max(n11, n13);
            int n14 = AffineNearestOpImage.floorRatio(l, l5) + 1;
            n12 = Math.min(n12, n14);
        } else if ((float)n < f || (float)n >= f3) {
            n11 = n12 = n5;
            return new Range(Integer.class, new Integer(n11), new Integer(n12));
        }
        l4 = this.incy * 0x100000 + this.ifracdy;
        if (l4 != 0L) {
            l3 = (long)f2 + (long)n9;
            l2 = (long)f4 - (long)n10;
            l = (l3 - (long)n2) * 0x100000L - (long)n4 + (long)n5 * l4;
            long l7 = (l2 - (long)n2) * 0x100000L - (long)n4 + (long)n5 * l4;
            if (l4 < 0L) {
                long l8 = l;
                l = l7;
                l7 = l8;
            }
            int n15 = AffineNearestOpImage.ceilRatio(l, l4);
            n11 = Math.max(n11, n15);
            int n16 = AffineNearestOpImage.floorRatio(l7, l4) + 1;
            n12 = Math.min(n12, n16);
        } else if ((float)n2 < f2 || (float)n2 >= f4) {
            n11 = n12 = n5;
        }
        if (n11 > n6) {
            n11 = n6;
        }
        if (n12 < n5) {
            n12 = n5;
        }
        return new Range(Integer.class, new Integer(n11), new Integer(n12));
    }

    protected Point[] advanceToStartOfScanline(int n, int n2, int n3, int n4, int n5, int n6) {
        long l = n2 - n;
        long l2 = ((long)n5 + l * (long)this.ifracdx) / 0x100000L;
        long l3 = ((long)n6 + l * (long)this.ifracdy) / 0x100000L;
        n3 = (int)((long)n3 + (l * (long)this.incx + (long)((int)l2)));
        n4 = (int)((long)n4 + (l * (long)this.incy + (long)((int)l3)));
        long l4 = (long)n5 + l * (long)this.ifracdx;
        n5 = l4 >= 0L ? (int)(l4 % 0x100000L) : (int)(-(-l4 % 0x100000L));
        long l5 = (long)n6 + l * (long)this.ifracdy;
        n6 = l5 >= 0L ? (int)(l5 % 0x100000L) : (int)(-(-l5 % 0x100000L));
        return new Point[]{new Point(n3, n4), new Point(n5, n6)};
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                int n3 = rasterAccessor2.getNumBands();
                if (n3 == 1) {
                    this.byteLoop_1band(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                    break;
                }
                if (n3 == 3) {
                    this.byteLoop_3band(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                    break;
                }
                this.byteLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        int n16 = this.incx * n9;
        int n17 = this.incx1 * n9;
        int n18 = this.incy * n10;
        int n19 = this.incy1 * n10;
        byte[] byArray3 = new byte[n11];
        for (n3 = 0; n3 < n11; ++n3) {
            byArray3[n3] = (byte)this.backgroundValues[n3];
        }
        for (n3 = n13; n3 < n15; ++n3) {
            int n20;
            int n21;
            int n22 = n4;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n23 = (int)Math.floor(f5);
            int n24 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n23;
            double d2 = (double)f6 - (double)n24;
            int n25 = (int)Math.floor(d * 1048576.0);
            int n26 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n23, n24, n25, n26, n12, n14, 0, 0, 0, 0);
            int n27 = (Integer)range.getMinValue();
            int n28 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n12, n27, n23, n24, n25, n26);
            n23 = pointArray[0].x;
            n24 = pointArray[0].y;
            n25 = pointArray[1].x;
            n26 = pointArray[1].y;
            int n29 = (n24 - n2) * n10 + (n23 - n) * n9;
            if (this.setBackground) {
                for (n21 = n12; n21 < n27; ++n21) {
                    for (n20 = 0; n20 < n11; ++n20) {
                        byArray[n20][n22 + nArray[n20]] = byArray3[n20];
                    }
                    n22 += n7;
                }
            } else {
                n22 += (n27 - n12) * n7;
            }
            for (n21 = n27; n21 < n28; ++n21) {
                for (n20 = 0; n20 < n11; ++n20) {
                    byArray[n20][n22 + nArray[n20]] = byArray2[n20][n29 + nArray2[n20]];
                }
                if (n25 < this.ifracdx1) {
                    n29 += n16;
                    n25 += this.ifracdx;
                } else {
                    n29 += n17;
                    n25 -= this.ifracdx1;
                }
                if (n26 < this.ifracdy1) {
                    n29 += n18;
                    n26 += this.ifracdy;
                } else {
                    n29 += n19;
                    n26 -= this.ifracdy1;
                }
                n22 += n7;
            }
            if (this.setBackground && n27 <= n28) {
                for (n21 = n28; n21 < n14; ++n21) {
                    for (n20 = 0; n20 < n11; ++n20) {
                        byArray[n20][n22 + nArray[n20]] = byArray3[n20];
                    }
                    n22 += n7;
                }
            }
            n4 += n8;
        }
    }

    private void byteLoop_1band(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[] byArray2 = byArray[0];
        int n8 = nArray[0];
        byte[][] byArray3 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        byte[] byArray4 = byArray3[0];
        int n11 = nArray2[0];
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        int n16 = this.incx * n9;
        int n17 = this.incx1 * n9;
        int n18 = this.incy * n10;
        int n19 = this.incy1 * n10;
        byte by = (byte)this.backgroundValues[0];
        for (int i = n13; i < n15; ++i) {
            int n20;
            int n21 = n3;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)i + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n22 = (int)Math.floor(f5);
            int n23 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n22;
            double d2 = (double)f6 - (double)n23;
            int n24 = (int)Math.floor(d * 1048576.0);
            int n25 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n22, n23, n24, n25, n12, n14, 0, 0, 0, 0);
            int n26 = (Integer)range.getMinValue();
            int n27 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n12, n26, n22, n23, n24, n25);
            n22 = pointArray[0].x;
            n23 = pointArray[0].y;
            n24 = pointArray[1].x;
            n25 = pointArray[1].y;
            int n28 = (n23 - n2) * n10 + (n22 - n) * n9;
            if (this.setBackground) {
                for (n20 = n12; n20 < n26; ++n20) {
                    byArray2[n21 + n8] = by;
                    n21 += n6;
                }
            } else {
                n21 += (n26 - n12) * n6;
            }
            for (n20 = n26; n20 < n27; ++n20) {
                byArray2[n21 + n8] = byArray4[n28 + n11];
                if (n24 < this.ifracdx1) {
                    n28 += n16;
                    n24 += this.ifracdx;
                } else {
                    n28 += n17;
                    n24 -= this.ifracdx1;
                }
                if (n25 < this.ifracdy1) {
                    n28 += n18;
                    n25 += this.ifracdy;
                } else {
                    n28 += n19;
                    n25 -= this.ifracdy1;
                }
                n21 += n6;
            }
            if (this.setBackground && n26 <= n27) {
                for (n20 = n27; n20 < n14; ++n20) {
                    byArray2[n21 + n8] = by;
                    n21 += n6;
                }
            }
            n3 += n7;
        }
    }

    private void byteLoop_3band(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        int n8 = nArray[0];
        int n9 = nArray[1];
        int n10 = nArray[2];
        byte[][] byArray5 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n11 = rasterAccessor.getPixelStride();
        int n12 = rasterAccessor.getScanlineStride();
        byte[] byArray6 = byArray5[0];
        byte[] byArray7 = byArray5[1];
        byte[] byArray8 = byArray5[2];
        int n13 = nArray2[0];
        int n14 = nArray2[1];
        int n15 = nArray2[2];
        int n16 = rectangle.x;
        int n17 = rectangle.y;
        int n18 = rectangle.x + rectangle.width;
        int n19 = rectangle.y + rectangle.height;
        int n20 = this.incx * n11;
        int n21 = this.incx1 * n11;
        int n22 = this.incy * n12;
        int n23 = this.incy1 * n12;
        byte by = (byte)this.backgroundValues[0];
        byte by2 = (byte)this.backgroundValues[1];
        byte by3 = (byte)this.backgroundValues[2];
        for (int i = n17; i < n19; ++i) {
            int n24;
            int n25 = n3;
            ((Point2D)float_).setLocation((double)n16 + 0.5, (double)i + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n26 = (int)Math.floor(f5);
            int n27 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n26;
            double d2 = (double)f6 - (double)n27;
            int n28 = (int)Math.floor(d * 1048576.0);
            int n29 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n26, n27, n28, n29, n16, n18, 0, 0, 0, 0);
            int n30 = (Integer)range.getMinValue();
            int n31 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n16, n30, n26, n27, n28, n29);
            n26 = pointArray[0].x;
            n27 = pointArray[0].y;
            n28 = pointArray[1].x;
            n29 = pointArray[1].y;
            int n32 = (n27 - n2) * n12 + (n26 - n) * n11;
            if (this.setBackground) {
                for (n24 = n16; n24 < n30; ++n24) {
                    byArray2[n25 + n8] = by;
                    byArray3[n25 + n9] = by2;
                    byArray4[n25 + n10] = by3;
                    n25 += n6;
                }
            } else {
                n25 += (n30 - n16) * n6;
            }
            for (n24 = n30; n24 < n31; ++n24) {
                byArray2[n25 + n8] = byArray6[n32 + n13];
                byArray3[n25 + n9] = byArray7[n32 + n14];
                byArray4[n25 + n10] = byArray8[n32 + n15];
                if (n28 < this.ifracdx1) {
                    n32 += n20;
                    n28 += this.ifracdx;
                } else {
                    n32 += n21;
                    n28 -= this.ifracdx1;
                }
                if (n29 < this.ifracdy1) {
                    n32 += n22;
                    n29 += this.ifracdy;
                } else {
                    n32 += n23;
                    n29 -= this.ifracdy1;
                }
                n25 += n6;
            }
            if (this.setBackground && n30 <= n31) {
                for (n24 = n31; n24 < n18; ++n24) {
                    byArray2[n25 + n8] = by;
                    byArray3[n25 + n9] = by2;
                    byArray4[n25 + n10] = by3;
                    n25 += n6;
                }
            }
            n3 += n7;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        int n16 = this.incx * n9;
        int n17 = this.incx1 * n9;
        int n18 = this.incy * n10;
        int n19 = this.incy1 * n10;
        int[] nArray5 = new int[n11];
        for (n3 = 0; n3 < n11; ++n3) {
            nArray5[n3] = (int)this.backgroundValues[n3];
        }
        for (n3 = n13; n3 < n15; ++n3) {
            int n20;
            int n21;
            int n22 = n4;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n23 = (int)Math.floor(f5);
            int n24 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n23;
            double d2 = (double)f6 - (double)n24;
            int n25 = (int)Math.floor(d * 1048576.0);
            int n26 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n23, n24, n25, n26, n12, n14, 0, 0, 0, 0);
            int n27 = (Integer)range.getMinValue();
            int n28 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n12, n27, n23, n24, n25, n26);
            n23 = pointArray[0].x;
            n24 = pointArray[0].y;
            n25 = pointArray[1].x;
            n26 = pointArray[1].y;
            int n29 = (n24 - n2) * n10 + (n23 - n) * n9;
            if (this.setBackground) {
                for (n21 = n12; n21 < n27; ++n21) {
                    for (n20 = 0; n20 < n11; ++n20) {
                        nArray[n20][n22 + nArray2[n20]] = nArray5[n20];
                    }
                    n22 += n7;
                }
            } else {
                n22 += (n27 - n12) * n7;
            }
            for (n21 = n27; n21 < n28; ++n21) {
                for (n20 = 0; n20 < n11; ++n20) {
                    nArray[n20][n22 + nArray2[n20]] = nArray3[n20][n29 + nArray4[n20]];
                }
                if (n25 < this.ifracdx1) {
                    n29 += n16;
                    n25 += this.ifracdx;
                } else {
                    n29 += n17;
                    n25 -= this.ifracdx1;
                }
                if (n26 < this.ifracdy1) {
                    n29 += n18;
                    n26 += this.ifracdy;
                } else {
                    n29 += n19;
                    n26 -= this.ifracdy1;
                }
                n22 += n7;
            }
            if (this.setBackground && n27 <= n28) {
                for (n21 = n28; n21 < n14; ++n21) {
                    for (n20 = 0; n20 < n11; ++n20) {
                        nArray[n20][n22 + nArray2[n20]] = nArray5[n20];
                    }
                    n22 += n7;
                }
            }
            n4 += n8;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        int n16 = this.incx * n9;
        int n17 = this.incx1 * n9;
        int n18 = this.incy * n10;
        int n19 = this.incy1 * n10;
        short[] sArray3 = new short[n11];
        for (n3 = 0; n3 < n11; ++n3) {
            sArray3[n3] = (short)this.backgroundValues[n3];
        }
        for (n3 = n13; n3 < n15; ++n3) {
            int n20;
            int n21;
            int n22 = n4;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n23 = (int)Math.floor(f5);
            int n24 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n23;
            double d2 = (double)f6 - (double)n24;
            int n25 = (int)Math.floor(d * 1048576.0);
            int n26 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n23, n24, n25, n26, n12, n14, 0, 0, 0, 0);
            int n27 = (Integer)range.getMinValue();
            int n28 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n12, n27, n23, n24, n25, n26);
            n23 = pointArray[0].x;
            n24 = pointArray[0].y;
            n25 = pointArray[1].x;
            n26 = pointArray[1].y;
            int n29 = (n24 - n2) * n10 + (n23 - n) * n9;
            if (this.setBackground) {
                for (n21 = n12; n21 < n27; ++n21) {
                    for (n20 = 0; n20 < n11; ++n20) {
                        sArray[n20][n22 + nArray[n20]] = sArray3[n20];
                    }
                    n22 += n7;
                }
            } else {
                n22 += (n27 - n12) * n7;
            }
            for (n21 = n27; n21 < n28; ++n21) {
                for (n20 = 0; n20 < n11; ++n20) {
                    sArray[n20][n22 + nArray[n20]] = sArray2[n20][n29 + nArray2[n20]];
                }
                if (n25 < this.ifracdx1) {
                    n29 += n16;
                    n25 += this.ifracdx;
                } else {
                    n29 += n17;
                    n25 -= this.ifracdx1;
                }
                if (n26 < this.ifracdy1) {
                    n29 += n18;
                    n26 += this.ifracdy;
                } else {
                    n29 += n19;
                    n26 -= this.ifracdy1;
                }
                n22 += n7;
            }
            if (this.setBackground && n27 <= n28) {
                for (n21 = n28; n21 < n14; ++n21) {
                    for (n20 = 0; n20 < n11; ++n20) {
                        sArray[n20][n22 + nArray[n20]] = sArray3[n20];
                    }
                    n22 += n7;
                }
            }
            n4 += n8;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        int n16 = this.incx * n9;
        int n17 = this.incx1 * n9;
        int n18 = this.incy * n10;
        int n19 = this.incy1 * n10;
        float[] fArray3 = new float[n11];
        for (n3 = 0; n3 < n11; ++n3) {
            fArray3[n3] = (float)this.backgroundValues[n3];
        }
        for (n3 = n13; n3 < n15; ++n3) {
            int n20;
            int n21;
            int n22 = n4;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n23 = (int)Math.floor(f5);
            int n24 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n23;
            double d2 = (double)f6 - (double)n24;
            int n25 = (int)Math.floor(d * 1048576.0);
            int n26 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n23, n24, n25, n26, n12, n14, 0, 0, 0, 0);
            int n27 = (Integer)range.getMinValue();
            int n28 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n12, n27, n23, n24, n25, n26);
            n23 = pointArray[0].x;
            n24 = pointArray[0].y;
            n25 = pointArray[1].x;
            n26 = pointArray[1].y;
            int n29 = (n24 - n2) * n10 + (n23 - n) * n9;
            if (this.setBackground) {
                for (n21 = n12; n21 < n27; ++n21) {
                    for (n20 = 0; n20 < n11; ++n20) {
                        fArray[n20][n22 + nArray[n20]] = fArray3[n20];
                    }
                    n22 += n7;
                }
            } else {
                n22 += (n27 - n12) * n7;
            }
            for (n21 = n27; n21 < n28; ++n21) {
                for (n20 = 0; n20 < n11; ++n20) {
                    fArray[n20][n22 + nArray[n20]] = fArray2[n20][n29 + nArray2[n20]];
                }
                if (n25 < this.ifracdx1) {
                    n29 += n16;
                    n25 += this.ifracdx;
                } else {
                    n29 += n17;
                    n25 -= this.ifracdx1;
                }
                if (n26 < this.ifracdy1) {
                    n29 += n18;
                    n26 += this.ifracdy;
                } else {
                    n29 += n19;
                    n26 -= this.ifracdy1;
                }
                n22 += n7;
            }
            if (this.setBackground && n27 <= n28) {
                for (n21 = n28; n21 < n14; ++n21) {
                    for (n20 = 0; n20 < n11; ++n20) {
                        fArray[n20][n22 + nArray[n20]] = fArray3[n20];
                    }
                    n22 += n7;
                }
            }
            n4 += n8;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor2.getNumBands();
        int n11 = rectangle.x;
        int n12 = rectangle.y;
        int n13 = rectangle.x + rectangle.width;
        int n14 = rectangle.y + rectangle.height;
        int n15 = this.incx * n8;
        int n16 = this.incx1 * n8;
        int n17 = this.incy * n9;
        int n18 = this.incy1 * n9;
        for (int i = n12; i < n14; ++i) {
            int n19;
            int n20;
            int n21 = n3;
            ((Point2D)float_).setLocation((double)n11 + 0.5, (double)i + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n22 = (int)Math.floor(f5);
            int n23 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n22;
            double d2 = (double)f6 - (double)n23;
            int n24 = (int)Math.floor(d * 1048576.0);
            int n25 = (int)Math.floor(d2 * 1048576.0);
            Range range = this.performScanlineClipping(f, f2, f3 - 1.0f, f4 - 1.0f, n22, n23, n24, n25, n11, n13, 0, 0, 0, 0);
            int n26 = (Integer)range.getMinValue();
            int n27 = (Integer)range.getMaxValue();
            Point[] pointArray = this.advanceToStartOfScanline(n11, n26, n22, n23, n24, n25);
            n22 = pointArray[0].x;
            n23 = pointArray[0].y;
            n24 = pointArray[1].x;
            n25 = pointArray[1].y;
            int n28 = (n23 - n2) * n9 + (n22 - n) * n8;
            if (this.setBackground) {
                for (n20 = n11; n20 < n26; ++n20) {
                    for (n19 = 0; n19 < n10; ++n19) {
                        dArray[n19][n21 + nArray[n19]] = this.backgroundValues[n19];
                    }
                    n21 += n6;
                }
            } else {
                n21 += (n26 - n11) * n6;
            }
            for (n20 = n26; n20 < n27; ++n20) {
                for (n19 = 0; n19 < n10; ++n19) {
                    dArray[n19][n21 + nArray[n19]] = dArray2[n19][n28 + nArray2[n19]];
                }
                if (n24 < this.ifracdx1) {
                    n28 += n15;
                    n24 += this.ifracdx;
                } else {
                    n28 += n16;
                    n24 -= this.ifracdx1;
                }
                if (n25 < this.ifracdy1) {
                    n28 += n17;
                    n25 += this.ifracdy;
                } else {
                    n28 += n18;
                    n25 -= this.ifracdy1;
                }
                n21 += n6;
            }
            if (this.setBackground && n26 <= n27) {
                for (n20 = n27; n20 < n13; ++n20) {
                    for (n19 = 0; n19 < n10; ++n19) {
                        dArray[n19][n21 + nArray[n19]] = this.backgroundValues[n19];
                    }
                    n21 += n6;
                }
            }
            n3 += n7;
        }
    }
}

