/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;

final class LookupOpImage
extends ColormapOpImage {
    protected LookupTableJAI table;

    public LookupOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, LookupTableJAI lookupTableJAI) {
        super(renderedImage, imageLayout, map, true);
        this.table = lookupTableJAI;
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (this.sampleModel.getTransferType() != lookupTableJAI.getDataType() || this.sampleModel.getNumBands() != lookupTableJAI.getDestNumBands(sampleModel.getNumBands())) {
            this.sampleModel = lookupTableJAI.getDestSampleModel(sampleModel, this.tileWidth, this.tileHeight);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        for (int i = 0; i < 3; ++i) {
            byte[] byArray2 = byArray[i];
            int n = byArray2.length;
            int n2 = this.table.getNumBands() < 3 ? 0 : i;
            for (int j = 0; j < n; ++j) {
                int n3 = this.table.lookup(n2, byArray2[j] & 0xFF);
                byArray2[j] = ImageUtil.clampByte(n3);
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.table.lookup(rasterArray[0], writableRaster, rectangle);
    }
}

