/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.DeferredData;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public final class ImageUtil {
    private static final float FLOAT_MIN = -3.4028235E38f;
    private static long counter;
    public static final int BYTE_MASK = 255;
    public static final int USHORT_MASK = 65535;

    public static final byte clampByte(int n) {
        return n > 255 ? (byte)-1 : (n >= 0 ? (byte)n : (byte)0);
    }

    public static final short clampUShort(int n) {
        return n > 65535 ? (short)-1 : (n >= 0 ? (short)n : (short)0);
    }

    public static final short clampShort(int n) {
        return (short)(n > Short.MAX_VALUE ? Short.MAX_VALUE : (n >= Short.MIN_VALUE ? (int)n : Short.MIN_VALUE));
    }

    public static final int clampInt(long l) {
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (l >= Integer.MIN_VALUE ? (int)l : Integer.MIN_VALUE);
    }

    public static final float clampFloat(double d) {
        return d > 3.4028234663852886E38 ? Float.MAX_VALUE : (d >= -3.4028234663852886E38 ? (float)d : -3.4028235E38f);
    }

    public static final byte clampRoundByte(float f) {
        return f > 255.0f ? (byte)-1 : (f >= 0.0f ? (byte)(f + 0.5f) : (byte)0);
    }

    public static final byte clampRoundByte(double d) {
        return d > 255.0 ? (byte)-1 : (d >= 0.0 ? (byte)(d + 0.5) : (byte)0);
    }

    public static final short clampRoundUShort(float f) {
        return f > 65535.0f ? (short)-1 : (f >= 0.0f ? (short)(f + 0.5f) : (short)0);
    }

    public static final short clampRoundUShort(double d) {
        return d > 65535.0 ? (short)-1 : (d >= 0.0 ? (short)(d + 0.5) : (short)0);
    }

    public static final short clampRoundShort(float f) {
        return (short)(f > 32767.0f ? Short.MAX_VALUE : (f >= -32768.0f ? (int)((int)Math.floor(f + 0.5f)) : Short.MIN_VALUE));
    }

    public static final short clampRoundShort(double d) {
        return (short)(d > 32767.0 ? Short.MAX_VALUE : (d >= -32768.0 ? (int)((int)Math.floor(d + 0.5)) : Short.MIN_VALUE));
    }

    public static final int clampRoundInt(float f) {
        return f > 2.1474836E9f ? Integer.MAX_VALUE : (f >= -2.1474836E9f ? (int)Math.floor(f + 0.5f) : Integer.MIN_VALUE);
    }

    public static final int clampRoundInt(double d) {
        return d > 2.147483647E9 ? Integer.MAX_VALUE : (d >= -2.147483648E9 ? (int)Math.floor(d + 0.5) : Integer.MIN_VALUE);
    }

    public static final byte clampBytePositive(int n) {
        return (byte)(n > 255 ? -1 : (byte)n);
    }

    public static final byte clampByteNegative(int n) {
        return n < 0 ? (byte)0 : (byte)n;
    }

    public static final short clampUShortPositive(int n) {
        return (short)(n > 65535 ? -1 : (short)n);
    }

    public static final short clampUShortNegative(int n) {
        return n < 0 ? (short)0 : (short)n;
    }

    public static final void copyRaster(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getPixelStride();
        int n4 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getWidth() * n3;
        int n6 = rasterAccessor2.getHeight() * n4;
        int n7 = rasterAccessor2.getNumBands();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                byte[][] byArray = rasterAccessor.getByteDataArrays();
                byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
                for (int i = 0; i < n7; ++i) {
                    byte[] byArray3 = byArray[i];
                    byte[] byArray4 = byArray2[i];
                    int n8 = nArray2[i] + n6;
                    int n9 = nArray2[i];
                    int n10 = nArray[i];
                    while (n9 < n8) {
                        int n11 = n9 + n5;
                        int n12 = n9;
                        int n13 = n10;
                        while (n12 < n11) {
                            byArray4[n12] = byArray3[n13];
                            n12 += n3;
                            n13 += n;
                        }
                        n9 += n4;
                        n10 += n2;
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                short[][] sArray = rasterAccessor.getShortDataArrays();
                short[][] sArray2 = rasterAccessor2.getShortDataArrays();
                for (int i = 0; i < n7; ++i) {
                    short[] sArray3 = sArray[i];
                    short[] sArray4 = sArray2[i];
                    int n14 = nArray2[i] + n6;
                    int n15 = nArray2[i];
                    int n16 = nArray[i];
                    while (n15 < n14) {
                        int n17 = n15 + n5;
                        int n18 = n15;
                        int n19 = n16;
                        while (n18 < n17) {
                            sArray4[n18] = sArray3[n19];
                            n18 += n3;
                            n19 += n;
                        }
                        n15 += n4;
                        n16 += n2;
                    }
                }
                break;
            }
            case 3: {
                int[][] nArray3 = rasterAccessor.getIntDataArrays();
                int[][] nArray4 = rasterAccessor2.getIntDataArrays();
                for (int i = 0; i < n7; ++i) {
                    int[] nArray5 = nArray3[i];
                    int[] nArray6 = nArray4[i];
                    int n20 = nArray2[i] + n6;
                    int n21 = nArray2[i];
                    int n22 = nArray[i];
                    while (n21 < n20) {
                        int n23 = n21 + n5;
                        int n24 = n21;
                        int n25 = n22;
                        while (n24 < n23) {
                            nArray6[n24] = nArray5[n25];
                            n24 += n3;
                            n25 += n;
                        }
                        n21 += n4;
                        n22 += n2;
                    }
                }
                break;
            }
            case 4: {
                float[][] fArray = rasterAccessor.getFloatDataArrays();
                float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
                for (int i = 0; i < n7; ++i) {
                    float[] fArray3 = fArray[i];
                    float[] fArray4 = fArray2[i];
                    int n26 = nArray2[i] + n6;
                    int n27 = nArray2[i];
                    int n28 = nArray[i];
                    while (n27 < n26) {
                        int n29 = n27 + n5;
                        int n30 = n27;
                        int n31 = n28;
                        while (n30 < n29) {
                            fArray4[n30] = fArray3[n31];
                            n30 += n3;
                            n31 += n;
                        }
                        n27 += n4;
                        n28 += n2;
                    }
                }
                break;
            }
            case 5: {
                double[][] dArray = rasterAccessor.getDoubleDataArrays();
                double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
                for (int i = 0; i < n7; ++i) {
                    double[] dArray3 = dArray[i];
                    double[] dArray4 = dArray2[i];
                    int n32 = nArray2[i] + n6;
                    int n33 = nArray2[i];
                    int n34 = nArray[i];
                    while (n33 < n32) {
                        int n35 = n33 + n5;
                        int n36 = n33;
                        int n37 = n34;
                        while (n36 < n35) {
                            dArray4[n36] = dArray3[n37];
                            n36 += n3;
                            n37 += n;
                        }
                        n33 += n4;
                        n34 += n2;
                    }
                }
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    public boolean areEqualSampleModels(SampleModel sampleModel, SampleModel sampleModel2) {
        if (sampleModel == sampleModel2) {
            return true;
        }
        if (sampleModel.getClass() == sampleModel2.getClass() && sampleModel.getDataType() == sampleModel2.getDataType() && sampleModel.getTransferType() == sampleModel2.getTransferType() && sampleModel.getWidth() == sampleModel2.getWidth() && sampleModel.getHeight() == sampleModel2.getHeight()) {
            if (sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)sampleModel2;
                return componentSampleModel.getPixelStride() == componentSampleModel2.getPixelStride() && componentSampleModel.getScanlineStride() == componentSampleModel2.getScanlineStride() && Arrays.equals(componentSampleModel.getBankIndices(), componentSampleModel2.getBankIndices()) && Arrays.equals(componentSampleModel.getBandOffsets(), componentSampleModel2.getBandOffsets());
            }
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)sampleModel2;
                return multiPixelPackedSampleModel.getPixelBitStride() == multiPixelPackedSampleModel2.getPixelBitStride() && multiPixelPackedSampleModel.getScanlineStride() == multiPixelPackedSampleModel2.getScanlineStride() && multiPixelPackedSampleModel.getDataBitOffset() == multiPixelPackedSampleModel2.getDataBitOffset();
            }
            if (sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)sampleModel2;
                return singlePixelPackedSampleModel.getScanlineStride() == singlePixelPackedSampleModel2.getScanlineStride() && Arrays.equals(singlePixelPackedSampleModel.getBitMasks(), singlePixelPackedSampleModel2.getBitMasks());
            }
        }
        return false;
    }

    public static boolean isBinary(SampleModel sampleModel) {
        return sampleModel instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride() == 1 && sampleModel.getNumBands() == 1;
    }

    public static byte[] getPackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block29: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block27: {
                block30: {
                    block28: {
                        SampleModel sampleModel = raster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                        }
                        int n7 = rectangle.x;
                        int n8 = rectangle.y;
                        n6 = rectangle.width;
                        n5 = rectangle.height;
                        dataBuffer = raster.getDataBuffer();
                        int n9 = n7 - raster.getSampleModelTranslateX();
                        int n10 = n8 - raster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n4 = multiPixelPackedSampleModel.getScanlineStride();
                        n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                        n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                        n = (n6 + 7) / 8;
                        if (dataBuffer instanceof DataBufferByte && n3 == 0 && n2 == 0 && n == n4 && ((DataBufferByte)dataBuffer).getData().length == n * n5) {
                            return ((DataBufferByte)dataBuffer).getData();
                        }
                        byArray = new byte[n * n5];
                        int n11 = 0;
                        if (n2 != 0) break block27;
                        if (!(dataBuffer instanceof DataBufferByte)) break block28;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        int n12 = n;
                        int n13 = 0;
                        for (int i = 0; i < n5; ++i) {
                            System.arraycopy(byArray2, n3, byArray, n13, n12);
                            n13 += n12;
                            n3 += n4;
                        }
                        break block29;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block30;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    for (int i = 0; i < n5; ++i) {
                        int n14;
                        int n15 = n3;
                        for (n14 = n6; n14 > 8; n14 -= 16) {
                            short s = sArray[n15++];
                            byArray[n11++] = (byte)(s >>> 8 & 0xFF);
                            byArray[n11++] = (byte)(s & 0xFF);
                        }
                        if (n14 > 0) {
                            byArray[n11++] = (byte)(sArray[n15] >>> 8 & 0xFF);
                        }
                        n3 += n4;
                    }
                    break block29;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block29;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n16;
                    int n17;
                    int n18 = n3;
                    for (n17 = n6; n17 > 24; n17 -= 32) {
                        n16 = nArray[n18++];
                        byArray[n11++] = (byte)(n16 >>> 24 & 0xFF);
                        byArray[n11++] = (byte)(n16 >>> 16 & 0xFF);
                        byArray[n11++] = (byte)(n16 >>> 8 & 0xFF);
                        byArray[n11++] = (byte)(n16 & 0xFF);
                    }
                    n16 = 24;
                    while (n17 > 0) {
                        byArray[n11++] = (byte)(nArray[n18] >>> n16 & 0xFF);
                        n16 -= 8;
                        n17 -= 8;
                    }
                    n3 += n4;
                }
                break block29;
            }
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n2 & 7) == 0) {
                    int n19 = n;
                    int n20 = 0;
                    for (int i = 0; i < n5; ++i) {
                        System.arraycopy(byArray3, n3, byArray, n20, n19);
                        n20 += n19;
                        n3 += n4;
                    }
                } else {
                    int n21 = n2 & 7;
                    int n22 = 8 - n21;
                    for (int i = 0; i < n5; ++i) {
                        int n23 = n3;
                        for (int j = n6; j > 0; j -= 8) {
                            byArray[n11++] = j > n22 ? (byte)((byArray3[n23++] & 0xFF) << n21 | (byArray3[n23] & 0xFF) >>> n22) : (byte)((byArray3[n23] & 0xFF) << n21);
                        }
                        n3 += n4;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n24 = n2;
                    int n25 = 0;
                    while (n25 < n6) {
                        int n26 = n3 + n24 / 16;
                        int n27 = n24 % 16;
                        int n28 = sArray[n26] & 0xFFFF;
                        if (n27 <= 8) {
                            byArray[n11++] = (byte)(n28 >>> 8 - n27);
                        } else {
                            int n29 = n27 - 8;
                            int n30 = sArray[n26 + 1] & 0xFFFF;
                            byArray[n11++] = (byte)(n28 << n29 | n30 >>> 16 - n29);
                        }
                        n25 += 8;
                        n24 += 8;
                    }
                    n3 += n4;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n31 = n2;
                    int n32 = 0;
                    while (n32 < n6) {
                        int n33 = n3 + n31 / 32;
                        int n34 = n31 % 32;
                        int n35 = nArray[n33];
                        if (n34 <= 24) {
                            byArray[n11++] = (byte)(n35 >>> 24 - n34);
                        } else {
                            int n36 = n34 - 24;
                            int n37 = nArray[n33 + 1];
                            byArray[n11++] = (byte)(n35 << n36 | n37 >>> 32 - n36);
                        }
                        n32 += 8;
                        n31 += 8;
                    }
                    n3 += n4;
                }
            }
        }
        return byArray;
    }

    public static byte[] getUnpackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block8: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            block9: {
                block7: {
                    SampleModel sampleModel = raster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                    }
                    int n6 = rectangle.x;
                    int n7 = rectangle.y;
                    int n8 = rectangle.width;
                    int n9 = rectangle.height;
                    dataBuffer = raster.getDataBuffer();
                    int n10 = n6 - raster.getSampleModelTranslateX();
                    int n11 = n7 - raster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n5 = multiPixelPackedSampleModel.getScanlineStride();
                    n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                    n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                    byArray = new byte[n8 * n9];
                    n2 = n7 + n9;
                    n = n6 + n8;
                    int n12 = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block7;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    for (int i = n7; i < n2; ++i) {
                        int n13 = n4 * 8 + n3;
                        for (int j = n6; j < n; ++j) {
                            byte by = byArray2[n13 / 8];
                            byArray[n12++] = (byte)(by >>> (7 - n13 & 7) & 1);
                            ++n13;
                        }
                        n4 += n5;
                    }
                    break block8;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block9;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int i = n7; i < n2; ++i) {
                    int n14 = n4 * 16 + n3;
                    for (int j = n6; j < n; ++j) {
                        short s = sArray[n14 / 16];
                        byArray[n12++] = (byte)(s >>> 15 - n14 % 16 & 1);
                        ++n14;
                    }
                    n4 += n5;
                }
                break block8;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block8;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            for (int i = n7; i < n2; ++i) {
                int n15 = n4 * 32 + n3;
                for (int j = n6; j < n; ++j) {
                    int n16 = nArray[n15 / 32];
                    byArray[n12++] = (byte)(n16 >>> 31 - n15 % 32 & 1);
                    ++n15;
                }
                n4 += n5;
            }
        }
        return byArray;
    }

    public static void setPackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block41: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block39: {
                block42: {
                    block40: {
                        SampleModel sampleModel = writableRaster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                        }
                        int n7 = rectangle.x;
                        int n8 = rectangle.y;
                        n6 = rectangle.width;
                        n5 = rectangle.height;
                        dataBuffer = writableRaster.getDataBuffer();
                        int n9 = n7 - writableRaster.getSampleModelTranslateX();
                        int n10 = n8 - writableRaster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n4 = multiPixelPackedSampleModel.getScanlineStride();
                        n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                        n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                        n = 0;
                        if (n2 != 0) break block39;
                        if (!(dataBuffer instanceof DataBufferByte)) break block40;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        if (byArray2 == byArray) {
                            return;
                        }
                        int n11 = (n6 + 7) / 8;
                        int n12 = 0;
                        for (int i = 0; i < n5; ++i) {
                            System.arraycopy(byArray, n12, byArray2, n3, n11);
                            n12 += n11;
                            n3 += n4;
                        }
                        break block41;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block42;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    for (int i = 0; i < n5; ++i) {
                        int n13;
                        int n14 = n3;
                        for (n13 = n6; n13 > 8; n13 -= 16) {
                            sArray[n14++] = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                        }
                        if (n13 > 0) {
                            sArray[n14++] = (short)((byArray[n++] & 0xFF) << 8);
                        }
                        n3 += n4;
                    }
                    break block41;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block41;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n15;
                    int n16 = n3;
                    for (n15 = n6; n15 > 24; n15 -= 32) {
                        nArray[n16++] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    }
                    int n17 = 24;
                    while (n15 > 0) {
                        int n18 = n16;
                        nArray[n18] = nArray[n18] | (byArray[n++] & 0xFF) << n17;
                        n17 -= 8;
                        n15 -= 8;
                    }
                    n3 += n4;
                }
                break block41;
            }
            int n19 = (n6 + 7) / 8;
            int n20 = 0;
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n2 & 7) == 0) {
                    for (int i = 0; i < n5; ++i) {
                        System.arraycopy(byArray, n20, byArray3, n3, n19);
                        n20 += n19;
                        n3 += n4;
                    }
                } else {
                    int n21 = n2 & 7;
                    int n22 = 8 - n21;
                    int n23 = 8 + n22;
                    byte by = (byte)(255 << n22);
                    byte by2 = ~by;
                    for (int i = 0; i < n5; ++i) {
                        int n24 = n3;
                        for (int j = n6; j > 0; j -= 8) {
                            byte by3 = byArray[n++];
                            if (j > n23) {
                                byArray3[n24] = (byte)(byArray3[n24] & by | (by3 & 0xFF) >>> n21);
                                byArray3[++n24] = (byte)((by3 & 0xFF) << n22);
                                continue;
                            }
                            if (j > n22) {
                                byArray3[n24] = (byte)(byArray3[n24] & by | (by3 & 0xFF) >>> n21);
                                byArray3[++n24] = (byte)(byArray3[n24] & by2 | (by3 & 0xFF) << n22);
                                continue;
                            }
                            int n25 = (1 << n22 - j) - 1;
                            byArray3[n24] = (byte)(byArray3[n24] & (by | n25) | (by3 & 0xFF) >>> n21 & ~n25);
                        }
                        n3 += n4;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n26 = n2 & 7;
                int n27 = 8 - n26;
                int n28 = 16 + n27;
                short s = (short)(~(255 << n27));
                short s2 = (short)(65535 << n27);
                short s3 = ~s2;
                for (int i = 0; i < n5; ++i) {
                    int n29 = n2;
                    int n30 = n6;
                    int n31 = 0;
                    while (n31 < n6) {
                        int n32 = n3 + (n29 >> 4);
                        int n33 = n29 & 0xF;
                        int n34 = byArray[n++] & 0xFF;
                        if (n33 <= 8) {
                            if (n30 < 8) {
                                n34 &= 255 << 8 - n30;
                            }
                            sArray[n32] = (short)(sArray[n32] & s | n34 << n27);
                        } else if (n30 > n28) {
                            sArray[n32] = (short)(sArray[n32] & s2 | n34 >>> n26 & 0xFFFF);
                            sArray[++n32] = (short)(n34 << n27 & 0xFFFF);
                        } else if (n30 > n27) {
                            sArray[n32] = (short)(sArray[n32] & s2 | n34 >>> n26 & 0xFFFF);
                            sArray[++n32] = (short)(sArray[n32] & s3 | n34 << n27 & 0xFFFF);
                        } else {
                            int n35 = (1 << n27 - n30) - 1;
                            sArray[n32] = (short)(sArray[n32] & (s2 | n35) | n34 >>> n26 & 0xFFFF & ~n35);
                        }
                        n31 += 8;
                        n29 += 8;
                        n30 -= 8;
                    }
                    n3 += n4;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n36 = n2 & 7;
                int n37 = 8 - n36;
                int n38 = 32 + n37;
                int n39 = -1 << n37;
                int n40 = ~n39;
                for (int i = 0; i < n5; ++i) {
                    int n41 = n2;
                    int n42 = n6;
                    int n43 = 0;
                    while (n43 < n6) {
                        int n44;
                        int n45 = n3 + (n41 >> 5);
                        int n46 = n41 & 0x1F;
                        int n47 = byArray[n++] & 0xFF;
                        if (n46 <= 24) {
                            n44 = 24 - n46;
                            if (n42 < 8) {
                                n47 &= 255 << 8 - n42;
                            }
                            nArray[n45] = nArray[n45] & ~(255 << n44) | n47 << n44;
                        } else if (n42 > n38) {
                            nArray[n45] = nArray[n45] & n39 | n47 >>> n36;
                            nArray[++n45] = n47 << n37;
                        } else if (n42 > n37) {
                            nArray[n45] = nArray[n45] & n39 | n47 >>> n36;
                            nArray[++n45] = nArray[n45] & n40 | n47 << n37;
                        } else {
                            n44 = (1 << n37 - n42) - 1;
                            nArray[n45] = nArray[n45] & (n39 | n44) | n47 >>> n36 & ~n44;
                        }
                        n43 += 8;
                        n41 += 8;
                        n42 -= 8;
                    }
                    n3 += n4;
                }
            }
        }
    }

    public static void setUnpackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block11: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block12: {
                block10: {
                    SampleModel sampleModel = writableRaster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                    }
                    int n7 = rectangle.x;
                    int n8 = rectangle.y;
                    n6 = rectangle.width;
                    n5 = rectangle.height;
                    dataBuffer = writableRaster.getDataBuffer();
                    int n9 = n7 - writableRaster.getSampleModelTranslateX();
                    int n10 = n8 - writableRaster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n4 = multiPixelPackedSampleModel.getScanlineStride();
                    n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                    n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                    n = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block10;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    for (int i = 0; i < n5; ++i) {
                        int n11 = n3 * 8 + n2;
                        for (int j = 0; j < n6; ++j) {
                            if (byArray[n++] != 0) {
                                int n12 = n11 / 8;
                                byArray2[n12] = (byte)(byArray2[n12] | (byte)(1 << (7 - n11 & 7)));
                            }
                            ++n11;
                        }
                        n3 += n4;
                    }
                    break block11;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block12;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n13 = n3 * 16 + n2;
                    for (int j = 0; j < n6; ++j) {
                        if (byArray[n++] != 0) {
                            int n14 = n13 / 16;
                            sArray[n14] = (short)(sArray[n14] | (short)(1 << 15 - n13 % 16));
                        }
                        ++n13;
                    }
                    n3 += n4;
                }
                break block11;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block11;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            for (int i = 0; i < n5; ++i) {
                int n15 = n3 * 32 + n2;
                for (int j = 0; j < n6; ++j) {
                    if (byArray[n++] != 0) {
                        int n16 = n15 / 32;
                        nArray[n16] = nArray[n16] | 1 << 31 - n15 % 32;
                    }
                    ++n15;
                }
                n3 += n4;
            }
        }
    }

    public static void fillBackground(WritableRaster writableRaster, Rectangle rectangle, double[] dArray) {
        block44: {
            PixelAccessor pixelAccessor;
            block43: {
                rectangle = rectangle.intersection(writableRaster.getBounds());
                int n = writableRaster.getSampleModel().getNumBands();
                SampleModel sampleModel = writableRaster.getSampleModel();
                pixelAccessor = new PixelAccessor(sampleModel, null);
                if (!ImageUtil.isBinary(sampleModel)) break block43;
                byte by = (byte)((int)dArray[0] & 1);
                if (by == 0) {
                    return;
                }
                int n2 = rectangle.x;
                int n3 = rectangle.y;
                int n4 = rectangle.width;
                int n5 = rectangle.height;
                int n6 = n2 - writableRaster.getSampleModelTranslateX();
                int n7 = n3 - writableRaster.getSampleModelTranslateY();
                DataBuffer dataBuffer = writableRaster.getDataBuffer();
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                int n8 = multiPixelPackedSampleModel.getScanlineStride();
                int n9 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n6, n7);
                int n10 = multiPixelPackedSampleModel.getBitOffset(n6);
                switch (sampleModel.getDataType()) {
                    case 0: {
                        byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                        int n11 = n10 & 7;
                        int n12 = n11 == 0 ? 0 : 8 - n11;
                        byte by2 = (byte)(255 >> n11);
                        int n13 = (n4 - n12) / 8;
                        int n14 = n4 - n12 & 7;
                        byte by3 = (byte)(255 << 8 - n14);
                        if (n13 == 0) {
                            by2 = (byte)(by2 & by3);
                            n14 = 0;
                        }
                        for (int i = 0; i < n5; ++i) {
                            int n15 = n9;
                            int n16 = n15 + n13;
                            if (n11 != 0) {
                                int n17 = n15++;
                                byArray[n17] = (byte)(byArray[n17] | by2);
                            }
                            while (n15 < n16) {
                                byArray[n15++] = -1;
                            }
                            if (n14 != 0) {
                                int n18 = n15;
                                byArray[n18] = (byte)(byArray[n18] | by3);
                            }
                            n9 += n8;
                        }
                        break block44;
                    }
                    case 1: {
                        short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                        int n19 = n10 & 0xF;
                        int n20 = n19 == 0 ? 0 : 16 - n19;
                        short s = (short)(65535 >> n19);
                        int n21 = (n4 - n20) / 16;
                        int n22 = n4 - n20 & 0xF;
                        short s2 = (short)(65535 << 16 - n22);
                        if (n21 == 0) {
                            s = (short)(s & s2);
                            n22 = 0;
                        }
                        for (int i = 0; i < n5; ++i) {
                            int n23 = n9;
                            int n24 = n23 + n21;
                            if (n19 != 0) {
                                int n25 = n23++;
                                sArray[n25] = (short)(sArray[n25] | s);
                            }
                            while (n23 < n24) {
                                sArray[n23++] = -1;
                            }
                            if (n22 != 0) {
                                int n26 = n23++;
                                sArray[n26] = (short)(sArray[n26] | s2);
                            }
                            n9 += n8;
                        }
                        break block44;
                    }
                    case 3: {
                        int[] nArray = ((DataBufferInt)dataBuffer).getData();
                        int n27 = n10 & 0x1F;
                        int n28 = n27 == 0 ? 0 : 32 - n27;
                        int n29 = -1 >> n27;
                        int n30 = (n4 - n28) / 32;
                        int n31 = n4 - n28 & 0x1F;
                        int n32 = -1 << 32 - n31;
                        if (n30 == 0) {
                            n29 &= n32;
                            n31 = 0;
                        }
                        for (int i = 0; i < n5; ++i) {
                            int n33 = n9;
                            int n34 = n33 + n30;
                            if (n27 != 0) {
                                int n35 = n33++;
                                nArray[n35] = nArray[n35] | n29;
                            }
                            while (n33 < n34) {
                                nArray[n33++] = -1;
                            }
                            if (n31 != 0) {
                                int n36 = n33++;
                                nArray[n36] = nArray[n36] | n32;
                            }
                            n9 += n8;
                        }
                        break block44;
                    }
                }
                break block44;
            }
            int n = pixelAccessor.sampleType == -1 ? 0 : pixelAccessor.sampleType;
            UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n, false);
            rectangle = unpackedImageData.rect;
            int n37 = unpackedImageData.lineStride;
            int n38 = unpackedImageData.pixelStride;
            switch (unpackedImageData.type) {
                case 0: {
                    byte[][] byArray = unpackedImageData.getByteData();
                    for (int i = 0; i < pixelAccessor.numBands; ++i) {
                        byte by = (byte)dArray[i];
                        byte[] byArray2 = byArray[i];
                        int n39 = unpackedImageData.bandOffsets[i] + rectangle.height * n37;
                        for (int j = unpackedImageData.bandOffsets[i]; j < n39; j += n37) {
                            int n40 = j + rectangle.width * n38;
                            for (int k = j; k < n40; k += n38) {
                                byArray2[k] = by;
                            }
                        }
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sArray = unpackedImageData.getShortData();
                    for (int i = 0; i < pixelAccessor.numBands; ++i) {
                        short s = (short)dArray[i];
                        short[] sArray2 = sArray[i];
                        int n41 = unpackedImageData.bandOffsets[i] + rectangle.height * n37;
                        for (int j = unpackedImageData.bandOffsets[i]; j < n41; j += n37) {
                            int n42 = j + rectangle.width * n38;
                            for (int k = j; k < n42; k += n38) {
                                sArray2[k] = s;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    int[][] nArray = unpackedImageData.getIntData();
                    for (int i = 0; i < pixelAccessor.numBands; ++i) {
                        int n43 = (int)dArray[i];
                        int[] nArray2 = nArray[i];
                        int n44 = unpackedImageData.bandOffsets[i] + rectangle.height * n37;
                        for (int j = unpackedImageData.bandOffsets[i]; j < n44; j += n37) {
                            int n45 = j + rectangle.width * n38;
                            for (int k = j; k < n45; k += n38) {
                                nArray2[k] = n43;
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    float[][] fArray = unpackedImageData.getFloatData();
                    for (int i = 0; i < pixelAccessor.numBands; ++i) {
                        float f = (float)dArray[i];
                        float[] fArray2 = fArray[i];
                        int n46 = unpackedImageData.bandOffsets[i] + rectangle.height * n37;
                        for (int j = unpackedImageData.bandOffsets[i]; j < n46; j += n37) {
                            int n47 = j + rectangle.width * n38;
                            for (int k = j; k < n47; k += n38) {
                                fArray2[k] = f;
                            }
                        }
                    }
                    break;
                }
                case 5: {
                    double[][] dArray2 = unpackedImageData.getDoubleData();
                    for (int i = 0; i < pixelAccessor.numBands; ++i) {
                        double d = dArray[i];
                        double[] dArray3 = dArray2[i];
                        int n48 = unpackedImageData.bandOffsets[i] + rectangle.height * n37;
                        for (int j = unpackedImageData.bandOffsets[i]; j < n48; j += n37) {
                            int n49 = j + rectangle.width * n38;
                            for (int k = j; k < n49; k += n38) {
                                dArray3[k] = d;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public static void fillBordersWithBackgroundValues(Rectangle rectangle, Rectangle rectangle2, WritableRaster writableRaster, double[] dArray) {
        Rectangle rectangle3;
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle2.x + rectangle2.width;
        int n4 = rectangle2.y + rectangle2.height;
        if (rectangle.x < rectangle2.x) {
            rectangle3 = new Rectangle(rectangle.x, rectangle2.y, rectangle2.x - rectangle.x, n2 - rectangle2.y);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
        if (rectangle.y < rectangle2.y) {
            rectangle3 = new Rectangle(rectangle.x, rectangle.y, n3 - rectangle.x, rectangle2.y - rectangle.y);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
        if (n > n3) {
            rectangle3 = new Rectangle(n3, rectangle.y, n - n3, n4 - rectangle.y);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
        if (n2 > n4) {
            rectangle3 = new Rectangle(rectangle2.x, n4, n - rectangle2.x, n2 - n4);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
    }

    public static KernelJAI getUnsharpMaskEquivalentKernel(KernelJAI kernelJAI, float f) {
        int n;
        int n2 = kernelJAI.getWidth();
        int n3 = kernelJAI.getHeight();
        int n4 = kernelJAI.getXOrigin();
        int n5 = kernelJAI.getYOrigin();
        float[] fArray = kernelJAI.getKernelData();
        float[] fArray2 = new float[fArray.length];
        for (n = 0; n < n2 * n3; ++n) {
            fArray2[n] = -f * fArray[n];
        }
        n = n5 * n2 + n4;
        fArray2[n] = 1.0f + f * (1.0f - fArray[n]);
        return new KernelJAI(n2, n3, n4, n5, fArray2);
    }

    public static final Point[] getTileIndices(int n, int n2, int n3, int n4) {
        if (n > n2 || n3 > n4) {
            return null;
        }
        Point[] pointArray = new Point[(n2 - n + 1) * (n4 - n3 + 1)];
        int n5 = 0;
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                pointArray[n5++] = new Point(j, i);
            }
        }
        return pointArray;
    }

    public static Vector evaluateParameters(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException();
        }
        Vector vector2 = vector;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.get(i);
            if (!(e instanceof DeferredData)) continue;
            if (vector2 == vector) {
                vector2 = (Vector)vector.clone();
            }
            vector2.set(i, ((DeferredData)e).getData());
        }
        return vector2;
    }

    public static ParameterBlock evaluateParameters(ParameterBlock parameterBlock) {
        if (parameterBlock == null) {
            throw new IllegalArgumentException();
        }
        Vector<Object> vector = parameterBlock.getParameters();
        Vector vector2 = ImageUtil.evaluateParameters(vector);
        return vector2 == vector ? parameterBlock : new ParameterBlock(parameterBlock.getSources(), vector2);
    }

    public static ColorModel getCompatibleColorModel(SampleModel sampleModel, Map map) {
        ColorModel colorModel = null;
        if (map == null || !Boolean.FALSE.equals(map.get(JAI.KEY_DEFAULT_COLOR_MODEL_ENABLED))) {
            if (map != null && map.containsKey(JAI.KEY_DEFAULT_COLOR_MODEL_METHOD)) {
                Method method = (Method)map.get(JAI.KEY_DEFAULT_COLOR_MODEL_METHOD);
                Class<?>[] classArray = method.getParameterTypes();
                if ((method.getModifiers() & 8) != 8) {
                    throw new RuntimeException(JaiI18N.getString("ImageUtil1"));
                }
                if (method.getReturnType() != ColorModel.class) {
                    throw new RuntimeException(JaiI18N.getString("ImageUtil2"));
                }
                if (classArray.length != 1 || !classArray[0].equals(SampleModel.class)) {
                    throw new RuntimeException(JaiI18N.getString("ImageUtil3"));
                }
                try {
                    Object[] objectArray = new Object[]{sampleModel};
                    colorModel = (ColorModel)method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    String string = JaiI18N.getString("ImageUtil4") + method.getName();
                    ImageUtil.sendExceptionToListener(string, new ImagingException(string, exception));
                }
            } else {
                colorModel = PlanarImage.createColorModel(sampleModel);
            }
        }
        return colorModel;
    }

    public static String getStackTraceString(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public static ImagingListener getImagingListener(RenderingHints renderingHints) {
        ImagingListener imagingListener = null;
        if (renderingHints != null) {
            imagingListener = (ImagingListener)renderingHints.get(JAI.KEY_IMAGING_LISTENER);
        }
        if (imagingListener == null) {
            imagingListener = JAI.getDefaultInstance().getImagingListener();
        }
        return imagingListener;
    }

    public static ImagingListener getImagingListener(RenderContext renderContext) {
        return ImageUtil.getImagingListener(renderContext.getRenderingHints());
    }

    public static synchronized Object generateID(Object object) {
        Class<?> clazz = object.getClass();
        ++counter;
        byte[] byArray = new byte[32];
        int n = 0;
        int n2 = 7;
        int n3 = 0;
        while (n2 >= 0) {
            byArray[n++] = (byte)(counter >> n3);
            --n2;
            n3 += 8;
        }
        n2 = clazz.hashCode();
        n3 = 3;
        int n4 = 0;
        while (n3 >= 0) {
            byArray[n++] = (byte)(n2 >> n4);
            --n3;
            n4 += 8;
        }
        n2 = object.hashCode();
        n3 = 3;
        n4 = 0;
        while (n3 >= 0) {
            byArray[n++] = (byte)(n2 >> n4);
            --n3;
            n4 += 8;
        }
        long l = System.currentTimeMillis();
        int n5 = 7;
        int n6 = 0;
        while (n5 >= 0) {
            byArray[n++] = (byte)(l >> n6);
            --n5;
            n6 += 8;
        }
        long l2 = Double.doubleToLongBits(new Double(Math.random()));
        int n7 = 7;
        int n8 = 0;
        while (n7 >= 0) {
            byArray[n++] = (byte)(l2 >> n8);
            --n7;
            n8 += 8;
        }
        return new BigInteger(byArray);
    }

    static void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
        imagingListener.errorOccurred(string, exception, ImageUtil.class, false);
    }
}

