/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationRegistry;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.RegistryMode;
import javax.media.jai.util.CaselessStringKey;

class RegistryFileParser {
    private URL url;
    private InputStream is;
    private ClassLoader classLoader;
    private OperationRegistry or;
    private StreamTokenizer st;
    private int token;
    private int lineno;
    private Hashtable localNamesTable;
    private static String[][] aliases = new String[][]{{"odesc", "descriptor"}, {"rif", "rendered"}, {"crif", "renderable"}, {"cif", "collection"}};
    private boolean headerLinePrinted = false;

    static void loadOperationRegistry(OperationRegistry operationRegistry, ClassLoader classLoader, InputStream inputStream) throws IOException {
        new RegistryFileParser(operationRegistry, classLoader, inputStream).parseFile();
    }

    static void loadOperationRegistry(OperationRegistry operationRegistry, ClassLoader classLoader, URL uRL) throws IOException {
        new RegistryFileParser(operationRegistry, classLoader, uRL).parseFile();
    }

    private RegistryFileParser(OperationRegistry operationRegistry, ClassLoader classLoader, URL uRL) throws IOException {
        this(operationRegistry, classLoader, uRL.openStream());
        this.url = uRL;
    }

    private RegistryFileParser(OperationRegistry operationRegistry, ClassLoader classLoader, InputStream inputStream) throws IOException {
        if (operationRegistry == null) {
            operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        }
        this.is = inputStream;
        this.url = null;
        this.or = operationRegistry;
        this.classLoader = classLoader;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.st = new StreamTokenizer(bufferedReader);
        this.st.commentChar(35);
        this.st.eolIsSignificant(true);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.token = this.st.ttype;
        this.lineno = -1;
        this.localNamesTable = new Hashtable();
        String[] stringArray = RegistryMode.getModeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.localNamesTable.put(new CaselessStringKey(stringArray[i]), new Hashtable());
        }
    }

    private int skipEmptyTokens() throws IOException {
        while (this.st.sval == null) {
            if (this.token == -1) {
                return this.token;
            }
            this.token = this.st.nextToken();
        }
        return this.token;
    }

    private String[] getNextLine() throws IOException {
        if (this.skipEmptyTokens() == -1) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        this.lineno = this.st.lineno();
        while (this.token != 10 && this.token != -1) {
            if (this.st.sval != null) {
                vector.addElement(this.st.sval);
            }
            this.token = this.st.nextToken();
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new String[0]);
    }

    private String mapName(String string) {
        for (int i = 0; i < aliases.length; ++i) {
            if (!string.equalsIgnoreCase(aliases[i][0])) continue;
            return aliases[i][1];
        }
        return string;
    }

    private Object getInstance(String string) {
        try {
            Class<?> clazz = null;
            String string2 = null;
            if (this.classLoader != null) {
                try {
                    clazz = Class.forName(string, true, this.classLoader);
                }
                catch (Exception exception) {
                    string2 = exception.getMessage();
                }
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName(string);
                }
                catch (Exception exception) {
                    string2 = exception.getMessage();
                }
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName(string, true, ClassLoader.getSystemClassLoader());
                }
                catch (Exception exception) {
                    string2 = exception.getMessage();
                }
            }
            if (clazz == null) {
                this.registryFileError(string2);
                return null;
            }
            return clazz.newInstance();
        }
        catch (Exception exception) {
            this.registryFileError(exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    boolean parseFile() throws IOException {
        String[] stringArray;
        if (this.token == -1) {
            return true;
        }
        this.token = this.st.nextToken();
        while (this.token != -1 && (stringArray = this.getNextLine()) != null) {
            RegistryMode registryMode;
            String string = this.mapName(stringArray[0]);
            if (string.equalsIgnoreCase("registryMode")) {
                registryMode = (RegistryMode)this.getInstance(stringArray[1]);
                if (registryMode == null || RegistryMode.addMode(registryMode)) continue;
                this.registryFileError(JaiI18N.getString("RegistryFileParser10"));
                continue;
            }
            if (string.equalsIgnoreCase("descriptor")) {
                this.registerDescriptor(stringArray);
                continue;
            }
            registryMode = RegistryMode.getMode(string);
            if (registryMode != null) {
                this.registerFactory(registryMode, stringArray);
                continue;
            }
            if (string.equalsIgnoreCase("pref")) {
                string = this.mapName(stringArray[1]);
                if (string.equalsIgnoreCase("product")) {
                    this.setProductPreference(RegistryMode.getMode("rendered"), stringArray);
                    continue;
                }
                registryMode = RegistryMode.getMode(string);
                if (registryMode != null) {
                    this.setFactoryPreference(registryMode, stringArray);
                    continue;
                }
                this.registryFileError(JaiI18N.getString("RegistryFileParser4"));
                continue;
            }
            if (string.equalsIgnoreCase("productPref")) {
                string = this.mapName(stringArray[1]);
                registryMode = RegistryMode.getMode(string);
                if (registryMode != null) {
                    this.setProductPreference(registryMode, stringArray);
                    continue;
                }
                this.registryFileError(JaiI18N.getString("RegistryFileParser5"));
                continue;
            }
            this.registryFileError(JaiI18N.getString("RegistryFileParser6"));
        }
        if (this.url != null) {
            this.is.close();
        }
        return true;
    }

    private void registerDescriptor(String[] stringArray) {
        if (stringArray.length >= 2) {
            RegistryElementDescriptor registryElementDescriptor = (RegistryElementDescriptor)this.getInstance(stringArray[1]);
            if (registryElementDescriptor != null) {
                try {
                    this.or.registerDescriptor(registryElementDescriptor);
                }
                catch (Exception exception) {
                    this.registryFileError(exception.getMessage());
                }
            }
        } else {
            this.registryFileError(JaiI18N.getString("RegistryFileParser1"));
        }
    }

    private void registerFactory(RegistryMode registryMode, String[] stringArray) {
        if (registryMode.arePreferencesSupported()) {
            if (stringArray.length >= 5) {
                Object object = this.getInstance(stringArray[1]);
                if (object != null) {
                    try {
                        this.or.registerFactory(registryMode.getName(), stringArray[3], stringArray[2], object);
                        this.mapLocalNameToObject(registryMode.getName(), stringArray[4], object);
                    }
                    catch (Exception exception) {
                        this.registryFileError(exception.getMessage());
                    }
                }
            } else {
                this.registryFileError(JaiI18N.getString("RegistryFileParser2"));
            }
        } else if (stringArray.length >= 3) {
            Object object = this.getInstance(stringArray[1]);
            if (object != null) {
                try {
                    this.or.registerFactory(registryMode.getName(), stringArray[2], null, object);
                }
                catch (Exception exception) {
                    this.registryFileError(exception.getMessage());
                }
            }
        } else {
            this.registryFileError(JaiI18N.getString("RegistryFileParser3"));
        }
    }

    private void setProductPreference(RegistryMode registryMode, String[] stringArray) {
        String string = registryMode.getName();
        if (registryMode.arePreferencesSupported()) {
            if (stringArray.length >= 5) {
                try {
                    this.or.setProductPreference(string, stringArray[2], stringArray[3], stringArray[4]);
                }
                catch (Exception exception) {
                    this.registryFileError(exception.getMessage());
                }
            } else {
                this.registryFileError(JaiI18N.getString("RegistryFileParser5"));
            }
        } else {
            this.registryFileError(JaiI18N.getString("RegistryFileParser9"));
        }
    }

    private void setFactoryPreference(RegistryMode registryMode, String[] stringArray) {
        String string = registryMode.getName();
        if (registryMode.arePreferencesSupported()) {
            if (stringArray.length >= 6) {
                Object object = this.getObjectFromLocalName(string, stringArray[4]);
                Object object2 = this.getObjectFromLocalName(string, stringArray[5]);
                if (object != null && object2 != null) {
                    try {
                        this.or.setFactoryPreference(string, stringArray[2], stringArray[3], object, object2);
                    }
                    catch (Exception exception) {
                        this.registryFileError(exception.getMessage());
                    }
                }
            } else {
                this.registryFileError(JaiI18N.getString("RegistryFileParser4"));
            }
        } else {
            this.registryFileError(JaiI18N.getString("RegistryFileParser7"));
        }
    }

    private void mapLocalNameToObject(String string, String string2, Object object) {
        Hashtable hashtable = (Hashtable)this.localNamesTable.get(new CaselessStringKey(string));
        hashtable.put(new CaselessStringKey(string2), object);
    }

    private Object getObjectFromLocalName(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.localNamesTable.get(new CaselessStringKey(string));
        Object v = hashtable.get(new CaselessStringKey(string2));
        if (v == null) {
            this.registryFileError(string2 + ": " + JaiI18N.getString("RegistryFileParser8"));
        }
        return v;
    }

    private void registryFileError(String string) {
        if (!this.headerLinePrinted) {
            if (this.url != null) {
                this.errorMsg(JaiI18N.getString("RegistryFileParser11"), new Object[]{this.url.getPath()});
            }
            this.headerLinePrinted = true;
        }
        this.errorMsg(JaiI18N.getString("RegistryFileParser0"), new Object[]{new Integer(this.lineno)});
        if (string != null) {
            this.errorMsg(string, null);
        }
    }

    private void errorMsg(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        messageFormat.setLocale(Locale.getDefault());
        if (System.err != null) {
            System.err.println(messageFormat.format(objectArray));
        }
    }

    static void writeOperationRegistry(OperationRegistry operationRegistry, OutputStream outputStream) throws IOException {
        RegistryFileParser.writeOperationRegistry(operationRegistry, new BufferedWriter(new OutputStreamWriter(outputStream)));
    }

    static void writeOperationRegistry(OperationRegistry operationRegistry, BufferedWriter bufferedWriter) throws IOException {
        Iterator iterator = RegistryMode.getDescriptorClasses().iterator();
        String string = "  ";
        while (iterator.hasNext()) {
            String[] stringArray;
            Class clazz = (Class)iterator.next();
            List list = operationRegistry.getDescriptors(clazz);
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            bufferedWriter.write("# Descriptors corresponding to class : " + clazz.getName());
            bufferedWriter.newLine();
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            if (list == null || list.size() <= 0) {
                bufferedWriter.write("# <EMPTY>");
                bufferedWriter.newLine();
            } else {
                stringArray = list.iterator();
                while (stringArray.hasNext()) {
                    bufferedWriter.write("descriptor" + string);
                    bufferedWriter.write(stringArray.next().getClass().getName());
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.newLine();
            stringArray = RegistryMode.getModeNames(clazz);
            for (int i = 0; i < stringArray.length; ++i) {
                Object[][] objectArray;
                int n;
                Object object;
                Object object2;
                int n2;
                bufferedWriter.write("#");
                bufferedWriter.newLine();
                bufferedWriter.write("# Factories registered under mode : " + stringArray[i]);
                bufferedWriter.newLine();
                bufferedWriter.write("#");
                bufferedWriter.newLine();
                RegistryMode registryMode = RegistryMode.getMode(stringArray[i]);
                boolean bl = registryMode.arePreferencesSupported();
                String[] stringArray2 = operationRegistry.getDescriptorNames(stringArray[i]);
                boolean bl2 = true;
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    if (bl) {
                        object2 = operationRegistry.getOrderedProductList(stringArray[i], stringArray2[n2]);
                        if (object2 == null) continue;
                        object = ((Vector)object2).toArray(new String[0]);
                        for (n = 0; n < ((E)object).length; ++n) {
                            objectArray = operationRegistry.getOrderedFactoryList(stringArray[i], stringArray2[n2], (String)object[n]);
                            for (Object e : objectArray) {
                                if (e == null) continue;
                                bufferedWriter.write(stringArray[i] + string);
                                bufferedWriter.write(e.getClass().getName() + string);
                                bufferedWriter.write((String)object[n] + string);
                                bufferedWriter.write(stringArray2[n2] + string);
                                bufferedWriter.write(operationRegistry.getLocalName(stringArray[i], e));
                                bufferedWriter.newLine();
                                bl2 = false;
                            }
                        }
                        continue;
                    }
                    object2 = operationRegistry.getFactoryIterator(stringArray[i], stringArray2[n2]);
                    while (object2.hasNext()) {
                        object = object2.next();
                        if (object == null) continue;
                        bufferedWriter.write(stringArray[i] + string);
                        bufferedWriter.write(object.getClass().getName() + string);
                        bufferedWriter.write(stringArray2[n2]);
                        bufferedWriter.newLine();
                        bl2 = false;
                    }
                }
                if (bl2) {
                    bufferedWriter.write("# <EMPTY>");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
                if (!bl) {
                    bufferedWriter.write("#");
                    bufferedWriter.newLine();
                    bufferedWriter.write("# Preferences not supported for mode : " + stringArray[i]);
                    bufferedWriter.newLine();
                    bufferedWriter.write("#");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    continue;
                }
                bufferedWriter.write("#");
                bufferedWriter.newLine();
                bufferedWriter.write("# Product preferences for mode : " + stringArray[i]);
                bufferedWriter.newLine();
                bufferedWriter.write("#");
                bufferedWriter.newLine();
                bl2 = true;
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    object2 = operationRegistry.getProductPreferences(stringArray[i], stringArray2[n2]);
                    if (object2 == null) continue;
                    for (n = 0; n < ((String[][])object2).length; ++n) {
                        bufferedWriter.write("productPref" + string);
                        bufferedWriter.write(stringArray[i] + string);
                        bufferedWriter.write(stringArray2[n2] + string);
                        bufferedWriter.write((String)object2[n][0] + string);
                        bufferedWriter.write((String)object2[n][1]);
                        bufferedWriter.newLine();
                        bl2 = false;
                    }
                }
                if (bl2) {
                    bufferedWriter.write("# <EMPTY>");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
                bufferedWriter.write("#");
                bufferedWriter.newLine();
                bufferedWriter.write("# Factory preferences for mode : " + stringArray[i]);
                bufferedWriter.newLine();
                bufferedWriter.write("#");
                bufferedWriter.newLine();
                bl2 = true;
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    if (!bl || (object2 = operationRegistry.getOrderedProductList(stringArray[i], stringArray2[n2])) == null) continue;
                    object = ((Vector)object2).toArray(new String[0]);
                    for (n = 0; n < ((Object)object).length; ++n) {
                        objectArray = operationRegistry.getFactoryPreferences(stringArray[i], stringArray2[n2], (String)object[n]);
                        if (objectArray == null) continue;
                        for (int j = 0; j < objectArray.length; ++j) {
                            bufferedWriter.write("pref" + string);
                            bufferedWriter.write(stringArray[i] + string);
                            bufferedWriter.write(stringArray2[n2] + string);
                            bufferedWriter.write((String)object[n] + string);
                            bufferedWriter.write(operationRegistry.getLocalName(stringArray[i], objectArray[j][0]) + string);
                            bufferedWriter.write(operationRegistry.getLocalName(stringArray[i], objectArray[j][1]));
                            bufferedWriter.newLine();
                            bl2 = false;
                        }
                    }
                }
                if (bl2) {
                    bufferedWriter.write("# <EMPTY>");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.flush();
    }
}

