/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

class TiledImageGraphics
extends Graphics2D {
    private static final Class GRAPHICS2D_CLASS = Graphics2D.class;
    private static final int PAINT_MODE = 1;
    private static final int XOR_MODE = 2;
    private TiledImage tiledImage;
    Hashtable properties;
    private RenderingHints renderingHints;
    private int tileWidth;
    private int tileHeight;
    private int tileXMinimum;
    private int tileXMaximum;
    private int tileYMinimum;
    private int tileYMaximum;
    private ColorModel colorModel;
    private Point origin;
    private Shape clip;
    private Color color;
    private Font font;
    private int paintMode = 1;
    private Color XORColor;
    private Color background;
    private Composite composite;
    private Paint paint;
    private Stroke stroke;
    private AffineTransform transform;

    private static final Rectangle getBoundingBox(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3;
        if (n <= 0) {
            return null;
        }
        int n4 = n3 = nArray[0];
        int n5 = n2 = nArray2[0];
        for (int i = 1; i < n; ++i) {
            n4 = Math.min(n4, nArray[i]);
            n3 = Math.max(n3, nArray[i]);
            n5 = Math.min(n5, nArray2[i]);
            n2 = Math.max(n2, nArray2[i]);
        }
        return new Rectangle(n4, n5, n3 - n4 + 1, n2 - n5 + 1);
    }

    public TiledImageGraphics(TiledImage tiledImage) {
        int n = tiledImage.getSampleModel().getTransferType();
        if (n != 0 && n != 2 && n != 1 && n != 3) {
            throw new UnsupportedOperationException(JaiI18N.getString("TiledImageGraphics0"));
        }
        this.tiledImage = tiledImage;
        this.tileWidth = tiledImage.getTileWidth();
        this.tileHeight = tiledImage.getTileHeight();
        this.tileXMinimum = tiledImage.getMinTileX();
        this.tileXMaximum = tiledImage.getMaxTileX();
        this.tileYMinimum = tiledImage.getMinTileY();
        this.tileYMaximum = tiledImage.getMaxTileY();
        this.colorModel = TiledImageGraphics.getColorModel(this.tiledImage);
        Graphics2D graphics2D = this.getBogusGraphics2D(false);
        this.origin = new Point(0, 0);
        this.setClip(this.tiledImage.getBounds());
        this.setColor(graphics2D.getColor());
        this.setFont(graphics2D.getFont());
        this.setPaintMode();
        this.setBackground(graphics2D.getBackground());
        this.setComposite(graphics2D.getComposite());
        this.setStroke(graphics2D.getStroke());
        this.setTransform(graphics2D.getTransform());
        graphics2D.dispose();
        this.properties = this.tiledImage.getProperties();
        this.renderingHints = new RenderingHints(this.properties);
    }

    private void copyState(Graphics2D graphics2D) {
        graphics2D.translate(this.origin.x, this.origin.y);
        this.setClip(this.getClip());
        graphics2D.setColor(this.getColor());
        if (this.paintMode == 1) {
            graphics2D.setPaintMode();
        } else if (this.XORColor != null) {
            graphics2D.setXORMode(this.XORColor);
        }
        graphics2D.setFont(this.getFont());
        graphics2D.setBackground(this.getBackground());
        graphics2D.setComposite(this.getComposite());
        if (this.paint != null) {
            graphics2D.setPaint(this.getPaint());
        }
        graphics2D.setRenderingHints(this.renderingHints);
        graphics2D.setStroke(this.getStroke());
        graphics2D.setTransform(this.getTransform());
    }

    private Graphics2D getBogusGraphics2D(boolean bl) {
        Raster raster = this.tiledImage.getTile(this.tileXMinimum, this.tileYMinimum);
        WritableRaster writableRaster = raster.createCompatibleWritableRaster(1, 1);
        BufferedImage bufferedImage = new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), this.properties);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            this.copyState(graphics2D);
        }
        return graphics2D;
    }

    private static ColorModel getColorModel(TiledImage tiledImage) {
        ColorModel colorModel = tiledImage.getColorModel();
        if (colorModel == null && colorModel == null) {
            ColorModel colorModel2;
            SampleModel sampleModel = tiledImage.getSampleModel();
            colorModel = PlanarImage.createColorModel(sampleModel);
            if (colorModel == null && JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel2 = ColorModel.getRGBdefault())) {
                colorModel = colorModel2;
            }
            if (colorModel == null) {
                throw new UnsupportedOperationException(JaiI18N.getString("TiledImageGraphics1"));
            }
        }
        return colorModel;
    }

    private boolean doGraphicsOp(int n, int n2, int n3, int n4, String string, Class[] classArray, Object[] objectArray) {
        int n5;
        int n6;
        int n7;
        boolean bl = false;
        Method method = null;
        try {
            method = GRAPHICS2D_CLASS.getMethod(string, classArray);
        }
        catch (Exception exception) {
            String string2 = JaiI18N.getString("TiledImageGraphics2") + string;
            this.sendExceptionToListener(string2, new ImagingException(exception));
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        rectangle = this.getTransform().createTransformedShape(rectangle).getBounds();
        int n8 = this.tiledImage.XToTileX(rectangle.x);
        if (n8 < this.tileXMinimum) {
            n8 = this.tileXMinimum;
        }
        if ((n7 = this.tiledImage.YToTileY(rectangle.y)) < this.tileYMinimum) {
            n7 = this.tileYMinimum;
        }
        if ((n6 = this.tiledImage.XToTileX(rectangle.x + rectangle.width - 1)) > this.tileXMaximum) {
            n6 = this.tileXMaximum;
        }
        if ((n5 = this.tiledImage.YToTileY(rectangle.y + rectangle.height - 1)) > this.tileYMaximum) {
            n5 = this.tileYMaximum;
        }
        for (int i = n7; i <= n5; ++i) {
            int n9 = this.tiledImage.tileYToY(i);
            for (int j = n8; j <= n6; ++j) {
                Object object;
                Object object2;
                int n10 = this.tiledImage.tileXToX(j);
                WritableRaster writableRaster = this.tiledImage.getWritableTile(j, i);
                writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                BufferedImage bufferedImage = new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), this.properties);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                this.copyState(graphics2D);
                try {
                    object2 = graphics2D.getTransform().transform(new Point2D.Double(), null);
                    object = new Point((int)((Point2D)object2).getX() - n10, (int)((Point2D)object2).getY() - n9);
                    Point2D point2D = graphics2D.getTransform().inverseTransform((Point2D)object, null);
                    graphics2D.translate(point2D.getX(), point2D.getY());
                }
                catch (Exception exception) {
                    object = JaiI18N.getString("TiledImageGraphics3");
                    this.sendExceptionToListener((String)object, new ImagingException(exception));
                }
                try {
                    object2 = method.invoke((Object)graphics2D, objectArray);
                    if (object2 != null && object2.getClass() == Boolean.TYPE) {
                        bl = (Boolean)object2;
                    }
                }
                catch (Exception exception) {
                    object = JaiI18N.getString("TiledImageGraphics3") + " " + string;
                    this.sendExceptionToListener((String)object, new ImagingException(exception));
                }
                graphics2D.dispose();
                this.tiledImage.releaseWritableTile(j, i);
            }
        }
        return bl;
    }

    private boolean doGraphicsOp(Shape shape, String string, Class[] classArray, Object[] objectArray) {
        Rectangle rectangle = shape.getBounds();
        return this.doGraphicsOp(rectangle.x, rectangle.y, rectangle.width, rectangle.height, string, classArray, objectArray);
    }

    public Graphics create() {
        TiledImageGraphics tiledImageGraphics = new TiledImageGraphics(this.tiledImage);
        this.copyState(tiledImageGraphics);
        return tiledImageGraphics;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPaintMode() {
        this.paintMode = 1;
    }

    public void setXORMode(Color color) {
        this.paintMode = 2;
        this.XORColor = color;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public FontMetrics getFontMetrics(Font font) {
        Graphics2D graphics2D = this.getBogusGraphics2D(true);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        graphics2D.dispose();
        return fontMetrics;
    }

    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setClip(Shape shape) {
        this.clip = shape;
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(new int[]{n, n + n5, n + n3 - 1, n + n3 - 1 + n5}, new int[]{n2, n2 + n6, n2 + n4 - 1, n2 + n4 - 1 + n6}, 4);
        this.doGraphicsOp(rectangle, "copyArea", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(new int[]{n, n3}, new int[]{n2, n4}, 2);
        this.doGraphicsOp(rectangle, "drawLine", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.doGraphicsOp(n, n2, n3, n4, "fillRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.doGraphicsOp(n, n2, n3, n4, "clearRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doGraphicsOp(n - n5, n2 - n6, n3 + 2 * n5, n4 + 2 * n6, "drawRoundRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doGraphicsOp(n - n5, n2 - n6, n3 + 2 * n5, n4 + 2 * n6, "fillRoundRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.doGraphicsOp(n, n2, n3, n4, "draw3DRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Boolean(bl)});
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.doGraphicsOp(n, n2, n3, n4, "fill3DRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Boolean(bl)});
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.doGraphicsOp(n, n2, n3, n4, "drawOval", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.doGraphicsOp(n, n2, n3, n4, "fillOval", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doGraphicsOp(n, n2, n3, n4, "drawArc", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doGraphicsOp(n, n2, n3, n4, "fillArc", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Class<?> clazz = nArray.getClass();
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(nArray, nArray2, n);
        if (rectangle == null) {
            return;
        }
        this.doGraphicsOp(rectangle, "drawPolyline", new Class[]{clazz, clazz, Integer.TYPE}, new Object[]{nArray, nArray2, new Integer(n)});
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Class<?> clazz = nArray.getClass();
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(nArray, nArray2, n);
        if (rectangle == null) {
            return;
        }
        this.doGraphicsOp(rectangle, "drawPolygon", new Class[]{clazz, clazz, Integer.TYPE}, new Object[]{nArray, nArray2, new Integer(n)});
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Class<?> clazz = nArray.getClass();
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(nArray, nArray2, n);
        if (rectangle == null) {
            return;
        }
        this.doGraphicsOp(rectangle, "fillPolygon", new Class[]{clazz, clazz, Integer.TYPE}, new Object[]{nArray, nArray2, new Integer(n)});
    }

    public void drawString(String string, int n, int n2) {
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(string, this);
        rectangle2D.setRect(n, (double)n2 - rectangle2D.getHeight() + 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.doGraphicsOp(rectangle2D, "drawString", new Class[]{String.class, Integer.TYPE, Integer.TYPE}, new Object[]{string, new Integer(n), new Integer(n2)});
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.doGraphicsOp(n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), "drawImage", new Class[]{Image.class, Integer.TYPE, Integer.TYPE, ImageObserver.class}, new Object[]{image, new Integer(n), new Integer(n2), imageObserver});
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle2D rectangle2D = affineTransform.createTransformedShape(double_).getBounds2D();
        this.doGraphicsOp(rectangle2D, "drawRenderedImage", new Class[]{RenderedImage.class, AffineTransform.class}, new Object[]{renderedImage, affineTransform});
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        Rectangle2D rectangle2D = affineTransform.createTransformedShape(double_).getBounds2D();
        this.doGraphicsOp(rectangle2D, "drawRenderableImage", new Class[]{RenderableImage.class, AffineTransform.class}, new Object[]{renderableImage, affineTransform});
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.doGraphicsOp(n, n2, n3, n4, "drawImage", new Class[]{Image.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, ImageObserver.class}, new Object[]{image, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), imageObserver});
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.doGraphicsOp(n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), "drawImage", new Class[]{Image.class, Integer.TYPE, Integer.TYPE, Color.class, ImageObserver.class}, new Object[]{image, new Integer(n), new Integer(n2), color, imageObserver});
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.doGraphicsOp(n, n2, n3, n4, "drawImage", new Class[]{Image.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Color.class, ImageObserver.class}, new Object[]{image, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), color, imageObserver});
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.doGraphicsOp(n, n2, n3 - n + 1, n4 - n2 + 1, "drawImage", new Class[]{Image.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, ImageObserver.class}, new Object[]{image, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), imageObserver});
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.doGraphicsOp(n, n2, n3 - n + 1, n4 - n2 + 1, "drawImage", new Class[]{Image.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Color.class, ImageObserver.class}, new Object[]{image, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), color, imageObserver});
    }

    public void dispose() {
    }

    public void addRenderingHints(Map map) {
        this.renderingHints.putAll((Map<?, ?>)map);
    }

    public void draw(Shape shape) {
        this.doGraphicsOp(shape.getBounds(), "draw", new Class[]{Shape.class}, new Object[]{shape});
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, image.getWidth(imageObserver), image.getHeight(imageObserver));
        Rectangle2D rectangle2D = this.transform.createTransformedShape(double_).getBounds2D();
        return this.doGraphicsOp(rectangle2D, "drawImage", new Class[]{Image.class, AffineTransform.class, ImageObserver.class}, new Object[]{image, affineTransform, imageObserver});
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.doGraphicsOp(bufferedImageOp.getBounds2D(bufferedImage), "drawImage", new Class[]{BufferedImage.class, BufferedImageOp.class, Integer.TYPE, Integer.TYPE}, new Object[]{bufferedImage, bufferedImageOp, new Integer(n), new Integer(n2)});
    }

    public void drawString(String string, float f, float f2) {
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(string, this);
        rectangle2D.setRect(f, (double)f2 - rectangle2D.getHeight() + 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.doGraphicsOp(rectangle2D, "drawString", new Class[]{String.class, Float.TYPE, Float.TYPE}, new Object[]{string, new Float(f), new Float(f2)});
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), (Graphics)this);
        rectangle2D.setRect(n, (double)n2 - rectangle2D.getHeight() + 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.doGraphicsOp(rectangle2D, "drawString", new Class[]{AttributedCharacterIterator.class, Integer.TYPE, Integer.TYPE}, new Object[]{attributedCharacterIterator, new Integer(n), new Integer(n2)});
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), (Graphics)this);
        rectangle2D.setRect(f, (double)f2 - rectangle2D.getHeight() + 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.doGraphicsOp(rectangle2D, "drawString", new Class[]{AttributedCharacterIterator.class, Float.TYPE, Float.TYPE}, new Object[]{attributedCharacterIterator, new Float(f), new Float(f2)});
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.doGraphicsOp(glyphVector.getVisualBounds(), "drawGlyphVector", new Class[]{GlyphVector.class, Float.TYPE, Float.TYPE}, new Object[]{glyphVector, new Float(f), new Float(f2)});
    }

    public void fill(Shape shape) {
        this.doGraphicsOp(shape.getBounds(), "fill", new Class[]{Shape.class}, new Object[]{shape});
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        Graphics2D graphics2D = this.getBogusGraphics2D(true);
        boolean bl2 = graphics2D.hit(rectangle, shape, bl);
        graphics2D.dispose();
        return bl2;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        Graphics2D graphics2D = this.getBogusGraphics2D(true);
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        graphics2D.dispose();
        return graphicsConfiguration;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.renderingHints.put(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.renderingHints.get(key);
    }

    public void setRenderingHints(Map map) {
        this.renderingHints.putAll((Map<?, ?>)map);
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void translate(int n, int n2) {
        this.origin = new Point(n, n2);
        this.transform.translate(n, n2);
    }

    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
    }

    public void rotate(double d) {
        this.transform.rotate(d);
    }

    public void rotate(double d, double d2, double d3) {
        this.transform.rotate(d, d2, d3);
    }

    public void scale(double d, double d2) {
        this.transform.scale(d, d2);
    }

    public void shear(double d, double d2) {
        this.transform.shear(d, d2);
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void clip(Shape shape) {
        if (this.clip == null) {
            this.clip = shape;
        } else {
            Area area = this.clip instanceof Area ? (Area)this.clip : new Area(this.clip);
            area.intersect(shape instanceof Area ? (Area)shape : new Area(shape));
            this.clip = area;
        }
    }

    public FontRenderContext getFontRenderContext() {
        Graphics2D graphics2D = this.getBogusGraphics2D(true);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics2D.dispose();
        return fontRenderContext;
    }

    void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = null;
        if (this.renderingHints != null) {
            imagingListener = (ImagingListener)this.renderingHints.get(JAI.KEY_IMAGING_LISTENER);
        }
        if (imagingListener == null) {
            imagingListener = JAI.getDefaultInstance().getImagingListener();
        }
        imagingListener.errorOccurred(string, exception, this, false);
    }
}

