/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class BandCombineDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "BandCombine"}, {"LocalName", "BandCombine"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("BandCombineDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/BandCombineDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("BandCombineDescriptor1")}};
    private static final Class[] paramClasses = new Class[]{double[][].class};
    private static final String[] paramNames = new String[]{"matrix"};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public BandCombineDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        double[][] dArray = (double[][])parameterBlock.getObjectParameter(0);
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getNumBands() + 1;
        if (dArray.length < 1) {
            stringBuffer.append(this.getName() + ": " + JaiI18N.getString("BandCombineDescriptor2"));
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length == n) continue;
            stringBuffer.append(this.getName() + ": " + JaiI18N.getString("BandCombineDescriptor2"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, double[][] dArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("BandCombine", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("matrix", dArray);
        return JAI.create("BandCombine", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, double[][] dArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("BandCombine", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("matrix", dArray);
        return JAI.createRenderable("BandCombine", parameterBlockJAI, renderingHints);
    }
}

