/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.OutputStream;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class EncodeDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Encode"}, {"LocalName", "Encode"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("EncodeDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/EncodeDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("EncodeDescriptor1")}, {"arg1Desc", JaiI18N.getString("EncodeDescriptor2")}, {"arg2Desc", JaiI18N.getString("EncodeDescriptor3")}};
    private static final String[] paramNames = new String[]{"stream", "format", "param"};
    private static final Class[] paramClasses = new Class[]{OutputStream.class, String.class, ImageEncodeParam.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, "tiff", null};
    private static final String[] supportedModes = new String[]{"rendered"};

    public EncodeDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        if (parameterBlock.getNumParameters() < 3) {
            parameterBlock = (ParameterBlock)parameterBlock.clone();
            parameterBlock.set(null, 2);
        }
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        String string2 = (String)parameterBlock.getObjectParameter(1);
        ImageCodec imageCodec = ImageCodec.getCodec((String)string2);
        if (imageCodec == null) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("EncodeDescriptor4"));
            return false;
        }
        ImageEncodeParam imageEncodeParam = (ImageEncodeParam)parameterBlock.getObjectParameter(2);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (!imageCodec.canEncodeImage(renderedImage, imageEncodeParam)) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("EncodeDescriptor5"));
            return false;
        }
        return true;
    }

    public boolean isImmediate() {
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, OutputStream outputStream, String string, ImageEncodeParam imageEncodeParam, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Encode", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("stream", outputStream);
        parameterBlockJAI.setParameter("format", string);
        parameterBlockJAI.setParameter("param", imageEncodeParam);
        return JAI.create("Encode", parameterBlockJAI, renderingHints);
    }
}

