/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class HistogramDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Histogram"}, {"LocalName", "Histogram"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("HistogramDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/HistogramDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion2")}, {"arg0Desc", JaiI18N.getString("HistogramDescriptor1")}, {"arg1Desc", JaiI18N.getString("HistogramDescriptor2")}, {"arg2Desc", JaiI18N.getString("HistogramDescriptor3")}, {"arg3Desc", JaiI18N.getString("HistogramDescriptor4")}, {"arg4Desc", JaiI18N.getString("HistogramDescriptor5")}, {"arg5Desc", JaiI18N.getString("HistogramDescriptor6")}};
    private static final String[] paramNames = new String[]{"roi", "xPeriod", "yPeriod", "numBins", "lowValue", "highValue"};
    private static final Class[] paramClasses = new Class[]{ROI.class, Integer.class, Integer.class, int[].class, double[].class, double[].class};
    private static final Object[] paramDefaults = new Object[]{null, new Integer(1), new Integer(1), new int[]{256}, new double[]{0.0}, new double[]{256.0}};

    public HistogramDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public Number getParamMinValue(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return new Integer(1);
            }
            case 0: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    protected boolean validateParameters(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (parameterBlock == null || stringBuffer == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!super.validateParameters(parameterBlock, stringBuffer)) {
            return false;
        }
        int[] nArray = (int[])parameterBlock.getObjectParameter(3);
        double[] dArray = (double[])parameterBlock.getObjectParameter(4);
        double[] dArray2 = (double[])parameterBlock.getObjectParameter(5);
        int n = nArray.length;
        int n2 = dArray.length;
        int n3 = dArray2.length;
        int n4 = Math.max(n, Math.max(n2, n3));
        for (int i = 0; i < n4; ++i) {
            double d;
            if (i < n && nArray[i] <= 0) {
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("HistogramDescriptor7"));
                return false;
            }
            double d2 = i < n2 ? dArray[i] : dArray[0];
            double d3 = d = i < n3 ? dArray2[i] : dArray2[0];
            if (!(d2 >= d)) continue;
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("HistogramDescriptor8"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, ROI rOI, Integer n, Integer n2, int[] nArray, double[] dArray, double[] dArray2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Histogram", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("roi", rOI);
        parameterBlockJAI.setParameter("xPeriod", n);
        parameterBlockJAI.setParameter("yPeriod", n2);
        parameterBlockJAI.setParameter("numBins", nArray);
        parameterBlockJAI.setParameter("lowValue", dArray);
        parameterBlockJAI.setParameter("highValue", dArray2);
        return JAI.create("Histogram", parameterBlockJAI, renderingHints);
    }
}

