/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ColorCube;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class OrderedDitherDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "OrderedDither"}, {"LocalName", "OrderedDither"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("OrderedDitherDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/OrderedDitherDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("OrderedDitherDescriptor1")}, {"arg1Desc", JaiI18N.getString("OrderedDitherDescriptor2")}};
    private static final String[] paramNames = new String[]{"colorMap", "ditherMask"};
    private static final Class[] paramClasses = new Class[]{ColorCube.class, KernelJAI[].class};
    private static final Object[] paramDefaults = new Object[]{ColorCube.BYTE_496, KernelJAI.DITHER_MASK_443};
    private static final String[] supportedModes = new String[]{"rendered"};

    private static boolean isValidColorMap(RenderedImage renderedImage, ColorCube colorCube, StringBuffer stringBuffer) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (colorCube.getDataType() != sampleModel.getTransferType()) {
            stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor3"));
            return false;
        }
        if (colorCube.getNumBands() != sampleModel.getNumBands()) {
            stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor4"));
            return false;
        }
        return true;
    }

    private static boolean isValidDitherMask(RenderedImage renderedImage, KernelJAI[] kernelJAIArray, StringBuffer stringBuffer) {
        if (kernelJAIArray.length != renderedImage.getSampleModel().getNumBands()) {
            stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor5"));
            return false;
        }
        int n = kernelJAIArray[0].getWidth();
        int n2 = kernelJAIArray[0].getHeight();
        for (int i = 0; i < kernelJAIArray.length; ++i) {
            if (kernelJAIArray[i].getWidth() != n || kernelJAIArray[i].getHeight() != n2) {
                stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor6"));
                return false;
            }
            float[] fArray = kernelJAIArray[i].getKernelData();
            for (int j = 0; j < fArray.length; ++j) {
                if (!(fArray[j] < 0.0f) && !((double)fArray[j] > 1.0)) continue;
                stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor7"));
                return false;
            }
        }
        return true;
    }

    public OrderedDitherDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        ColorCube colorCube = (ColorCube)parameterBlock.getObjectParameter(0);
        KernelJAI[] kernelJAIArray = (KernelJAI[])parameterBlock.getObjectParameter(1);
        if (!OrderedDitherDescriptor.isValidColorMap(renderedImage, colorCube, stringBuffer)) {
            return false;
        }
        return OrderedDitherDescriptor.isValidDitherMask(renderedImage, kernelJAIArray, stringBuffer);
    }

    public static RenderedOp create(RenderedImage renderedImage, ColorCube colorCube, KernelJAI[] kernelJAIArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("OrderedDither", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("colorMap", colorCube);
        parameterBlockJAI.setParameter("ditherMask", kernelJAIArray);
        return JAI.create("OrderedDither", parameterBlockJAI, renderingHints);
    }
}

