/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.NegotiableCapability;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.RemoteDescriptor;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.RemoteRIF;
import javax.media.jai.remote.RemoteRenderableOp;
import javax.media.jai.remote.RemoteRenderedOp;
import javax.media.jai.util.CaselessStringKey;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public class RemoteJAI {
    protected String serverName;
    protected String protocolName;
    private OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
    public static final int DEFAULT_RETRY_INTERVAL = 1000;
    public static final int DEFAULT_NUM_RETRIES = 5;
    private int retryInterval = 1000;
    private int numRetries = 5;
    private transient TileCache cache = JAI.getDefaultInstance().getTileCache();
    private RenderingHints renderingHints;
    private NegotiableCapabilitySet preferences = null;
    private static NegotiableCapabilitySet negotiated;
    private NegotiableCapabilitySet serverCapabilities = null;
    private NegotiableCapabilitySet clientCapabilities = null;
    private Hashtable odHash = null;
    private OperationDescriptor[] descriptors = null;
    private static MessageFormat formatter;

    public RemoteJAI(String string, String string2) {
        this(string, string2, null, null);
    }

    public RemoteJAI(String string, String string2, OperationRegistry operationRegistry, TileCache tileCache) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        formatter = new MessageFormat("");
        formatter.setLocale(Locale.getDefault());
        this.protocolName = string;
        this.serverName = string2;
        if (operationRegistry != null) {
            this.operationRegistry = operationRegistry;
        }
        if (tileCache != null) {
            this.cache = tileCache;
        }
        this.renderingHints = new RenderingHints(null);
        this.renderingHints.put(JAI.KEY_OPERATION_REGISTRY, this.operationRegistry);
        this.renderingHints.put(JAI.KEY_TILE_CACHE, this.cache);
        this.renderingHints.put(JAI.KEY_RETRY_INTERVAL, new Integer(this.retryInterval));
        this.renderingHints.put(JAI.KEY_NUM_RETRIES, new Integer(this.numRetries));
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public void setRetryInterval(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
        }
        this.retryInterval = n;
        this.renderingHints.put(JAI.KEY_RETRY_INTERVAL, new Integer(n));
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setNumRetries(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic4"));
        }
        this.numRetries = n;
        this.renderingHints.put(JAI.KEY_NUM_RETRIES, new Integer(n));
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public OperationRegistry getOperationRegistry() {
        return this.operationRegistry;
    }

    public void setOperationRegistry(OperationRegistry operationRegistry) {
        if (operationRegistry == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI4"));
        }
        this.operationRegistry = operationRegistry;
        this.renderingHints.put(JAI.KEY_OPERATION_REGISTRY, operationRegistry);
    }

    public void setTileCache(TileCache tileCache) {
        if (tileCache == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI5"));
        }
        this.cache = tileCache;
        this.renderingHints.put(JAI.KEY_TILE_CACHE, this.cache);
    }

    public TileCache getTileCache() {
        return this.cache;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI6"));
        }
        this.renderingHints = renderingHints;
    }

    public void clearRenderingHints() {
        this.renderingHints = new RenderingHints(null);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        if (key == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI7"));
        }
        return this.renderingHints.get(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (key == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI7"));
        }
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI8"));
        }
        try {
            this.renderingHints.put(key, object);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
    }

    public void removeRenderingHint(RenderingHints.Key key) {
        this.renderingHints.remove(key);
    }

    public RemoteRenderedOp create(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderingHints renderingHints2;
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI9"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI10"));
        }
        this.getServerSupportedOperationList();
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.odHash.get(new CaselessStringKey(string));
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI11"));
        }
        if (!operationDescriptor.isModeSupported("rendered")) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI12"));
        }
        if (!RenderedImage.class.isAssignableFrom(operationDescriptor.getDestClass("rendered"))) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI13"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!operationDescriptor.validateArguments("rendered", parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        if (renderingHints == null) {
            renderingHints2 = this.renderingHints;
        } else if (this.renderingHints.isEmpty()) {
            renderingHints2 = renderingHints;
        } else {
            renderingHints2 = new RenderingHints(this.renderingHints);
            renderingHints2.add(renderingHints);
        }
        RemoteRenderedOp remoteRenderedOp = new RemoteRenderedOp(this.operationRegistry, this.protocolName, this.serverName, string, parameterBlock, renderingHints2);
        if (operationDescriptor.isImmediate()) {
            PlanarImage planarImage = null;
            planarImage = remoteRenderedOp.getRendering();
            if (planarImage == null) {
                return null;
            }
        }
        return remoteRenderedOp;
    }

    public RemoteRenderableOp createRenderable(String string, ParameterBlock parameterBlock) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI9"));
        }
        if (parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI10"));
        }
        this.getServerSupportedOperationList();
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.odHash.get(new CaselessStringKey(string));
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI11"));
        }
        if (!operationDescriptor.isModeSupported("renderable")) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI14"));
        }
        if (!RenderableImage.class.isAssignableFrom(operationDescriptor.getDestClass("renderable"))) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI15"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!operationDescriptor.validateArguments("renderable", parameterBlock = (ParameterBlock)parameterBlock.clone(), stringBuffer)) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        RemoteRenderableOp remoteRenderableOp = new RemoteRenderableOp(this.operationRegistry, this.protocolName, this.serverName, string, parameterBlock);
        remoteRenderableOp.setRenderingHints(this.renderingHints);
        return remoteRenderableOp;
    }

    public void setNegotiationPreferences(NegotiableCapabilitySet negotiableCapabilitySet) {
        this.preferences = negotiableCapabilitySet;
        if (negotiableCapabilitySet == null) {
            this.renderingHints.remove(JAI.KEY_NEGOTIATION_PREFERENCES);
        } else {
            this.renderingHints.put(JAI.KEY_NEGOTIATION_PREFERENCES, negotiableCapabilitySet);
        }
        negotiated = null;
        this.getNegotiatedValues();
    }

    public NegotiableCapabilitySet getNegotiatedValues() throws RemoteImagingException {
        if (negotiated == null) {
            if (this.serverCapabilities == null) {
                this.serverCapabilities = this.getServerCapabilities();
            }
            if (this.clientCapabilities == null) {
                this.clientCapabilities = this.getClientCapabilities();
            }
            negotiated = RemoteJAI.negotiate(this.preferences, this.serverCapabilities, this.clientCapabilities);
        }
        return negotiated;
    }

    public NegotiableCapability getNegotiatedValues(String string) throws RemoteImagingException {
        if (negotiated == null) {
            if (this.serverCapabilities == null) {
                this.serverCapabilities = this.getServerCapabilities();
            }
            if (this.clientCapabilities == null) {
                this.clientCapabilities = this.getClientCapabilities();
            }
            return RemoteJAI.negotiate(this.preferences, this.serverCapabilities, this.clientCapabilities, string);
        }
        return negotiated.getNegotiatedValue(string);
    }

    public static NegotiableCapabilitySet negotiate(NegotiableCapabilitySet negotiableCapabilitySet, NegotiableCapabilitySet negotiableCapabilitySet2, NegotiableCapabilitySet negotiableCapabilitySet3) {
        if (negotiableCapabilitySet2 == null || negotiableCapabilitySet3 == null) {
            return null;
        }
        if (negotiableCapabilitySet2 != null && negotiableCapabilitySet2.isPreference()) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI20"));
        }
        if (negotiableCapabilitySet3 != null && negotiableCapabilitySet3.isPreference()) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI21"));
        }
        if (negotiableCapabilitySet == null) {
            return negotiableCapabilitySet2.negotiate(negotiableCapabilitySet3);
        }
        if (!negotiableCapabilitySet.isPreference()) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI19"));
        }
        NegotiableCapabilitySet negotiableCapabilitySet4 = negotiableCapabilitySet2.negotiate(negotiableCapabilitySet3);
        if (negotiableCapabilitySet4 == null) {
            return null;
        }
        return negotiableCapabilitySet4.negotiate(negotiableCapabilitySet);
    }

    public static NegotiableCapability negotiate(NegotiableCapabilitySet negotiableCapabilitySet, NegotiableCapabilitySet negotiableCapabilitySet2, NegotiableCapabilitySet negotiableCapabilitySet3, String string) {
        NegotiableCapability negotiableCapability;
        if (negotiableCapabilitySet2 == null || negotiableCapabilitySet3 == null) {
            return null;
        }
        if (negotiableCapabilitySet2 != null && negotiableCapabilitySet2.isPreference()) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI20"));
        }
        if (negotiableCapabilitySet3 != null && negotiableCapabilitySet3.isPreference()) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI21"));
        }
        if (negotiableCapabilitySet != null && !negotiableCapabilitySet.isPreference()) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI19"));
        }
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteJAI26"));
        }
        if (negotiableCapabilitySet == null || negotiableCapabilitySet.isEmpty()) {
            return negotiableCapabilitySet2.getNegotiatedValue(negotiableCapabilitySet3, string);
        }
        List list = negotiableCapabilitySet.get(string);
        List list2 = negotiableCapabilitySet2.get(string);
        List list3 = negotiableCapabilitySet3.get(string);
        Iterator iterator = list.iterator();
        NegotiableCapability negotiableCapability2 = null;
        negotiableCapability2 = !iterator.hasNext() ? null : (NegotiableCapability)iterator.next();
        Vector<NegotiableCapability> vector = new Vector<NegotiableCapability>();
        for (NegotiableCapability negotiableCapability3 : list2) {
            for (NegotiableCapability negotiableCapability4 : list3) {
                negotiableCapability = negotiableCapability3.negotiate(negotiableCapability4);
                if (negotiableCapability == null) continue;
                vector.add(negotiableCapability);
                if (negotiableCapability2 != null) {
                    negotiableCapability = negotiableCapability.negotiate(negotiableCapability2);
                }
                if (negotiableCapability == null) continue;
                return negotiableCapability;
            }
        }
        while (iterator.hasNext()) {
            negotiableCapability2 = (NegotiableCapability)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                negotiableCapability = negotiableCapability2.negotiate((NegotiableCapability)vector.elementAt(i));
                if (negotiableCapability == null) continue;
                return negotiableCapability;
            }
        }
        return null;
    }

    public NegotiableCapabilitySet getServerCapabilities() throws RemoteImagingException {
        if (this.serverCapabilities == null) {
            RemoteDescriptor remoteDescriptor = (RemoteDescriptor)this.operationRegistry.getDescriptor(RemoteDescriptor.class, this.protocolName);
            if (remoteDescriptor == null) {
                Object[] objectArray = new Object[]{new String(this.protocolName)};
                formatter.applyPattern(JaiI18N.getString("RemoteJAI16"));
                throw new RuntimeException(formatter.format(objectArray));
            }
            RemoteImagingException remoteImagingException = null;
            int n = 0;
            while (n++ < this.numRetries) {
                try {
                    this.serverCapabilities = remoteDescriptor.getServerCapabilities(this.serverName);
                    break;
                }
                catch (RemoteImagingException remoteImagingException2) {
                    System.err.println(JaiI18N.getString("RemoteJAI24"));
                    remoteImagingException = remoteImagingException2;
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        this.sendExceptionToListener(JaiI18N.getString("Generic5"), new ImagingException(JaiI18N.getString("Generic5"), interruptedException));
                    }
                }
            }
            if (this.serverCapabilities == null && n > this.numRetries) {
                this.sendExceptionToListener(JaiI18N.getString("RemoteJAI18"), remoteImagingException);
            }
        }
        return this.serverCapabilities;
    }

    public NegotiableCapabilitySet getClientCapabilities() {
        if (this.clientCapabilities == null) {
            RemoteRIF remoteRIF = (RemoteRIF)this.operationRegistry.getFactory("remoteRendered", this.protocolName);
            if (remoteRIF == null) {
                remoteRIF = (RemoteRIF)this.operationRegistry.getFactory("remoteRenderable", this.protocolName);
            }
            if (remoteRIF == null) {
                Object[] objectArray = new Object[]{new String(this.protocolName)};
                formatter.applyPattern(JaiI18N.getString("RemoteJAI17"));
                throw new RuntimeException(formatter.format(objectArray));
            }
            this.clientCapabilities = remoteRIF.getClientCapabilities();
        }
        return this.clientCapabilities;
    }

    public OperationDescriptor[] getServerSupportedOperationList() throws RemoteImagingException {
        if (this.descriptors == null) {
            RemoteDescriptor remoteDescriptor = (RemoteDescriptor)this.operationRegistry.getDescriptor(RemoteDescriptor.class, this.protocolName);
            if (remoteDescriptor == null) {
                Object[] objectArray = new Object[]{new String(this.protocolName)};
                formatter.applyPattern(JaiI18N.getString("RemoteJAI16"));
                throw new RuntimeException(formatter.format(objectArray));
            }
            RemoteImagingException remoteImagingException = null;
            int n = 0;
            while (n++ < this.numRetries) {
                try {
                    this.descriptors = remoteDescriptor.getServerSupportedOperationList(this.serverName);
                    break;
                }
                catch (RemoteImagingException remoteImagingException2) {
                    System.err.println(JaiI18N.getString("RemoteJAI25"));
                    remoteImagingException = remoteImagingException2;
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        this.sendExceptionToListener(JaiI18N.getString("Generic5"), new ImagingException(JaiI18N.getString("Generic5"), interruptedException));
                    }
                }
            }
            if (this.descriptors == null && n > this.numRetries) {
                this.sendExceptionToListener(JaiI18N.getString("RemoteJAI23"), remoteImagingException);
            }
            this.odHash = new Hashtable();
            for (int i = 0; i < this.descriptors.length; ++i) {
                this.odHash.put(new CaselessStringKey(this.descriptors[i].getName()), this.descriptors[i]);
            }
        }
        return this.descriptors;
    }

    void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = JAI.getDefaultInstance().getImagingListener();
        imagingListener.errorOccurred(string, exception, this, false);
    }
}

