/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.raw;

import com.sun.media.imageio.stream.RawImageInputStream;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.raw.I18N;
import com.sun.media.imageioimpl.plugins.raw.RawImageReader;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;

public class RawRenderedImage
extends SimpleRenderedImage {
    private SampleModel originalSampleModel;
    private Raster currentTile;
    private Point currentTileGrid;
    private RawImageInputStream iis = null;
    private RawImageReader reader;
    private ImageReadParam param = null;
    private int imageIndex;
    private Rectangle destinationRegion;
    private Rectangle originalRegion;
    private Point sourceOrigin;
    private Dimension originalDimension;
    private int maxXTile;
    private int maxYTile;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int nComp;
    private boolean noTransform = true;
    private WritableRaster rasForATile;
    private BufferedImage destImage;
    private long position;
    private long tileDataSize;
    private int originalNumXTiles;

    public RawRenderedImage(RawImageInputStream rawImageInputStream, RawImageReader rawImageReader, ImageReadParam imageReadParam, int n) throws IOException {
        int n2;
        this.iis = rawImageInputStream;
        this.reader = rawImageReader;
        this.param = imageReadParam;
        this.imageIndex = n;
        this.position = rawImageInputStream.getImageOffset(n);
        this.originalDimension = rawImageInputStream.getImageDimension(n);
        ImageTypeSpecifier imageTypeSpecifier = rawImageInputStream.getImageType();
        this.sampleModel = this.originalSampleModel = imageTypeSpecifier.getSampleModel();
        this.colorModel = imageTypeSpecifier.getColorModel();
        int[] nArray = this.sourceBands = imageReadParam == null ? null : imageReadParam.getSourceBands();
        if (this.sourceBands == null) {
            this.nComp = this.originalSampleModel.getNumBands();
            this.sourceBands = new int[this.nComp];
            for (n2 = 0; n2 < this.nComp; ++n2) {
                this.sourceBands[n2] = n2;
            }
        } else {
            this.sampleModel = this.originalSampleModel.createSubsetSampleModel(this.sourceBands);
            this.colorModel = ImageUtil.createColorModel(null, this.sampleModel);
        }
        this.nComp = this.sourceBands.length;
        int[] nArray2 = this.destinationBands = imageReadParam == null ? null : imageReadParam.getDestinationBands();
        if (this.destinationBands == null) {
            this.destinationBands = new int[this.nComp];
            for (n2 = 0; n2 < this.nComp; ++n2) {
                this.destinationBands[n2] = n2;
            }
        }
        Dimension dimension = rawImageInputStream.getImageDimension(n);
        this.width = dimension.width;
        this.height = dimension.height;
        Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
        this.originalRegion = (Rectangle)rectangle.clone();
        this.destinationRegion = (Rectangle)rectangle.clone();
        if (imageReadParam != null) {
            RawImageReader.computeRegionsWrapper(imageReadParam, this.width, this.height, imageReadParam.getDestination(), rectangle, this.destinationRegion);
            this.scaleX = imageReadParam.getSourceXSubsampling();
            this.scaleY = imageReadParam.getSourceYSubsampling();
            this.xOffset = imageReadParam.getSubsamplingXOffset();
            this.yOffset = imageReadParam.getSubsamplingYOffset();
        }
        this.sourceOrigin = new Point(rectangle.x, rectangle.y);
        if (!this.destinationRegion.equals(rectangle)) {
            this.noTransform = false;
        }
        this.tileDataSize = ImageUtil.getTileSize(this.originalSampleModel);
        this.tileWidth = this.originalSampleModel.getWidth();
        this.tileHeight = this.originalSampleModel.getHeight();
        this.tileGridXOffset = this.destinationRegion.x;
        this.tileGridYOffset = this.destinationRegion.y;
        this.originalNumXTiles = this.getNumXTiles();
        this.width = this.destinationRegion.width;
        this.height = this.destinationRegion.height;
        this.minX = this.destinationRegion.x;
        this.minY = this.destinationRegion.y;
        this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        this.maxXTile = this.originalDimension.width / this.tileWidth;
        this.maxYTile = this.originalDimension.height / this.tileHeight;
    }

    public synchronized Raster getTile(int n, int n2) {
        block21: {
            if (this.currentTile != null && this.currentTileGrid.x == n && this.currentTileGrid.y == n2) {
                return this.currentTile;
            }
            if (n >= this.getNumXTiles() || n2 >= this.getNumYTiles()) {
                throw new IllegalArgumentException(I18N.getString("RawRenderedImage0"));
            }
            try {
                this.iis.seek(this.position + (long)(n2 * this.originalNumXTiles + n) * this.tileDataSize);
                int n3 = this.tileXToX(n);
                int n4 = this.tileYToY(n2);
                this.currentTile = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
                if (this.noTransform) {
                    switch (this.sampleModel.getDataType()) {
                        case 0: {
                            byte[][] byArray = ((DataBufferByte)this.currentTile.getDataBuffer()).getBankData();
                            for (int i = 0; i < byArray.length; ++i) {
                                this.iis.readFully(byArray[i], 0, byArray[i].length);
                            }
                            break block21;
                        }
                        case 2: {
                            short[][] sArray = ((DataBufferShort)this.currentTile.getDataBuffer()).getBankData();
                            for (int i = 0; i < sArray.length; ++i) {
                                this.iis.readFully(sArray[i], 0, sArray[i].length);
                            }
                            break block21;
                        }
                        case 1: {
                            short[][] sArray = ((DataBufferUShort)this.currentTile.getDataBuffer()).getBankData();
                            for (int i = 0; i < sArray.length; ++i) {
                                this.iis.readFully(sArray[i], 0, sArray[i].length);
                            }
                            break block21;
                        }
                        case 3: {
                            int[][] nArray = ((DataBufferInt)this.currentTile.getDataBuffer()).getBankData();
                            for (int i = 0; i < nArray.length; ++i) {
                                this.iis.readFully(nArray[i], 0, nArray[i].length);
                            }
                            break block21;
                        }
                        case 4: {
                            float[][] fArray = ((DataBufferFloat)this.currentTile.getDataBuffer()).getBankData();
                            for (int i = 0; i < fArray.length; ++i) {
                                this.iis.readFully(fArray[i], 0, fArray[i].length);
                            }
                            break block21;
                        }
                        case 5: {
                            double[][] dArray = ((DataBufferDouble)this.currentTile.getDataBuffer()).getBankData();
                            for (int i = 0; i < dArray.length; ++i) {
                                this.iis.readFully(dArray[i], 0, dArray[i].length);
                            }
                            break;
                        }
                    }
                    break block21;
                }
                this.currentTile = this.readSubsampledRaster((WritableRaster)this.currentTile);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (this.currentTileGrid == null) {
            this.currentTileGrid = new Point(n, n2);
        } else {
            this.currentTileGrid.x = n;
            this.currentTileGrid.y = n2;
        }
        return this.currentTile;
    }

    public void readAsRaster(WritableRaster writableRaster) throws IOException {
        this.readSubsampledRaster(writableRaster);
    }

    private Raster readSubsampledRaster(WritableRaster writableRaster) throws IOException {
        Object object;
        if (writableRaster == null) {
            writableRaster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(this.destinationRegion.x, this.destinationRegion.y));
        }
        int n = this.sourceBands.length;
        int n2 = this.sampleModel.getDataType();
        int n3 = DataBuffer.getDataTypeSize(n2);
        int n4 = (n3 + 7) / 8;
        Rectangle rectangle = writableRaster.getBounds().intersection(this.destinationRegion);
        int n5 = this.destinationRegion.x;
        int n6 = this.destinationRegion.y;
        int n7 = (rectangle.x - n5) * this.scaleX + this.sourceOrigin.x;
        int n8 = (rectangle.y - n6) * this.scaleY + this.sourceOrigin.y;
        int n9 = (rectangle.width - 1) * this.scaleX + n7;
        int n10 = (rectangle.height - 1) * this.scaleY + n8;
        int n11 = n7 / this.tileWidth;
        int n12 = n8 / this.tileHeight;
        int n13 = n9 / this.tileWidth;
        int n14 = n10 / this.tileHeight;
        n11 = this.clip(n11, 0, this.maxXTile);
        n12 = this.clip(n12, 0, this.maxYTile);
        n13 = this.clip(n13, 0, this.maxXTile);
        n14 = this.clip(n14, 0, this.maxYTile);
        int n15 = this.getNumXTiles();
        int n16 = this.getNumYTiles();
        int n17 = n15 * n16;
        byte[] byArray = null;
        short[] sArray = null;
        int[] nArray = null;
        float[] fArray = null;
        double[] dArray = null;
        boolean bl = true;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int[] nArray2 = null;
        int[] nArray3 = null;
        if (this.originalSampleModel instanceof ComponentSampleModel) {
            int n21;
            object = (ComponentSampleModel)this.originalSampleModel;
            nArray3 = ((ComponentSampleModel)object).getBankIndices();
            int n22 = 0;
            for (n21 = 0; n21 < nArray3.length; ++n21) {
                if (n22 <= nArray3[n21]) continue;
                n22 = nArray3[n21];
            }
            if (n22 > 0) {
                bl = false;
            }
            n18 = ((ComponentSampleModel)object).getPixelStride();
            n19 = ((ComponentSampleModel)object).getScanlineStride();
            nArray2 = ((ComponentSampleModel)object).getBandOffsets();
            for (n21 = 0; n21 < nArray2.length; ++n21) {
                if (n20 >= nArray2[n21]) continue;
                n20 = nArray2[n21];
            }
        } else if (this.originalSampleModel instanceof MultiPixelPackedSampleModel) {
            n19 = ((MultiPixelPackedSampleModel)this.originalSampleModel).getScanlineStride();
        } else if (this.originalSampleModel instanceof SinglePixelPackedSampleModel) {
            n18 = 1;
            n19 = ((SinglePixelPackedSampleModel)this.originalSampleModel).getScanlineStride();
        }
        object = null;
        short[] sArray2 = null;
        int[] nArray4 = null;
        float[] fArray2 = null;
        double[] dArray2 = null;
        int[] nArray5 = null;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        if (writableRaster.getSampleModel() instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
            nArray3 = componentSampleModel.getBankIndices();
            nArray5 = componentSampleModel.getBandOffsets();
            n23 = componentSampleModel.getPixelStride();
            n24 = componentSampleModel.getScanlineStride();
            n25 = componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY()) - nArray5[0];
            switch (n2) {
                case 0: {
                    object = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 2: {
                    sArray2 = ((DataBufferShort)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 1: {
                    sArray2 = ((DataBufferUShort)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 3: {
                    nArray4 = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 4: {
                    fArray2 = ((DataBufferFloat)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 5: {
                    dArray2 = ((DataBufferDouble)writableRaster.getDataBuffer()).getData();
                }
            }
        } else if (writableRaster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
            n = 1;
            nArray3 = new int[]{0};
            nArray5 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray5[i] = 0;
            }
            n23 = 1;
            n24 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        }
        for (int i = n12; i <= n14 && !this.reader.getAbortRequest(); ++i) {
            for (int j = n11; j <= n13 && !this.reader.getAbortRequest(); ++j) {
                int n26;
                int n27;
                int n28;
                int n29;
                int n30;
                int n31;
                int n32;
                int n33;
                int n34;
                int n35;
                int n36;
                int n37;
                int n38;
                int n39;
                int n40;
                int n41;
                int n42;
                long l = this.position + (long)(i * this.originalNumXTiles + j) * this.tileDataSize;
                this.iis.seek(l);
                float f = (j - n11 + i * n15) / n15;
                int n43 = j * this.tileWidth;
                int n44 = i * this.tileHeight;
                int n45 = this.tileHeight;
                int n46 = this.tileWidth;
                if (n44 + n45 >= this.originalDimension.height) {
                    n45 = this.originalDimension.height - n44;
                }
                if (n43 + n46 >= this.originalDimension.width) {
                    n46 = this.originalDimension.width - n43;
                }
                int n47 = n43;
                int n48 = n44;
                if (n7 > n43) {
                    n46 += n43 - n7;
                    n47 = n7;
                    n43 = n7;
                }
                if (n8 > n44) {
                    n45 += n44 - n8;
                    n48 = n8;
                    n44 = n8;
                }
                if (n9 < n43 + n46 - 1) {
                    n46 += n9 - n43 - n46 + 1;
                }
                if (n10 < n44 + n45 - 1) {
                    n45 += n10 - n44 - n45 + 1;
                }
                int n49 = (n43 + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX;
                int n50 = (n43 + this.scaleX - 1 + n46 - this.sourceOrigin.x) / this.scaleX;
                int n51 = n50 - n49;
                n50 = (n50 - 1) * this.scaleX + this.sourceOrigin.x;
                int n52 = (n44 + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                n43 = n49 * this.scaleX + this.sourceOrigin.x;
                n44 = n52 * this.scaleY + this.sourceOrigin.y;
                n49 += n5;
                n52 += n6;
                n47 -= j * this.tileWidth;
                n48 -= i * this.tileHeight;
                if (this.sampleModel instanceof MultiPixelPackedSampleModel) {
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.originalSampleModel;
                    this.iis.skipBytes(multiPixelPackedSampleModel.getOffset(n47, n48) * n4);
                    n42 = (multiPixelPackedSampleModel.getOffset(n50, 0) - multiPixelPackedSampleModel.getOffset(n43, 0) + 1) * n4;
                    n41 = (n19 * this.scaleY - n42) * n4;
                    if (byArray == null || byArray.length < (n42 *= n4)) {
                        byArray = new byte[n42];
                    }
                    n40 = multiPixelPackedSampleModel.getBitOffset(n47);
                    n39 = 0;
                    n38 = n52;
                    while (n39 < n45 && !this.reader.getAbortRequest()) {
                        this.iis.readFully(byArray, 0, n42);
                        if (this.scaleX == 1) {
                            if (n40 != 0) {
                                n37 = 255 << n40 & 0xFF;
                                n36 = ~n37 & 0xFF;
                                n35 = 8 - n40;
                                for (n34 = 0; n34 < n42 - 1; ++n34) {
                                    byArray[n34] = (byte)((byArray[n34] & n36) << n35 | (byArray[n34 + 1] & n37) >> n40);
                                }
                                byArray[n34] = (byte)((byArray[n34] & n36) << n35);
                            }
                        } else {
                            n37 = 7;
                            n36 = 0;
                            n35 = 128;
                            n34 = 0;
                            n33 = n43 & 7;
                            while (n34 < n51) {
                                byArray[n36] = (byte)(byArray[n36] & ~(1 << n37) | (byArray[n33 >> 3] >> 7 - (n33 & 7) & 1) << n37);
                                if (--n37 == -1) {
                                    n37 = 7;
                                    ++n36;
                                }
                                ++n34;
                                n33 += this.scaleX;
                            }
                        }
                        ImageUtil.setPackedBinaryData(byArray, writableRaster, new Rectangle(n49, n38, n51, 1));
                        this.iis.skipBytes(n41);
                        if (this.destImage != null) {
                            this.reader.processImageUpdateWrapper(this.destImage, n49, n38, n46, 1, 1, 1, this.destinationBands);
                        }
                        this.reader.processImageProgressWrapper(f + ((float)(n39 - n44) + 1.0f) / (float)n45 / (float)n17);
                        n39 += this.scaleY;
                        ++n38;
                    }
                    continue;
                }
                if (n18 < n19) {
                    n32 = n46 * n18;
                    n42 = (n19 * this.scaleY - n32) * n4;
                } else {
                    n32 = n45 * n19;
                    n42 = (n18 * this.scaleX - n32) * n4;
                }
                switch (this.sampleModel.getDataType()) {
                    case 0: {
                        if (byArray != null && byArray.length >= n32) break;
                        byArray = new byte[n32];
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (sArray != null && sArray.length >= n32) break;
                        sArray = new short[n32];
                        break;
                    }
                    case 3: {
                        if (nArray != null && nArray.length >= n32) break;
                        nArray = new int[n32];
                        break;
                    }
                    case 4: {
                        if (fArray != null && fArray.length >= n32) break;
                        fArray = new float[n32];
                        break;
                    }
                    case 5: {
                        if (dArray != null && dArray.length >= n32) break;
                        dArray = new double[n32];
                    }
                }
                if (this.sampleModel instanceof PixelInterleavedSampleModel) {
                    this.iis.skipBytes((n47 * n18 + n48 * n19) * n4);
                    if (n18 < n19) {
                        n41 = 0;
                        n40 = n52;
                        n39 = this.scaleY;
                        n38 = n45;
                        n37 = this.scaleX * n18;
                        n36 = n23;
                        n35 = n24;
                    } else {
                        n41 = 0;
                        n40 = n49;
                        n39 = this.scaleX;
                        n38 = n46;
                        n37 = this.scaleY * n19;
                        n36 = n24;
                        n35 = n23;
                    }
                    n34 = n25 + (n52 - writableRaster.getSampleModelTranslateY()) * n24 + (n49 - writableRaster.getSampleModelTranslateX()) * n23;
                    n33 = n41;
                    n31 = n40;
                    while (n33 < n38 && !this.reader.getAbortRequest()) {
                        switch (n2) {
                            case 0: {
                                if (n37 == n && n36 == n) {
                                    this.iis.readFully((byte[])object, n34, n32);
                                    break;
                                }
                                this.iis.readFully(byArray, 0, n32);
                                break;
                            }
                            case 1: 
                            case 2: {
                                if (n37 == n && n36 == n) {
                                    this.iis.readFully(sArray2, n34, n32);
                                    break;
                                }
                                this.iis.readFully(sArray, 0, n32);
                                break;
                            }
                            case 3: {
                                if (n37 == n && n36 == n) {
                                    this.iis.readFully(nArray4, n34, n32);
                                    break;
                                }
                                this.iis.readFully(nArray, 0, n32);
                                break;
                            }
                            case 4: {
                                if (n37 == n && n36 == n) {
                                    this.iis.readFully(fArray2, n34, n32);
                                    break;
                                }
                                this.iis.readFully(fArray, 0, n32);
                                break;
                            }
                            case 5: {
                                if (n37 == n && n36 == n) {
                                    this.iis.readFully(dArray2, n34, n32);
                                    break;
                                }
                                this.iis.readFully(dArray, 0, n32);
                            }
                        }
                        if (n37 != n || n36 != n) {
                            for (n30 = 0; n30 < n; ++n30) {
                                n29 = nArray5[this.destinationBands[n30]];
                                n34 += n29;
                                n28 = nArray2[this.sourceBands[n30]];
                                switch (n2) {
                                    case 0: {
                                        n27 = 0;
                                        n26 = n34;
                                        while (n27 < n32) {
                                            object[n26] = byArray[n27 + n28];
                                            n27 += n37;
                                            n26 += n36;
                                        }
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        n27 = 0;
                                        n26 = n34;
                                        while (n27 < n32) {
                                            sArray2[n26] = sArray[n27 + n28];
                                            n27 += n37;
                                            n26 += n36;
                                        }
                                        break;
                                    }
                                    case 3: {
                                        n27 = 0;
                                        n26 = n34;
                                        while (n27 < n32) {
                                            nArray4[n26] = nArray[n27 + n28];
                                            n27 += n37;
                                            n26 += n36;
                                        }
                                        break;
                                    }
                                    case 4: {
                                        n27 = 0;
                                        n26 = n34;
                                        while (n27 < n32) {
                                            fArray2[n26] = fArray[n27 + n28];
                                            n27 += n37;
                                            n26 += n36;
                                        }
                                        break;
                                    }
                                    case 5: {
                                        n27 = 0;
                                        n26 = n34;
                                        while (n27 < n32) {
                                            dArray2[n26] = dArray[n27 + n28];
                                            n27 += n37;
                                            n26 += n36;
                                        }
                                        break;
                                    }
                                }
                                n34 -= n29;
                            }
                        }
                        this.iis.skipBytes(n42);
                        n34 += n35;
                        if (this.destImage != null) {
                            if (n18 < n19) {
                                this.reader.processImageUpdateWrapper(this.destImage, n49, n31, n38, 1, 1, 1, this.destinationBands);
                            } else {
                                this.reader.processImageUpdateWrapper(this.destImage, n31, n52, 1, n38, 1, 1, this.destinationBands);
                            }
                        }
                        this.reader.processImageProgressWrapper(f + ((float)n33 + 1.0f) / (float)n38 / (float)n17);
                        n33 += n39;
                        ++n31;
                    }
                    continue;
                }
                if (this.sampleModel instanceof BandedSampleModel || this.sampleModel instanceof SinglePixelPackedSampleModel || n20 == 0) {
                    n41 = this.sampleModel instanceof BandedSampleModel;
                    n40 = (int)ImageUtil.getBandSize(this.originalSampleModel);
                    for (n39 = 0; n39 < n; ++n39) {
                        this.iis.seek(l + (long)(n40 * this.sourceBands[n39] * n4));
                        n38 = nArray5[this.destinationBands[n39]];
                        this.iis.skipBytes((n48 * n19 + n47 * n18) * n4);
                        if (n18 < n19) {
                            n37 = 0;
                            n36 = n52;
                            n35 = this.scaleY;
                            n34 = n45;
                            n33 = this.scaleX * n18;
                            n31 = n23;
                            n30 = n24;
                        } else {
                            n37 = 0;
                            n36 = n49;
                            n35 = this.scaleX;
                            n34 = n46;
                            n33 = this.scaleY * n19;
                            n31 = n24;
                            n30 = n23;
                        }
                        n29 = n25 + (n52 - writableRaster.getSampleModelTranslateY()) * n24 + (n49 - writableRaster.getSampleModelTranslateX()) * n23 + n38;
                        n28 = nArray3[this.destinationBands[n39]];
                        switch (n2) {
                            case 0: {
                                object = ((DataBufferByte)writableRaster.getDataBuffer()).getData(n28);
                                break;
                            }
                            case 2: {
                                sArray2 = ((DataBufferShort)writableRaster.getDataBuffer()).getData(n28);
                                break;
                            }
                            case 1: {
                                sArray2 = ((DataBufferUShort)writableRaster.getDataBuffer()).getData(n28);
                                break;
                            }
                            case 3: {
                                nArray4 = ((DataBufferInt)writableRaster.getDataBuffer()).getData(n28);
                                break;
                            }
                            case 4: {
                                fArray2 = ((DataBufferFloat)writableRaster.getDataBuffer()).getData(n28);
                                break;
                            }
                            case 5: {
                                dArray2 = ((DataBufferDouble)writableRaster.getDataBuffer()).getData(n28);
                            }
                        }
                        n27 = n37;
                        n26 = n36;
                        while (n27 < n34 && !this.reader.getAbortRequest()) {
                            switch (n2) {
                                case 0: {
                                    if (n33 == 1 && n31 == 1) {
                                        this.iis.readFully((byte[])object, n29, n32);
                                        break;
                                    }
                                    this.iis.readFully(byArray, 0, n32);
                                    int n53 = 0;
                                    int n54 = n29;
                                    while (n53 < n32) {
                                        object[n54] = byArray[n53];
                                        n53 += n33;
                                        n54 += n31;
                                    }
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    if (n33 == 1 && n31 == 1) {
                                        this.iis.readFully(sArray2, n29, n32);
                                        break;
                                    }
                                    this.iis.readFully(sArray, 0, n32);
                                    int n55 = 0;
                                    int n54 = n29;
                                    while (n55 < n32) {
                                        sArray2[n54] = sArray[n55];
                                        n55 += n33;
                                        n54 += n31;
                                    }
                                    break;
                                }
                                case 3: {
                                    if (n33 == 1 && n31 == 1) {
                                        this.iis.readFully(nArray4, n29, n32);
                                        break;
                                    }
                                    this.iis.readFully(nArray, 0, n32);
                                    int n56 = 0;
                                    int n54 = n29;
                                    while (n56 < n32) {
                                        nArray4[n54] = nArray[n56];
                                        n56 += n33;
                                        n54 += n31;
                                    }
                                    break;
                                }
                                case 4: {
                                    if (n33 == 1 && n31 == 1) {
                                        this.iis.readFully(fArray2, n29, n32);
                                        break;
                                    }
                                    this.iis.readFully(fArray, 0, n32);
                                    int n57 = 0;
                                    int n54 = n29;
                                    while (n57 < n32) {
                                        fArray2[n54] = fArray[n57];
                                        n57 += n33;
                                        n54 += n31;
                                    }
                                    break;
                                }
                                case 5: {
                                    if (n33 == 1 && n31 == 1) {
                                        this.iis.readFully(dArray2, n29, n32);
                                        break;
                                    }
                                    this.iis.readFully(dArray, 0, n32);
                                    int n58 = 0;
                                    int n54 = n29;
                                    while (n58 < n32) {
                                        dArray2[n54] = dArray[n58];
                                        n58 += n33;
                                        n54 += n31;
                                    }
                                    break;
                                }
                            }
                            this.iis.skipBytes(n42);
                            n29 += n30;
                            if (this.destImage != null) {
                                int[] nArray6 = new int[]{this.destinationBands[n39]};
                                if (n18 < n19) {
                                    this.reader.processImageUpdateWrapper(this.destImage, n49, n26, n34, 1, 1, 1, nArray6);
                                } else {
                                    this.reader.processImageUpdateWrapper(this.destImage, n26, n52, 1, n34, 1, 1, nArray6);
                                }
                            }
                            this.reader.processImageProgressWrapper((f + ((float)n27 + 1.0f) / (float)n34 / (float)n / (float)n17) * 100.0f);
                            n27 += n35;
                            ++n26;
                        }
                    }
                    continue;
                }
                if (this.sampleModel instanceof ComponentSampleModel) {
                    n41 = (int)this.tileDataSize;
                    switch (this.sampleModel.getDataType()) {
                        case 0: {
                            if (byArray == null || (long)byArray.length < this.tileDataSize) {
                                byArray = new byte[(int)this.tileDataSize];
                            }
                            this.iis.readFully(byArray, 0, (int)this.tileDataSize);
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (sArray == null || sArray.length < (n41 /= 2)) {
                                sArray = new short[n41];
                            }
                            this.iis.readFully(sArray, 0, n41);
                            break;
                        }
                        case 3: {
                            if (nArray == null || nArray.length < (n41 /= 4)) {
                                nArray = new int[n41];
                            }
                            this.iis.readFully(nArray, 0, n41);
                            break;
                        }
                        case 4: {
                            if (fArray == null || fArray.length < (n41 /= 4)) {
                                fArray = new float[n41];
                            }
                            this.iis.readFully(fArray, 0, n41);
                            break;
                        }
                        case 5: {
                            if (dArray == null || dArray.length < (n41 /= 8)) {
                                dArray = new double[n41];
                            }
                            this.iis.readFully(dArray, 0, n41);
                        }
                    }
                    for (n40 = 0; n40 < n; ++n40) {
                        n39 = nArray5[this.destinationBands[n40]];
                        n38 = ((ComponentSampleModel)writableRaster.getSampleModel()).getOffset(n49 - writableRaster.getSampleModelTranslateX(), n52 - writableRaster.getSampleModelTranslateY(), this.destinationBands[n40]);
                        n37 = nArray3[this.destinationBands[n40]];
                        switch (n2) {
                            case 0: {
                                object = ((DataBufferByte)writableRaster.getDataBuffer()).getData(n37);
                                break;
                            }
                            case 2: {
                                sArray2 = ((DataBufferShort)writableRaster.getDataBuffer()).getData(n37);
                                break;
                            }
                            case 1: {
                                sArray2 = ((DataBufferUShort)writableRaster.getDataBuffer()).getData(n37);
                                break;
                            }
                            case 3: {
                                nArray4 = ((DataBufferInt)writableRaster.getDataBuffer()).getData(n37);
                                break;
                            }
                            case 4: {
                                fArray2 = ((DataBufferFloat)writableRaster.getDataBuffer()).getData(n37);
                                break;
                            }
                            case 5: {
                                dArray2 = ((DataBufferDouble)writableRaster.getDataBuffer()).getData(n37);
                            }
                        }
                        n36 = ((ComponentSampleModel)this.originalSampleModel).getOffset(n47, n48, this.sourceBands[n40]);
                        n35 = this.scaleX * n18;
                        n34 = 0;
                        n33 = n52;
                        while (n34 < n45 && !this.reader.getAbortRequest()) {
                            switch (n2) {
                                case 0: {
                                    int n59 = 0;
                                    n30 = n36;
                                    n29 = n38;
                                    while (n59 < n51) {
                                        object[n29] = byArray[n30];
                                        ++n59;
                                        n30 += n35;
                                        n29 += n23;
                                    }
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    int n60 = 0;
                                    n30 = n36;
                                    n29 = n38;
                                    while (n60 < n51) {
                                        sArray2[n29] = sArray[n30];
                                        ++n60;
                                        n30 += n35;
                                        n29 += n23;
                                    }
                                    break;
                                }
                                case 3: {
                                    int n61 = 0;
                                    n30 = n36;
                                    n29 = n38;
                                    while (n61 < n51) {
                                        nArray4[n29] = nArray[n30];
                                        ++n61;
                                        n30 += n35;
                                        n29 += n23;
                                    }
                                    break;
                                }
                                case 4: {
                                    int n62 = 0;
                                    n30 = n36;
                                    n29 = n38;
                                    while (n62 < n51) {
                                        fArray2[n29] = fArray[n30];
                                        ++n62;
                                        n30 += n35;
                                        n29 += n23;
                                    }
                                    break;
                                }
                                case 5: {
                                    int n63 = 0;
                                    n30 = n36;
                                    n29 = n38;
                                    while (n63 < n51) {
                                        dArray2[n29] = dArray[n30];
                                        ++n63;
                                        n30 += n35;
                                        n29 += n23;
                                    }
                                    break;
                                }
                            }
                            n38 += n24;
                            n36 += n19 * this.scaleY;
                            if (this.destImage != null) {
                                int[] nArray7 = new int[]{this.destinationBands[n40]};
                                this.reader.processImageUpdateWrapper(this.destImage, n49, n33, n45, 1, 1, 1, nArray7);
                            }
                            this.reader.processImageProgressWrapper(f + ((float)n34 + 1.0f) / (float)n45 / (float)n / (float)n17);
                            n34 += this.scaleY;
                            ++n33;
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException(I18N.getString("RawRenderedImage1"));
            }
        }
        return writableRaster;
    }

    public void setDestImage(BufferedImage bufferedImage) {
        this.destImage = bufferedImage;
    }

    public void clearDestImage() {
        this.destImage = null;
    }

    private int getTileNum(int n, int n2) {
        int n3 = (n2 - this.getMinTileY()) * this.getNumXTiles() + n - this.getMinTileX();
        if (n3 < 0 || n3 >= this.getNumXTiles() * this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("RawRenderedImage0"));
        }
        return n3;
    }

    private int clip(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }
}

