/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.dataio.geotiff.Utils;
import org.esa.snap.dataio.geotiff.internal.TiffIFD;
import org.esa.snap.dataio.geotiff.internal.TiffLong;
import org.esa.snap.dataio.geotiff.internal.TiffShort;
import org.esa.snap.dataio.geotiff.internal.TiffTag;
import org.esa.snap.dataio.geotiff.internal.TiffValue;

class GeoTiffBandWriter {
    private ImageOutputStream ios;
    private TiffIFD ifd;
    private Product tempProduct;
    private ArrayList<Band> bandsList;

    GeoTiffBandWriter(TiffIFD ifd, ImageOutputStream ios, Product product) {
        this.ifd = ifd;
        this.ios = ios;
        this.tempProduct = product;
        Band[] bands = this.tempProduct.getBands();
        this.bandsList = new ArrayList(bands.length);
        for (Band band : bands) {
            if (!Utils.shouldWriteNode((ProductNode)band)) continue;
            this.bandsList.add(band);
        }
    }

    public void dispose() {
        this.ifd = null;
        this.ios = null;
        this.tempProduct = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBandRasterData(Band sourceBand, int regionX, int regionY, int regionWidth, int regionHeight, ProductData regionData, ProgressMonitor pm) throws IOException {
        if (!this.tempProduct.containsBand(sourceBand.getName())) {
            throw new IllegalArgumentException("'" + sourceBand.getName() + "' is not a band of the product");
        }
        int bandDataType = this.ifd.getBandDataType();
        int stripIndex = this.getStripIndex(sourceBand);
        TiffValue[] offsetValues = this.ifd.getEntry(TiffTag.STRIP_OFFSETS).getValues();
        long stripOffset = ((TiffLong)offsetValues[stripIndex]).getValue();
        TiffValue[] bitsPerSampleValues = this.ifd.getEntry(TiffTag.BITS_PER_SAMPLE).getValues();
        long elemSize = ((TiffShort)bitsPerSampleValues[stripIndex]).getValue() / 8;
        long sourceWidthBytes = (long)sourceBand.getRasterWidth() * elemSize;
        long regionOffsetXInBytes = (long)regionX * elemSize;
        long pixelOffset = sourceWidthBytes * (long)regionY + regionOffsetXInBytes;
        long startOffset = stripOffset + pixelOffset;
        pm.beginTask("Writing band '" + sourceBand.getName() + "'...", regionHeight);
        try {
            for (int y = 0; y < regionHeight; ++y) {
                int x;
                Object[] data;
                this.ios.seek(startOffset + (long)y * sourceWidthBytes);
                int stride = y * regionWidth;
                if (bandDataType == 20) {
                    data = new byte[regionWidth];
                    for (x = 0; x < regionWidth; ++x) {
                        data[x] = (byte)regionData.getElemUIntAt(stride + x);
                    }
                    this.ios.write((byte[])data);
                } else if (bandDataType == 10) {
                    data = new byte[regionWidth];
                    for (x = 0; x < regionWidth; ++x) {
                        data[x] = (byte)regionData.getElemIntAt(stride + x);
                    }
                    this.ios.write((byte[])data);
                } else if (bandDataType == 21) {
                    data = new short[regionWidth];
                    for (x = 0; x < regionWidth; ++x) {
                        data[x] = (short)regionData.getElemUIntAt(stride + x);
                    }
                    this.ios.writeShorts((short[])data, 0, regionWidth);
                } else if (bandDataType == 11) {
                    data = new short[regionWidth];
                    for (x = 0; x < regionWidth; ++x) {
                        data[x] = (short)regionData.getElemIntAt(stride + x);
                    }
                    this.ios.writeShorts((short[])data, 0, regionWidth);
                } else if (bandDataType == 22) {
                    data = new int[regionWidth];
                    for (x = 0; x < regionWidth; ++x) {
                        data[x] = (int)regionData.getElemUIntAt(stride + x);
                    }
                    this.ios.writeInts((int[])data, 0, regionWidth);
                } else if (bandDataType == 12) {
                    data = new int[regionWidth];
                    for (x = 0; x < regionWidth; ++x) {
                        data[x] = regionData.getElemIntAt(stride + x);
                    }
                    this.ios.writeInts((int[])data, 0, regionWidth);
                } else if (bandDataType == 30) {
                    data = new float[regionWidth];
                    for (x = 0; x < regionWidth; ++x) {
                        data[x] = (byte)regionData.getElemFloatAt(stride + x);
                    }
                    this.ios.writeFloats((float[])data, 0, regionWidth);
                } else if (bandDataType == 31) {
                    data = new double[regionWidth];
                    for (x = 0; x < regionWidth; ++x) {
                        data[x] = (byte)regionData.getElemDoubleAt(stride + x);
                    }
                    this.ios.writeDoubles((double[])data, 0, regionWidth);
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private int getStripIndex(Band sourceBand) {
        return this.bandsList.indexOf(sourceBand);
    }
}

