/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.dataio.geotiff.GeoTiffImageReader;
import org.esa.snap.engine_utilities.file.FileHelper;
import org.esa.snap.engine_utilities.util.FindChildFileVisitor;
import org.esa.snap.engine_utilities.util.NotRegularFileException;
import org.esa.snap.engine_utilities.util.ZipFileSystemBuilder;

public class GeoTiffFile
implements Closeable {
    private static final Logger logger = Logger.getLogger(GeoTiffFile.class.getName());
    private final Path imageParentPath;
    private final String imageRelativeFilePath;
    private final boolean copyFileFromZipArchiveOnLocalDisk;
    private final Path localTempFolder;
    private Path localFile;

    public GeoTiffFile(Path imageParentPath, String imageRelativeFilePath, boolean copyFileFromZipArchiveOnLocalDisk, Path localTempFolder) {
        if (imageParentPath == null) {
            throw new NullPointerException("The image path is null.");
        }
        if (localTempFolder == null) {
            throw new NullPointerException("The local temp folder is null.");
        }
        this.imageParentPath = imageParentPath;
        this.localTempFolder = localTempFolder;
        this.imageRelativeFilePath = imageRelativeFilePath;
        this.copyFileFromZipArchiveOnLocalDisk = copyFileFromZipArchiveOnLocalDisk;
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }

    @Override
    public final void close() throws IOException {
        this.cleanup();
    }

    public GeoTiffImageReader buildImageReader() throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        GeoTiffImageReader geoTiffImageReader = this.processLocalCopiedFile();
        if (geoTiffImageReader != null) {
            return geoTiffImageReader;
        }
        if (Files.exists(this.imageParentPath, new LinkOption[0])) {
            if (Files.isDirectory(this.imageParentPath, new LinkOption[0])) {
                return this.processImageFolder();
            }
            if (Files.isRegularFile(this.imageParentPath, new LinkOption[0])) {
                if (this.imageParentPath.getFileName().toString().toLowerCase().endsWith(".zip")) {
                    return this.processImageZipArchive();
                }
                if (this.imageRelativeFilePath != null) {
                    throw new IllegalStateException("The relative file path '" + this.imageRelativeFilePath + "' must be null.");
                }
                return new GeoTiffImageReader(this.imageParentPath.toFile());
            }
            throw new NotRegularFileException(this.imageParentPath.toString());
        }
        throw new FileNotFoundException("The product path '" + this.imageParentPath + "' does not exist.");
    }

    protected void cleanup() throws IOException {
        if (this.localFile != null) {
            Files.delete(this.localFile);
        }
        this.localFile = null;
    }

    private GeoTiffImageReader processImageFolder() throws IOException {
        if (this.imageRelativeFilePath == null) {
            throw new NullPointerException("The relative file path is null.");
        }
        Path child = this.imageParentPath.resolve(this.imageRelativeFilePath);
        if (Files.exists(child, new LinkOption[0])) {
            if (Files.isRegularFile(child, new LinkOption[0])) {
                return new GeoTiffImageReader(child.toFile());
            }
            throw new NotRegularFileException("The product folder '" + this.imageParentPath.toString() + "' does not contain the file '" + this.imageRelativeFilePath + "'.");
        }
        throw new FileNotFoundException("The product folder '" + this.imageParentPath.toString() + "' does not contain the path '" + this.imageRelativeFilePath + "'.");
    }

    private GeoTiffImageReader processImageZipArchive() throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.imageRelativeFilePath == null) {
            throw new NullPointerException("The relative file path is null.");
        }
        boolean success = false;
        FileSystem fileSystem = null;
        try {
            fileSystem = ZipFileSystemBuilder.newZipFileSystem((Path)this.imageParentPath);
            for (Path zipArchiveRoot : fileSystem.getRootDirectories()) {
                Path entryPathToFind = ZipFileSystemBuilder.buildZipEntryPath((Path)zipArchiveRoot, (String)this.imageRelativeFilePath);
                FindChildFileVisitor findChildFileVisitor = new FindChildFileVisitor(entryPathToFind);
                Files.walkFileTree(zipArchiveRoot, (FileVisitor<? super Path>)findChildFileVisitor);
                if (findChildFileVisitor.getExistingChildFile() == null) continue;
                if (this.copyFileFromZipArchiveOnLocalDisk) {
                    this.copyFileOnLocalDisk(findChildFileVisitor.getExistingChildFile());
                    GeoTiffImageReader geoTiffImageReader = new GeoTiffImageReader(this.localFile.toFile());
                    return geoTiffImageReader;
                }
                GeoTiffImageReader geoTiffImageReader = GeoTiffImageReader.buildGeoTiffImageReaderObject(findChildFileVisitor.getExistingChildFile(), fileSystem);
                success = true;
                GeoTiffImageReader geoTiffImageReader2 = geoTiffImageReader;
                return geoTiffImageReader2;
            }
            throw new FileNotFoundException("The zip archive '" + this.imageRelativeFilePath.toString() + "' does not contain the file '" + this.imageRelativeFilePath + "'.");
        }
        finally {
            if (fileSystem != null && !success) {
                fileSystem.close();
            }
        }
    }

    private GeoTiffImageReader processLocalCopiedFile() throws IOException {
        if (this.localFile != null && Files.exists(this.localFile, new LinkOption[0])) {
            if (Files.isRegularFile(this.localFile, new LinkOption[0])) {
                return new GeoTiffImageReader(this.localFile.toFile());
            }
            throw new NotRegularFileException(this.localFile.toString());
        }
        return null;
    }

    private void copyFileOnLocalDisk(Path sourcePath) throws IOException {
        if (this.localFile != null) {
            throw new IllegalStateException("The local file path '" + this.localFile + "' must be null.");
        }
        this.localFile = this.localTempFolder.resolve(this.imageRelativeFilePath);
        if (FileHelper.canCopyOrReplaceFile((Path)sourcePath, (Path)this.localFile)) {
            Path parentFolder = this.localFile.getParent();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Copy file '" + sourcePath.toString() + "' to local folder '" + parentFolder.toString() + "'.");
            }
            if (!Files.exists(parentFolder, new LinkOption[0])) {
                Files.createDirectories(parentFolder, new FileAttribute[0]);
            }
            FileHelper.copyFileUsingInputStream((Path)sourcePath, (String)this.localFile.toString(), (int)0x100000);
        }
    }
}

