/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFRenderedImage;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.TranslateDescriptor;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.esa.snap.dataio.geotiff.GeoTiffRasterRegion;
import org.esa.snap.engine_utilities.util.FileSystemUtils;
import org.esa.snap.engine_utilities.util.FindChildFileVisitor;
import org.esa.snap.engine_utilities.util.NotRegularFileException;
import org.esa.snap.engine_utilities.util.ZipFileSystemBuilder;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffException;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffMetadata2CRSAdapter;
import org.geotools.coverage.grid.io.imageio.geotiff.PixelScale;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;
import org.geotools.factory.Hints;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public class GeoTiffImageReader
implements Closeable,
GeoTiffRasterRegion {
    private static final Logger logger = Logger.getLogger(GeoTiffImageReader.class.getName());
    private static final int BUFFER_SIZE = 0x100000;
    private static final byte FIRST_IMAGE = 0;
    private final TIFFImageReader imageReader;
    private final Closeable closeable;
    private RenderedImage swappedSubsampledImage;
    private Rectangle rectangle;
    private ImageReadParam readParam;

    public GeoTiffImageReader(ImageInputStream imageInputStream) {
        this.imageReader = GeoTiffImageReader.findImageReader(imageInputStream);
        this.closeable = new NullCloseable();
    }

    public GeoTiffImageReader(File file) throws IOException {
        this.imageReader = GeoTiffImageReader.buildImageReader(file);
        this.closeable = new NullCloseable();
    }

    public GeoTiffImageReader(InputStream inputStream, Closeable closeable) throws IOException {
        this.imageReader = GeoTiffImageReader.buildImageReader(inputStream);
        this.closeable = closeable;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void close() {
        try {
            ImageInputStream imageInputStream = (ImageInputStream)this.imageReader.getInput();
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rectangle = null;
            this.readParam = null;
            this.swappedSubsampledImage = null;
        }
        finally {
            try {
                if (this.closeable != null) {
                    this.closeable.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public TIFFImageMetadata getImageMetadata() throws IOException {
        return (TIFFImageMetadata)this.imageReader.getImageMetadata(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster readRect(boolean isGlobalShifted180, int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, int destOffsetX, int destOffsetY, int destWidth, int destHeight) throws IOException {
        if (this.readParam == null) {
            this.readParam = this.imageReader.getDefaultReadParam();
        }
        if (this.rectangle == null) {
            this.rectangle = new Rectangle();
        }
        int subsamplingXOffset = sourceOffsetX % sourceStepX;
        int subsamplingYOffset = sourceOffsetY % sourceStepY;
        this.readParam.setSourceSubsampling(sourceStepX, sourceStepY, subsamplingXOffset, subsamplingYOffset);
        RenderedImage subsampledImage = this.imageReader.readAsRenderedImage(0, this.readParam);
        try {
            this.rectangle.setBounds(destOffsetX, destOffsetY, destWidth, destHeight);
            if (isGlobalShifted180) {
                if (this.swappedSubsampledImage == null) {
                    this.swappedSubsampledImage = GeoTiffImageReader.horizontalMosaic(this.getHalfImages(subsampledImage));
                }
                Raster raster = this.swappedSubsampledImage.getData(this.rectangle);
                return raster;
            }
            Raster raster = subsampledImage.getData(this.rectangle);
            return raster;
        }
        finally {
            WeakReference<RenderedImage> referenceImage = new WeakReference<RenderedImage>(subsampledImage);
            referenceImage.clear();
        }
    }

    public int getImageWidth() throws IOException {
        return this.imageReader.getWidth(0);
    }

    public int getImageHeight() throws IOException {
        return this.imageReader.getHeight(0);
    }

    public int getTileHeight() throws IOException {
        return this.imageReader.getTileHeight(0);
    }

    public int getTileWidth() throws IOException {
        return this.imageReader.getTileWidth(0);
    }

    public SampleModel getSampleModel() throws IOException {
        Iterator iter = this.imageReader.getImageTypes(0);
        ImageTypeSpecifier its = (ImageTypeSpecifier)iter.next();
        return its.getSampleModel();
    }

    public TIFFRenderedImage getBaseImage() throws IOException {
        ImageReadParam readParam = this.imageReader.getDefaultReadParam();
        return (TIFFRenderedImage)this.imageReader.readAsRenderedImage(0, readParam);
    }

    public Dimension computePreferredTiling(int rasterWidth, int rasterHeight) throws IOException {
        Dimension dimension;
        boolean isBadTiling;
        int imageWidth = this.getImageWidth();
        int imageHeight = this.getImageHeight();
        int tileWidth = this.getTileWidth();
        int tileHeight = this.getTileHeight();
        boolean bl = isBadTiling = tileWidth <= 1 || tileHeight <= 1 || imageWidth == tileWidth || imageHeight == tileHeight;
        if (isBadTiling) {
            dimension = JAIUtils.computePreferredTileSize((int)rasterWidth, (int)rasterHeight, (int)1);
        } else {
            if (tileWidth > rasterWidth) {
                tileWidth = rasterWidth;
            }
            if (tileHeight > rasterHeight) {
                tileHeight = rasterHeight;
            }
            dimension = new Dimension(tileWidth, tileHeight);
        }
        return dimension;
    }

    public Dimension validateSize(int metadataImageWidth, int metadataImageHeight) throws IOException {
        Dimension defaultBandSize = new Dimension(this.getImageWidth(), this.getImageHeight());
        if (defaultBandSize.width != metadataImageWidth) {
            throw new IllegalStateException("The width " + metadataImageWidth + " from the metadata file is not equal with the image width " + defaultBandSize.width + ".");
        }
        if (defaultBandSize.height != metadataImageHeight) {
            throw new IllegalStateException("The height " + metadataImageHeight + " from the metadata file is not equal with the image height " + defaultBandSize.height + ".");
        }
        return defaultBandSize;
    }

    public Dimension validateArea(Rectangle area) throws IOException {
        int imageWidth = this.getImageWidth();
        if (area.x + area.width > imageWidth) {
            throw new IllegalStateException("The coordinates are out of bounds: area.x=" + area.x + ", area.width=" + area.width + ", image.width=" + imageWidth);
        }
        int imageHeight = this.getImageHeight();
        if (area.y + area.height > imageHeight) {
            throw new IllegalStateException("The coordinates are out of bounds: area.y=" + area.y + ", area.height=" + area.height + ", image.height=" + imageHeight);
        }
        return new Dimension(imageWidth, imageHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TIFFImageReader buildImageReader(Object sourceImage) throws IOException {
        ImageInputStreamImpl imageInputStream;
        TIFFImageReader imageReader = null;
        if (sourceImage instanceof InputStream) {
            File systemCacheDir = null;
            imageInputStream = new FileCacheImageInputStream((InputStream)sourceImage, systemCacheDir);
        } else if (sourceImage instanceof File) {
            imageInputStream = new FileImageInputStream((File)sourceImage);
        } else {
            throw new IllegalArgumentException("sourceImage should be of type InputStream or File!");
        }
        try {
            imageReader = GeoTiffImageReader.findImageReader(imageInputStream);
        }
        finally {
            if (imageReader == null) {
                imageInputStream.close();
            }
        }
        return imageReader;
    }

    private static TIFFImageReader findImageReader(ImageInputStream imageInputStream) {
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
        while (imageReaders.hasNext()) {
            ImageReader reader = imageReaders.next();
            if (!(reader instanceof TIFFImageReader)) continue;
            TIFFImageReader imageReader = (TIFFImageReader)reader;
            imageReader.setInput((Object)imageInputStream);
            return imageReader;
        }
        throw new IllegalStateException("GeoTiff imageReader not found.");
    }

    private RenderedImage[] getHalfImages(RenderedImage fullImage) {
        int xStart = 0;
        boolean yStart = false;
        float width = (float)fullImage.getWidth() / 2.0f;
        float height = fullImage.getHeight();
        RenderedOp leftImage = CropDescriptor.create((RenderedImage)fullImage, (Float)Float.valueOf(xStart), (Float)Float.valueOf((float)yStart), (Float)Float.valueOf(width), (Float)Float.valueOf(height), null);
        xStart = fullImage.getWidth() / 2;
        width = fullImage.getWidth() - xStart;
        RenderedOp rightImage = CropDescriptor.create((RenderedImage)fullImage, (Float)Float.valueOf(xStart), (Float)Float.valueOf((float)yStart), (Float)Float.valueOf(width), (Float)Float.valueOf(height), null);
        return new RenderedImage[]{leftImage, rightImage};
    }

    private static RenderedImage horizontalMosaic(RenderedImage[] halfImages) {
        RenderedImage leftImage = halfImages[0];
        RenderedImage rightImage = halfImages[1];
        RenderedOp translatedLeftImage = TranslateDescriptor.create((RenderedImage)leftImage, (Float)Float.valueOf(leftImage.getWidth()), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        RenderedOp translatedRightImage = TranslateDescriptor.create((RenderedImage)rightImage, (Float)Float.valueOf(-1.0f * (float)rightImage.getWidth()), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        return MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{translatedRightImage, translatedLeftImage}, (MosaicType)MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null);
    }

    public static GeoTiffImageReader buildGeoTiffImageReader(Path productPath) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        return GeoTiffImageReader.buildGeoTiffImageReader(productPath, null);
    }

    public static GeoTiffImageReader buildGeoTiffImageReader(Path productPath, String childRelativePath) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (Files.exists(productPath, new LinkOption[0])) {
            if (Files.isDirectory(productPath, new LinkOption[0])) {
                Path child = productPath.resolve(childRelativePath);
                if (Files.exists(child, new LinkOption[0])) {
                    if (Files.isRegularFile(child, new LinkOption[0])) {
                        return new GeoTiffImageReader(child.toFile());
                    }
                    throw new NotRegularFileException("The product folder '" + productPath.toString() + "' does not contain the file '" + childRelativePath + "'.");
                }
                throw new FileNotFoundException("The product folder '" + productPath.toString() + "' does not contain the path '" + childRelativePath + "'.");
            }
            if (Files.isRegularFile(productPath, new LinkOption[0])) {
                if (productPath.getFileName().toString().toLowerCase().endsWith(".zip")) {
                    if (childRelativePath == null) {
                        return GeoTiffImageReader.buildGeoTiffImageReaderFromZipArchive(productPath);
                    }
                    return GeoTiffImageReader.buildGeoTiffImageReaderFromZipArchive(productPath, childRelativePath);
                }
                return new GeoTiffImageReader(productPath.toFile());
            }
            throw new NotRegularFileException(productPath.toString());
        }
        throw new FileNotFoundException("The product path '" + productPath + "' does not exist.");
    }

    private static GeoTiffImageReader buildGeoTiffImageReaderFromZipArchive(Path productPath, String zipEntryPath) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        boolean success = false;
        FileSystem fileSystem = null;
        try {
            fileSystem = ZipFileSystemBuilder.newZipFileSystem((Path)productPath);
            for (Path zipArchiveRoot : fileSystem.getRootDirectories()) {
                Path entryPathToFind = ZipFileSystemBuilder.buildZipEntryPath((Path)zipArchiveRoot, (String)zipEntryPath);
                FindChildFileVisitor findChildFileVisitor = new FindChildFileVisitor(entryPathToFind);
                Files.walkFileTree(zipArchiveRoot, (FileVisitor<? super Path>)findChildFileVisitor);
                if (findChildFileVisitor.getExistingChildFile() == null) continue;
                GeoTiffImageReader geoTiffImageReader = GeoTiffImageReader.buildGeoTiffImageReaderObject(findChildFileVisitor.getExistingChildFile(), fileSystem);
                success = true;
                GeoTiffImageReader geoTiffImageReader2 = geoTiffImageReader;
                return geoTiffImageReader2;
            }
            throw new FileNotFoundException("The zip archive '" + productPath.toString() + "' does not contain the file '" + zipEntryPath + "'.");
        }
        finally {
            if (fileSystem != null && !success) {
                fileSystem.close();
            }
        }
    }

    private static GeoTiffImageReader buildGeoTiffImageReaderFromZipArchive(Path productPath) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        boolean success = false;
        FileSystem fileSystem = null;
        try {
            fileSystem = ZipFileSystemBuilder.newZipFileSystem((Path)productPath);
            TreeSet filePaths = FileSystemUtils.listAllFilePaths((FileSystem)fileSystem);
            for (String filePath : filePaths) {
                boolean extensionMatches = Arrays.stream(GeoTiffProductReaderPlugIn.TIFF_FILE_EXTENSION).anyMatch(filePath.toLowerCase()::endsWith);
                if (!extensionMatches) continue;
                Path tiffImagePath = fileSystem.getPath(filePath, new String[0]);
                GeoTiffImageReader geoTiffImageReader = GeoTiffImageReader.buildGeoTiffImageReaderObject(tiffImagePath, fileSystem);
                success = true;
                GeoTiffImageReader geoTiffImageReader2 = geoTiffImageReader;
                return geoTiffImageReader2;
            }
            throw new IllegalArgumentException("The zip archive '" + productPath.toString() + "' does not contain an image. The item count is " + filePaths.size() + ".");
        }
        finally {
            if (fileSystem != null && !success) {
                fileSystem.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoTiffImageReader buildGeoTiffImageReaderObject(Path tiffPath, Closeable closeable) throws IOException {
        boolean success = false;
        InputStream inputStream = Files.newInputStream(tiffPath, new OpenOption[0]);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 0x100000);
            FilterInputStream inputStreamToReturn = tiffPath.getFileName().toString().endsWith(".gz") ? new GZIPInputStream(bufferedInputStream) : bufferedInputStream;
            GeoTiffImageReader geoTiffImageReader = new GeoTiffImageReader(inputStreamToReturn, closeable);
            success = true;
            GeoTiffImageReader geoTiffImageReader2 = geoTiffImageReader;
            return geoTiffImageReader2;
        }
        finally {
            if (!success) {
                inputStream.close();
            }
        }
    }

    public static CrsGeoCoding buildGeoCoding(TIFFImageMetadata metadata, int defaultProductWidth, int defaultProductHeight, Rectangle subsetRegion) throws Exception {
        CoordinateReferenceSystem mapCRS;
        GeoTiffIIOMetadataDecoder metadataDecoder = new GeoTiffIIOMetadataDecoder((IIOMetadata)metadata);
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)true);
        GeoTiffMetadata2CRSAdapter geoTiff2CRSAdapter = new GeoTiffMetadata2CRSAdapter(hints);
        MathTransform toModel = GeoTiffImageReader.getRasterToModel(metadataDecoder);
        try {
            mapCRS = geoTiff2CRSAdapter.createCoordinateSystem(metadataDecoder);
        }
        catch (UnsupportedOperationException e) {
            if (toModel == null) {
                throw e;
            }
            mapCRS = DefaultGeographicCRS.WGS84;
        }
        AffineTransform transform = (AffineTransform)toModel;
        if (metadataDecoder.getModelPixelScales() == null) {
            Rectangle imageBounds = subsetRegion == null ? new Rectangle(0, 0, defaultProductWidth, defaultProductHeight) : subsetRegion;
            return new CrsGeoCoding(mapCRS, imageBounds, transform);
        }
        double stepX = metadataDecoder.getModelPixelScales().getScaleX();
        double stepY = metadataDecoder.getModelPixelScales().getScaleY();
        double originX = transform.getTranslateX();
        double originY = transform.getTranslateY();
        return ImageUtils.buildCrsGeoCoding((double)originX, (double)originY, (double)stepX, (double)stepY, (int)defaultProductWidth, (int)defaultProductHeight, (CoordinateReferenceSystem)mapCRS, (Rectangle)subsetRegion);
    }

    private static MathTransform getRasterToModel(GeoTiffIIOMetadataDecoder metadata) throws GeoTiffException {
        LinearTransform xform;
        boolean hasTiePoints = metadata.hasTiePoints();
        boolean hasPixelScales = metadata.hasPixelScales();
        boolean hasModelTransformation = metadata.hasModelTrasformation();
        int rasterType = GeoTiffImageReader.getGeoKeyAsInt(1025, metadata);
        if (rasterType == 0) {
            rasterType = 1;
        }
        if (hasTiePoints && hasPixelScales) {
            TiePoint[] tiePoints = metadata.getModelTiePoints();
            PixelScale pixScales = metadata.getModelPixelScales();
            GeneralMatrix gm = new GeneralMatrix(3);
            double scaleRaster2ModelLongitude = pixScales.getScaleX();
            double scaleRaster2ModelLatitude = -pixScales.getScaleY();
            double tiePointColumn = tiePoints[0].getValueAt(0) + (rasterType == 2 ? 0.5 : 0.0);
            double tiePointRow = tiePoints[0].getValueAt(1) + (rasterType == 2 ? 0.5 : 0.0);
            gm.setElement(0, 0, scaleRaster2ModelLongitude);
            gm.setElement(1, 1, scaleRaster2ModelLatitude);
            gm.setElement(0, 1, 0.0);
            gm.setElement(1, 0, 0.0);
            gm.setElement(0, 2, tiePoints[0].getValueAt(3) - scaleRaster2ModelLongitude * tiePointColumn);
            gm.setElement(1, 2, tiePoints[0].getValueAt(4) - scaleRaster2ModelLatitude * tiePointRow);
            xform = ProjectiveTransform.create((Matrix)gm);
        } else if (hasModelTransformation) {
            if (rasterType == 2) {
                AffineTransform tempTransform = new AffineTransform(metadata.getModelTransformation());
                tempTransform.concatenate(AffineTransform.getTranslateInstance(0.5, 0.5));
                xform = ProjectiveTransform.create((AffineTransform)tempTransform);
            } else {
                assert (rasterType == 1);
                xform = ProjectiveTransform.create((AffineTransform)metadata.getModelTransformation());
            }
        } else {
            throw new GeoTiffException(metadata, "Unknown Raster to Model configuration.", null);
        }
        return xform;
    }

    private static int getGeoKeyAsInt(int key, GeoTiffIIOMetadataDecoder metadata) {
        try {
            return Integer.parseInt(metadata.getGeoKey(key));
        }
        catch (NumberFormatException ne) {
            logger.log(Level.FINE, ne.getMessage(), ne);
            return 0;
        }
    }

    private static class NullCloseable
    implements Closeable {
        private NullCloseable() {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

