/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import javax.media.jai.ImageLayout;
import javax.media.jai.SourcelessOpImage;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.image.AbstractMatrixMosaicSubsetMultiLevelSource;
import org.esa.snap.core.image.ImageReadBoundsSupport;
import org.esa.snap.core.image.MosaicMatrix;
import org.esa.snap.core.image.UncompressedTileOpImageCallback;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.dataio.geotiff.GeoTiffBandSource;
import org.esa.snap.dataio.geotiff.GeoTiffMatrixCell;
import org.esa.snap.dataio.geotiff.GeoTiffTileOpImage;

public class GeoTiffMatrixMultiLevelSource
extends AbstractMatrixMosaicSubsetMultiLevelSource
implements UncompressedTileOpImageCallback<GeoTiffMatrixCell>,
GeoTiffBandSource {
    private final int bandIndex;
    private final Double noDataValue;
    private final Dimension defaultJAIReadTileSize;

    public GeoTiffMatrixMultiLevelSource(MosaicMatrix spotBandMatrix, Rectangle imageMatrixReadBounds, int bandIndex, GeoCoding geoCoding, Double noDataValue, Dimension defaultJAIReadTileSize) {
        this(DefaultMultiLevelModel.getLevelCount((int)imageMatrixReadBounds.width, (int)imageMatrixReadBounds.height), spotBandMatrix, imageMatrixReadBounds, bandIndex, geoCoding, noDataValue, defaultJAIReadTileSize);
    }

    public GeoTiffMatrixMultiLevelSource(int levelCount, MosaicMatrix spotBandMatrix, Rectangle imageMatrixReadBounds, int bandIndex, GeoCoding geoCoding, Double noDataValue, Dimension defaultJAIReadTileSize) {
        super(levelCount, spotBandMatrix, imageMatrixReadBounds, defaultJAIReadTileSize, Product.findImageToModelTransform((GeoCoding)geoCoding));
        this.defaultJAIReadTileSize = defaultJAIReadTileSize;
        this.bandIndex = bandIndex;
        this.noDataValue = noDataValue;
    }

    public SourcelessOpImage buildTileOpImage(ImageReadBoundsSupport imageReadBoundsSupport, int tileWidth, int tileHeight, int tileOffsetFromReadBoundsX, int tileOffsetFromReadBoundsY, GeoTiffMatrixCell geoTiffMatrixCell) {
        return new GeoTiffTileOpImage(geoTiffMatrixCell, this, geoTiffMatrixCell.getDataBufferType(), tileWidth, tileHeight, tileOffsetFromReadBoundsX, tileOffsetFromReadBoundsY, imageReadBoundsSupport);
    }

    protected List<RenderedImage> buildMatrixCellTileImages(int level, Rectangle imageCellReadBounds, float cellTranslateLevelOffsetX, float cellTranslateLevelOffsetY, MosaicMatrix.MatrixCell matrixCell) {
        GeoTiffMatrixCell geoTiffMatrixCell = (GeoTiffMatrixCell)matrixCell;
        return this.buildUncompressedTileImages(level, imageCellReadBounds, geoTiffMatrixCell.getCellWidth(), geoTiffMatrixCell.getCellHeight(), cellTranslateLevelOffsetX, cellTranslateLevelOffsetY, this, geoTiffMatrixCell);
    }

    protected ImageLayout buildMosaicImageLayout(int level) {
        return null;
    }

    protected double[] getMosaicOpBackgroundValues() {
        if (this.noDataValue == null) {
            return super.getMosaicOpBackgroundValues();
        }
        return new double[]{this.noDataValue};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        super.reset();
        for (int rowIndex = 0; rowIndex < this.mosaicMatrix.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.mosaicMatrix.getColumnCount(); ++columnIndex) {
                GeoTiffMatrixCell geoTiffMatrixCell;
                GeoTiffMatrixCell geoTiffMatrixCell2 = geoTiffMatrixCell = (GeoTiffMatrixCell)this.mosaicMatrix.getCellAt(rowIndex, columnIndex);
                synchronized (geoTiffMatrixCell2) {
                    try {
                        geoTiffMatrixCell.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
    }

    @Override
    public boolean isGlobalShifted180() {
        return false;
    }

    @Override
    public int getBandIndex() {
        return this.bandIndex;
    }

    @Override
    public Dimension getDefaultJAIReadTileSize() {
        return this.defaultJAIReadTileSize;
    }

    @Override
    public boolean canDivideTileRegionToRead(int level) {
        return true;
    }

    public ImageLayout buildMultiLevelImageLayout() {
        AbstractMatrixMosaicSubsetMultiLevelSource.MatrixReadBounds matrixReadBounds = this.computeTopLeftMatrixCellReadBounds();
        GeoTiffMatrixCell topLeftMosaicMatrixCell = (GeoTiffMatrixCell)matrixReadBounds.getMatrixCell();
        Rectangle cellLocalIntersectionBounds = matrixReadBounds.getCellLocalIntersectionBounds();
        int topLeftTileWidth = GeoTiffMatrixMultiLevelSource.computeTopLeftUncompressedTileWidth((Rectangle)cellLocalIntersectionBounds, (int)topLeftMosaicMatrixCell.getCellWidth());
        int topLeftTileHeight = GeoTiffMatrixMultiLevelSource.computeTopLeftUncompressedTileHeight((Rectangle)cellLocalIntersectionBounds, (int)topLeftMosaicMatrixCell.getCellHeight());
        return ImageUtils.buildImageLayout((Integer)topLeftMosaicMatrixCell.getDataBufferType(), (int)this.imageReadBounds.width, (int)this.imageReadBounds.height, (int)0, (Dimension)this.defaultJAIReadTileSize, (int)topLeftTileWidth, (int)topLeftTileHeight);
    }
}

