/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.spi.ImageInputStreamSpi;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.metadata.MetadataInspector;
import org.esa.snap.dataio.FileImageInputStreamSpi;
import org.esa.snap.dataio.ImageRegistryUtils;
import org.esa.snap.dataio.geotiff.GeoTiffProductReader;

public class GeoTiffMetadataInspector
implements MetadataInspector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataInspector.Metadata getMetadata(Path productPath) throws IOException {
        MetadataInspector.Metadata metadata;
        block8: {
            FileImageInputStreamSpi imageInputStreamSpi = ImageRegistryUtils.registerImageInputStreamSpi();
            try {
                Product product = GeoTiffProductReader.readMetadataProduct(productPath, true);
                MetadataInspector.Metadata metadata2 = new MetadataInspector.Metadata(product.getSceneRasterWidth(), product.getSceneRasterHeight());
                for (int i = 0; i < product.getNumBands(); ++i) {
                    metadata2.addBandName(product.getBandAt(i).getName());
                }
                metadata2.setGeoCoding(product.getSceneGeoCoding());
                metadata = metadata2;
                if (imageInputStreamSpi == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (imageInputStreamSpi != null) {
                        ImageRegistryUtils.deregisterImageInputStreamSpi((ImageInputStreamSpi)imageInputStreamSpi);
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }
            ImageRegistryUtils.deregisterImageInputStreamSpi((ImageInputStreamSpi)imageInputStreamSpi);
        }
        return metadata;
    }
}

