/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.SourcelessOpImage;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.image.AbstractMosaicSubsetMultiLevelSource;
import org.esa.snap.core.image.ImageReadBoundsSupport;
import org.esa.snap.core.image.UncompressedTileOpImageCallback;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.dataio.geotiff.GeoTiffBandSource;
import org.esa.snap.dataio.geotiff.GeoTiffImageReader;
import org.esa.snap.dataio.geotiff.GeoTiffTileOpImage;

public class GeoTiffMultiLevelSource
extends AbstractMosaicSubsetMultiLevelSource
implements UncompressedTileOpImageCallback<Void>,
GeoTiffBandSource {
    private final GeoTiffImageReader geoTiffImageReader;
    private final boolean isGlobalShifted180;
    private final int dataBufferType;
    private final int bandIndex;
    private final Double noDataValue;
    private final Dimension defaultJAIReadTileSize;

    public GeoTiffMultiLevelSource(GeoTiffImageReader geoTiffImageReader, int dataBufferType, Rectangle imageReadBounds, Dimension mosaicImageTileSize, int bandIndex, GeoCoding geoCoding, boolean isGlobalShifted180, Double noDataValue, Dimension defaultJAITileSize) {
        super(imageReadBounds, mosaicImageTileSize, geoCoding);
        this.geoTiffImageReader = geoTiffImageReader;
        this.isGlobalShifted180 = isGlobalShifted180;
        this.dataBufferType = dataBufferType;
        this.bandIndex = bandIndex;
        this.noDataValue = noDataValue;
        this.defaultJAIReadTileSize = defaultJAITileSize;
    }

    public SourcelessOpImage buildTileOpImage(ImageReadBoundsSupport imageReadBoundsSupport, int tileWidth, int tileHeight, int tileOffsetFromReadBoundsX, int tileOffsetFromReadBoundsY, Void tileData) {
        return new GeoTiffTileOpImage(this.geoTiffImageReader, this, this.dataBufferType, tileWidth, tileHeight, tileOffsetFromReadBoundsX, tileOffsetFromReadBoundsY, imageReadBoundsSupport);
    }

    protected RenderedImage createImage(int level) {
        ArrayList<SourcelessOpImage> tileImages;
        if (this.tileSize.width == this.imageReadBounds.width && this.tileSize.height == this.imageReadBounds.height) {
            ImageReadBoundsSupport imageReadBoundsSupport = new ImageReadBoundsSupport(this.imageReadBounds, level, this.getModel().getScale(level));
            SourcelessOpImage tileOpImage = this.buildTileOpImage(imageReadBoundsSupport, this.tileSize.width, this.tileSize.height, 0, 0, null);
            this.tileImageDisposer.registerForDisposal((PlanarImage)tileOpImage);
            tileImages = new ArrayList<SourcelessOpImage>(1);
            tileImages.add(tileOpImage);
        } else {
            tileImages = this.buildUncompressedTileImages(level, this.imageReadBounds, this.tileSize.width, this.tileSize.height, 0.0f, 0.0f, this, null);
        }
        if (tileImages.size() > 0) {
            return this.buildMosaicOp(level, tileImages, true);
        }
        return null;
    }

    protected ImageLayout buildMosaicImageLayout(int level) {
        return null;
    }

    protected double[] getMosaicOpBackgroundValues() {
        if (this.noDataValue == null) {
            return super.getMosaicOpBackgroundValues();
        }
        return new double[]{this.noDataValue};
    }

    @Override
    public boolean isGlobalShifted180() {
        return this.isGlobalShifted180;
    }

    @Override
    public int getBandIndex() {
        return this.bandIndex;
    }

    @Override
    public Dimension getDefaultJAIReadTileSize() {
        return this.defaultJAIReadTileSize;
    }

    @Override
    public boolean canDivideTileRegionToRead(int level) {
        return level > 6;
    }

    public ImageLayout buildMultiLevelImageLayout() {
        int topLeftTileWidth = GeoTiffMultiLevelSource.computeTopLeftUncompressedTileWidth((Rectangle)this.imageReadBounds, (int)this.tileSize.width);
        int topLeftTileHeight = GeoTiffMultiLevelSource.computeTopLeftUncompressedTileHeight((Rectangle)this.imageReadBounds, (int)this.tileSize.height);
        return ImageUtils.buildImageLayout((Integer)this.dataBufferType, (int)this.imageReadBounds.width, (int)this.imageReadBounds.height, (int)0, (Dimension)this.defaultJAIReadTileSize, (int)topLeftTileWidth, (int)topLeftTileHeight);
    }
}

