/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import it.geosolutions.imageio.plugins.tiff.TIFFDirectory;
import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFRenderedImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.dataio.dimap.DimapProductHelpers;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.GcpDescriptor;
import org.esa.snap.core.datamodel.GcpGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.subset.AbstractSubsetRegion;
import org.esa.snap.core.subset.PixelSubsetRegion;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.ImageRegistryUtils;
import org.esa.snap.dataio.geotiff.GeoTiffImageReader;
import org.esa.snap.dataio.geotiff.GeoTiffMultiLevelSource;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.esa.snap.dataio.geotiff.TiffFileInfo;
import org.esa.snap.dataio.geotiff.TiffTagToMetadataConverter;
import org.esa.snap.dataio.geotiff.Utils;
import org.esa.snap.dataio.geotiff.internal.GeoKeyEntry;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;

public class GeoTiffProductReader
extends AbstractProductReader {
    private static final int TIFFTAG_GDAL_METADATA = 42112;
    private ImageInputStreamSpi imageInputStreamSpi;
    private GeoTiffImageReader geoTiffImageReader;

    public GeoTiffProductReader(ProductReaderPlugIn readerPlugIn) {
        this(readerPlugIn, (ImageInputStreamSpi)ImageRegistryUtils.registerImageInputStreamSpi());
    }

    public GeoTiffProductReader(ProductReaderPlugIn readerPlugIn, ImageInputStreamSpi imageInputStreamSpi) {
        super(readerPlugIn);
        this.imageInputStreamSpi = imageInputStreamSpi;
    }

    protected Product readProductNodesImpl() throws IOException {
        if (this.geoTiffImageReader != null) {
            throw new IllegalStateException("There is already an image reader.");
        }
        boolean success = false;
        try {
            Object productInput = super.getInput();
            ProductSubsetDef subsetDef = super.getSubsetDef();
            Path productPath = null;
            if (productInput instanceof String) {
                productPath = new File((String)productInput).toPath();
                this.geoTiffImageReader = GeoTiffImageReader.buildGeoTiffImageReader(productPath);
            } else if (productInput instanceof File) {
                productPath = ((File)productInput).toPath();
                this.geoTiffImageReader = GeoTiffImageReader.buildGeoTiffImageReader(productPath);
            } else if (productInput instanceof Path) {
                productPath = (Path)productInput;
                this.geoTiffImageReader = GeoTiffImageReader.buildGeoTiffImageReader(productPath);
            } else if (productInput instanceof InputStream) {
                this.geoTiffImageReader = new GeoTiffImageReader((InputStream)productInput, null);
            } else {
                throw new IllegalArgumentException("Unknown input '" + productInput + "'.");
            }
            String defaultProductName = null;
            if (productPath != null) {
                defaultProductName = FileUtils.getFilenameWithoutExtension((String)productPath.getFileName().toString());
            }
            Product product = this.readProduct(this.geoTiffImageReader, defaultProductName, subsetDef);
            if (productPath != null) {
                product.setFileLocation(productPath.toFile());
            }
            success = true;
            Product product2 = product;
            return product2;
        }
        catch (IOException | RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        finally {
            if (!success) {
                this.closeResources();
            }
        }
    }

    public void close() throws IOException {
        super.close();
        this.closeResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        boolean isInteger;
        Raster data;
        if (this.geoTiffImageReader == null) {
            throw new NullPointerException("The image reader is null.");
        }
        DefaultMultiLevelImage defaultMultiLevelImage = (DefaultMultiLevelImage)destBand.getSourceImage();
        GeoTiffMultiLevelSource geoTiffMultiLevelSource = (GeoTiffMultiLevelSource)defaultMultiLevelImage.getSource();
        GeoTiffImageReader geoTiffImageReader = this.geoTiffImageReader;
        synchronized (geoTiffImageReader) {
            data = this.geoTiffImageReader.readRect(geoTiffMultiLevelSource.isGlobalShifted180(), sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destOffsetX, destOffsetY, destWidth, destHeight);
        }
        DataBuffer dataBuffer = data.getDataBuffer();
        SampleModel sampleModel = data.getSampleModel();
        int dataBufferType = dataBuffer.getDataType();
        int bandIndex = geoTiffMultiLevelSource.getBandIndex();
        boolean bl = isInteger = dataBufferType == 2 || dataBufferType == 1 || dataBufferType == 3;
        if (isInteger && destBuffer.getElems() instanceof int[]) {
            sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), bandIndex, (int[])destBuffer.getElems(), dataBuffer);
        } else if (dataBufferType == 4 && destBuffer.getElems() instanceof float[]) {
            sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), bandIndex, (float[])destBuffer.getElems(), dataBuffer);
        } else if (dataBufferType == 0 && destBuffer.getElems() instanceof byte[]) {
            int[] dArray = new int[destWidth * destHeight];
            sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), bandIndex, dArray, dataBuffer);
            for (int i = 0; i < dArray.length; ++i) {
                destBuffer.setElemIntAt(i, dArray[i]);
            }
        } else {
            double[] dArray = new double[destWidth * destHeight];
            sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), bandIndex, dArray, dataBuffer);
            if (destBuffer.getElems() instanceof double[]) {
                System.arraycopy(dArray, 0, destBuffer.getElems(), 0, dArray.length);
            } else {
                for (int i = 0; i < dArray.length; ++i) {
                    destBuffer.setElemDoubleAt(i, dArray[i]);
                }
            }
        }
    }

    private void closeResources() {
        try {
            if (this.geoTiffImageReader != null) {
                this.geoTiffImageReader.close();
                this.geoTiffImageReader = null;
            }
        }
        finally {
            if (this.imageInputStreamSpi != null) {
                ImageRegistryUtils.deregisterImageInputStreamSpi((ImageInputStreamSpi)this.imageInputStreamSpi);
                this.imageInputStreamSpi = null;
            }
        }
        System.gc();
    }

    public Product readProduct(GeoTiffImageReader geoTiffImageReader, String productName) throws Exception {
        return this.readProduct(geoTiffImageReader, productName, (ProductSubsetDef)null);
    }

    public Product readProduct(GeoTiffImageReader geoTiffImageReader, String productName, ProductSubsetDef subsetDef) throws Exception {
        Rectangle productBounds;
        if (geoTiffImageReader == null) {
            throw new NullPointerException("The image reader is null.");
        }
        int imageWidth = geoTiffImageReader.getImageWidth();
        int imageHeight = geoTiffImageReader.getImageHeight();
        if (subsetDef == null || subsetDef.getSubsetRegion() == null) {
            productBounds = new Rectangle(0, 0, imageWidth, imageHeight);
        } else {
            GeoCoding geoCoding = GeoTiffProductReader.readGeoCoding(geoTiffImageReader, null);
            productBounds = subsetDef.getSubsetRegion().computeProductPixelRegion(geoCoding, imageWidth, imageHeight, false);
        }
        return this.readProduct(geoTiffImageReader, productName, productBounds);
    }

    public Product readProduct(GeoTiffImageReader geoTiffImageReader, String defaultProductName, Rectangle productBounds) throws Exception {
        return this.readProduct(geoTiffImageReader, defaultProductName, productBounds, null, null);
    }

    public Product readProduct(GeoTiffImageReader geoTiffImageReader, String defaultProductName, Rectangle productBounds, Double noDataValue) throws Exception {
        return this.readProduct(geoTiffImageReader, defaultProductName, productBounds, noDataValue, null);
    }

    public Product readProduct(GeoTiffImageReader geoTiffImageReader, String defaultProductName, Rectangle productBounds, Double noDataValue, ProductSubsetDef subsetDef) throws Exception {
        SampleModel sampleModel;
        if (geoTiffImageReader == null) {
            throw new NullPointerException("The image reader is null.");
        }
        if (productBounds.isEmpty()) {
            throw new IllegalStateException("Empty product bounds.");
        }
        Dimension defaultImageSize = geoTiffImageReader.validateArea(productBounds);
        TIFFImageMetadata imageMetadata = geoTiffImageReader.getImageMetadata();
        TiffFileInfo tiffInfo = new TiffFileInfo((TIFFDirectory)imageMetadata.getRootIFD());
        Product product = GeoTiffProductReader.buildProductFromDimapHeader(tiffInfo, productBounds.width, productBounds.height);
        if (product == null) {
            boolean createIndexedImageInfo;
            TIFFRenderedImage baseImage = geoTiffImageReader.getBaseImage();
            product = GeoTiffProductReader.buildProductWithoutDimapHeader(defaultProductName, tiffInfo, baseImage, productBounds.width, productBounds.height);
            sampleModel = baseImage.getSampleModel();
            boolean bl = createIndexedImageInfo = tiffInfo.containsField(320) && baseImage.getColorModel() instanceof IndexColorModel;
            if (createIndexedImageInfo) {
                for (int i = 0; i < product.getNumBands(); ++i) {
                    Band band = product.getBandAt(i);
                    band.setImageInfo(GeoTiffProductReader.buildIndexedImageInfo(product, baseImage, band));
                }
            }
        } else {
            sampleModel = geoTiffImageReader.getBaseImage().getSampleModel();
        }
        product.setProductReader((ProductReader)this);
        boolean isGlobalShifted180 = false;
        if (tiffInfo.isGeotiff()) {
            Rectangle subsetRegion = null;
            if (productBounds.x != 0 || productBounds.y != 0 || productBounds.width != defaultImageSize.width || productBounds.height != defaultImageSize.height) {
                subsetRegion = productBounds;
            }
            isGlobalShifted180 = GeoTiffProductReader.applyGeoCoding(tiffInfo, imageMetadata, defaultImageSize.width, defaultImageSize.height, product, subsetRegion);
        }
        if (subsetDef == null || !subsetDef.isIgnoreMetadata()) {
            TiffTagToMetadataConverter.addTiffTagsToMetadata(imageMetadata, tiffInfo, product.getMetadataRoot());
        } else {
            product.getMetadataRoot().dispose();
            product.getMetadataRoot().setModified(false);
        }
        Dimension defaultJAIReadTileSize = JAI.getDefaultTileSize();
        product.setPreferredTileSize(defaultJAIReadTileSize);
        Dimension mosaicImageTileSize = product.getSceneRasterSize();
        GeoCoding bandGeoCoding = this.buildBandGeoCoding(product.getSceneGeoCoding(), productBounds.width, productBounds.height);
        AffineTransform2D imageToModelTransform = this.buildBandImageToModelTransform(productBounds.width, productBounds.height);
        int bandIndex = 0;
        for (int i = 0; i < product.getNumBands(); ++i) {
            boolean addBand;
            Band band = product.getBandAt(i);
            boolean bl = addBand = subsetDef == null || subsetDef.isNodeAccepted(band.getName());
            if (!(band instanceof VirtualBand) && !(band instanceof FilterBand)) {
                if (addBand) {
                    if (band.getRasterWidth() != productBounds.width) {
                        throw new IllegalStateException("The band width " + band.getRasterWidth() + " is not equal with the product with " + productBounds.width + ".");
                    }
                    if (band.getRasterHeight() != productBounds.height) {
                        throw new IllegalStateException("The band height " + band.getRasterHeight() + " is not equal with the product height " + productBounds.height + ".");
                    }
                    if (bandGeoCoding != null) {
                        band.setGeoCoding(bandGeoCoding);
                    }
                    if (imageToModelTransform != null) {
                        band.setImageToModelTransform((AffineTransform)imageToModelTransform);
                    }
                    if (bandIndex >= sampleModel.getNumBands()) {
                        throw new IllegalStateException("The band index " + bandIndex + " must be < " + sampleModel.getNumBands() + ". The band name is '" + band.getName() + "'.");
                    }
                    int dataBufferType = ImageManager.getDataBufferType((int)band.getDataType());
                    GeoTiffMultiLevelSource multiLevelSource = new GeoTiffMultiLevelSource(geoTiffImageReader, dataBufferType, productBounds, mosaicImageTileSize, bandIndex, band.getGeoCoding(), isGlobalShifted180, noDataValue, defaultJAIReadTileSize);
                    ImageLayout imageLayout = multiLevelSource.buildMultiLevelImageLayout();
                    band.setSourceImage((MultiLevelImage)new DefaultMultiLevelImage((MultiLevelSource)multiLevelSource, imageLayout));
                }
                ++bandIndex;
            }
            if (addBand) continue;
            if (product.removeBand(band)) {
                --i;
                continue;
            }
            throw new IllegalStateException("Failed to remove the band '" + band.getName() + "' at index " + i + " from the product.");
        }
        return product;
    }

    protected AffineTransform2D buildBandImageToModelTransform(int productWidth, int productHeight) {
        return null;
    }

    protected GeoCoding buildBandGeoCoding(GeoCoding productGeoCoding, int productWidth, int productHeight) throws Exception {
        return productGeoCoding;
    }

    private static Product buildProductFromDimapHeader(TiffFileInfo tiffInfo, int productWidth, int productHeight) throws IOException {
        String tagNumberText;
        TIFFField tagNumberField = tiffInfo.getField(65000);
        Product product = null;
        if (tagNumberField != null && tagNumberField.getType() == 2 && (tagNumberText = tagNumberField.getAsString(0).trim()).contains("<Dimap_Document")) {
            Dimension productSize = new Dimension(productWidth, productHeight);
            product = GeoTiffProductReader.buildProductFromDimapHeader(tagNumberText, productSize);
        }
        return product;
    }

    private static Product buildProductWithoutDimapHeader(String defaultProductName, TiffFileInfo tiffInfo, TIFFRenderedImage baseImage, int productWidth, int productHeight) throws Exception {
        Band[] bands;
        String productName = null;
        if (tiffInfo.containsField(270)) {
            TIFFField tagImageDescriptionField = tiffInfo.getField(270);
            productName = tagImageDescriptionField.getAsString(0).trim();
        }
        productName = StringUtils.isBlank(productName) && defaultProductName != null ? defaultProductName : "geotiff";
        Product product = new Product(productName, GeoTiffProductReaderPlugIn.FORMAT_NAMES[0], productWidth, productHeight);
        for (Band band : bands = GeoTiffProductReader.buildBands(tiffInfo, baseImage, product.getSceneRasterWidth(), product.getSceneRasterHeight())) {
            product.addBand(band);
        }
        return product;
    }

    private static Band[] buildBands(TiffFileInfo tiffInfo, TIFFRenderedImage baseImage, int productWidth, int productHeight) throws Exception {
        String gdalMetadataXmlString;
        Band[] bandsFromGdalMetadata;
        SampleModel sampleModel = baseImage.getSampleModel();
        int numBands = sampleModel.getNumBands();
        int productDataType = ImageManager.getProductDataType((int)sampleModel.getDataType());
        TIFFField gdalMetadataTiffField = tiffInfo.getField(42112);
        if (gdalMetadataTiffField != null && (bandsFromGdalMetadata = Utils.setupBandsFromGdalMetadata(gdalMetadataXmlString = gdalMetadataTiffField.getAsString(0), productDataType, productWidth, productHeight)).length == numBands) {
            return bandsFromGdalMetadata;
        }
        Band[] bands = new Band[numBands];
        for (int i = 0; i < numBands; ++i) {
            String bandName = String.format("band_%d", i + 1);
            bands[i] = new Band(bandName, productDataType, productWidth, productHeight);
        }
        return bands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Product buildProductFromDimapHeader(String tagNumberText, Dimension productSize) throws IOException {
        Product product = null;
        try (InputStream inputStream = null;){
            TiePointGrid[] pointGrids;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            inputStream = new ByteArrayInputStream(tagNumberText.getBytes());
            Document document = new DOMBuilder().build(builder.parse(inputStream));
            product = DimapProductHelpers.createProduct((Document)document, (String)GeoTiffProductReaderPlugIn.FORMAT_NAMES[0], (Dimension)productSize);
            product.setSceneGeoCoding(null);
            for (TiePointGrid pointGrid : pointGrids = product.getTiePointGrids()) {
                product.removeTiePointGrid(pointGrid);
            }
        }
        return product;
    }

    private static ImageInfo buildIndexedImageInfo(Product product, TIFFRenderedImage baseImage, Band band) {
        IndexColorModel colorModel = (IndexColorModel)baseImage.getColorModel();
        IndexCoding indexCoding = new IndexCoding("color_map");
        int colorCount = colorModel.getMapSize();
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[colorCount];
        for (int j = 0; j < colorCount; ++j) {
            String name = String.format("I%3d", j);
            indexCoding.addIndex(name, j, "");
            points[j] = new ColorPaletteDef.Point((double)j, new Color(colorModel.getRGB(j)), name);
        }
        product.getIndexCodingGroup().add((ProductNode)indexCoding);
        band.setSampleCoding((SampleCoding)indexCoding);
        return new ImageInfo(new ColorPaletteDef(points, points.length));
    }

    private static boolean applyGeoCoding(TiffFileInfo info, TIFFImageMetadata metadata, int defaultImageWidth, int defaultImageHeight, Product product, Rectangle subsetRegion) throws Exception {
        boolean isGlobalShifted180 = false;
        if (info.containsField(33922)) {
            double[] tiePoints = info.getField(33922).getAsDoubles();
            int rasterWidth = defaultImageWidth;
            boolean isGlobal = GeoTiffProductReader.isGlobal(rasterWidth, info);
            double deltaX = Math.ceil(360.0 / (double)rasterWidth);
            if (isGlobal && tiePoints.length == 6 && Math.abs(tiePoints[3]) < deltaX) {
                isGlobalShifted180 = true;
                TiePointGeoCoding tiePointGeoCoding = GeoTiffProductReader.buildGlobalShiftedTiePointGeoCoding(info, defaultImageWidth, defaultImageHeight, subsetRegion);
                if (tiePointGeoCoding != null) {
                    product.getTiePointGridGroup().add((ProductNode)tiePointGeoCoding.getLatGrid());
                    product.getTiePointGridGroup().add((ProductNode)tiePointGeoCoding.getLonGrid());
                    product.setSceneGeoCoding((GeoCoding)tiePointGeoCoding);
                }
            } else if (GeoTiffProductReader.canCreateTiePointGeoCoding(tiePoints)) {
                String[] names = Utils.findSuitableLatLonNames(product);
                TiePointGeoCoding tiePointGeoCoding = GeoTiffProductReader.buildTiePointGeoCoding(info, tiePoints, names, subsetRegion);
                product.addTiePointGrid(tiePointGeoCoding.getLatGrid());
                product.addTiePointGrid(tiePointGeoCoding.getLonGrid());
                product.setSceneGeoCoding((GeoCoding)tiePointGeoCoding);
            } else if (GeoTiffProductReader.canCreateGcpGeoCoding(tiePoints)) {
                GeoTiffProductReader.applyGcpGeoCoding(info, tiePoints, product);
            }
        }
        if (product.getSceneGeoCoding() == null) {
            CrsGeoCoding crsGeoCoding = GeoTiffImageReader.buildGeoCoding(metadata, defaultImageWidth, defaultImageHeight, subsetRegion);
            product.setSceneGeoCoding((GeoCoding)crsGeoCoding);
        }
        return isGlobalShifted180;
    }

    private static TiePointGeoCoding buildGlobalShiftedTiePointGeoCoding(TiffFileInfo info, int productWidth, int productHeight, Rectangle subsetRegion) {
        TIFFField pixelScaleField = info.getField(33550);
        TIFFField tiePointField = info.getField(33922);
        if (pixelScaleField != null && tiePointField != null) {
            double[] pixelScales = pixelScaleField.getAsDoubles();
            double[] tiePoints = tiePointField.getAsDoubles();
            if (GeoTiffProductReader.isPixelScaleValid(pixelScales)) {
                float[] latPoints = new float[productWidth * productHeight];
                tiePoints[4] = Math.min(tiePoints[4], 90.0);
                for (int j = 0; j < productHeight; ++j) {
                    for (int i = 0; i < productWidth; ++i) {
                        latPoints[j * productWidth + i] = (float)(tiePoints[4] - (double)j * pixelScales[1]);
                    }
                }
                float[] lonPoints = new float[productWidth * productHeight];
                for (int j = 0; j < productHeight; ++j) {
                    for (int i = 0; i < productWidth; ++i) {
                        lonPoints[j * productWidth + i] = (float)((double)i * pixelScales[0] - 180.0);
                    }
                }
                TiePointGrid latGrid = new TiePointGrid("latGrid", productWidth, productHeight, 0.0, 0.0, 1.0, 1.0, latPoints);
                TiePointGrid lonGrid = new TiePointGrid("lonGrid", productWidth, productHeight, 0.0, 0.0, 1.0, 1.0, lonPoints);
                if (subsetRegion != null) {
                    ProductSubsetDef productSubsetDef = new ProductSubsetDef();
                    productSubsetDef.setSubsetRegion((AbstractSubsetRegion)new PixelSubsetRegion(subsetRegion, 0));
                    productSubsetDef.setSubSampling(1, 1);
                    lonGrid = TiePointGrid.createSubset((TiePointGrid)lonGrid, (ProductSubsetDef)productSubsetDef);
                    latGrid = TiePointGrid.createSubset((TiePointGrid)latGrid, (ProductSubsetDef)productSubsetDef);
                }
                return new TiePointGeoCoding(latGrid, lonGrid);
            }
        }
        return null;
    }

    private static boolean isGlobal(int productWidth, TiffFileInfo info) {
        double[] pixelScales;
        TIFFField pixelScaleField = info.getField(33550);
        if (pixelScaleField != null && GeoTiffProductReader.isPixelScaleValid(pixelScales = pixelScaleField.getAsDoubles())) {
            double widthInDegree = pixelScales[0] * (double)productWidth;
            return Math.ceil(widthInDegree) >= 360.0;
        }
        return false;
    }

    private static boolean isPixelScaleValid(double[] pixelScales) {
        return pixelScales != null && !Double.isNaN(pixelScales[0]) && !Double.isInfinite(pixelScales[0]) && !Double.isNaN(pixelScales[1]) && !Double.isInfinite(pixelScales[1]);
    }

    public static GeoCoding readGeoCoding(Path productPath, Rectangle subsetRegion) throws Exception {
        try (GeoTiffImageReader geoTiffImageReader = GeoTiffImageReader.buildGeoTiffImageReader(productPath);){
            GeoCoding geoCoding = GeoTiffProductReader.readGeoCoding(geoTiffImageReader, subsetRegion);
            return geoCoding;
        }
    }

    public static GeoCoding readGeoCoding(GeoTiffImageReader geoTiffImageReader, Rectangle subsetRegion) throws Exception {
        TIFFImageMetadata imageMetadata = geoTiffImageReader.getImageMetadata();
        TiffFileInfo tiffInfo = new TiffFileInfo((TIFFDirectory)imageMetadata.getRootIFD());
        if (tiffInfo.isGeotiff()) {
            int productWidth = geoTiffImageReader.getImageWidth();
            int productHeight = geoTiffImageReader.getImageHeight();
            Product product = new Product("GeoTiff", GeoTiffProductReaderPlugIn.FORMAT_NAMES[0], productWidth, productHeight);
            GeoTiffProductReader.applyGeoCoding(tiffInfo, imageMetadata, productWidth, productHeight, product, subsetRegion);
            return product.getSceneGeoCoding();
        }
        return null;
    }

    public static Product readMetadataProduct(Path productPath, boolean readGeoCoding) throws Exception {
        try (GeoTiffImageReader geoTiffImageReader = GeoTiffImageReader.buildGeoTiffImageReader(productPath);){
            Product product = GeoTiffProductReader.readMetadataProduct(geoTiffImageReader, readGeoCoding);
            return product;
        }
    }

    public static Product readMetadataProduct(GeoTiffImageReader geoTiffImageReader, boolean readGeoCoding) throws Exception {
        int productWidth = geoTiffImageReader.getImageWidth();
        int productHeight = geoTiffImageReader.getImageHeight();
        TIFFImageMetadata imageMetadata = geoTiffImageReader.getImageMetadata();
        TiffFileInfo tiffInfo = new TiffFileInfo((TIFFDirectory)imageMetadata.getRootIFD());
        Product product = GeoTiffProductReader.buildProductFromDimapHeader(tiffInfo, productWidth, productHeight);
        if (product == null) {
            product = GeoTiffProductReader.buildProductWithoutDimapHeader(null, tiffInfo, geoTiffImageReader.getBaseImage(), productWidth, productHeight);
        }
        if (readGeoCoding && tiffInfo.isGeotiff()) {
            GeoTiffProductReader.applyGeoCoding(tiffInfo, imageMetadata, productWidth, productHeight, product, null);
        }
        return product;
    }

    private static TiePointGeoCoding buildTiePointGeoCoding(TiffFileInfo info, double[] tiePoints, String[] names, Rectangle subsetRegion) {
        TreeSet<Double> xSet = new TreeSet<Double>();
        TreeSet<Double> ySet = new TreeSet<Double>();
        for (int i = 0; i < tiePoints.length; i += 6) {
            xSet.add(tiePoints[i]);
            ySet.add(tiePoints[i + 1]);
        }
        double xMin = (Double)xSet.first();
        double xMax = (Double)xSet.last();
        double xDiff = (xMax - xMin) / (double)(xSet.size() - 1);
        double yMin = (Double)ySet.first();
        double yMax = (Double)ySet.last();
        double yDiff = (yMax - yMin) / (double)(ySet.size() - 1);
        int width = xSet.size();
        int height = ySet.size();
        int idx = 0;
        HashMap<Double, Integer> xIdx = new HashMap<Double, Integer>();
        for (Double d : xSet) {
            xIdx.put(d, idx);
            ++idx;
        }
        idx = 0;
        HashMap<Double, Integer> yIdx = new HashMap<Double, Integer>();
        for (Double val : ySet) {
            yIdx.put(val, idx);
            ++idx;
        }
        float[] fArray = new float[width * height];
        float[] lons = new float[width * height];
        for (int i = 0; i < tiePoints.length; i += 6) {
            int idxX = (Integer)xIdx.get(tiePoints[i + 0]);
            int idxY = (Integer)yIdx.get(tiePoints[i + 1]);
            int arrayIdx = idxY * width + idxX;
            lons[arrayIdx] = (float)tiePoints[i + 3];
            fArray[arrayIdx] = (float)tiePoints[i + 4];
        }
        SortedMap<Integer, GeoKeyEntry> geoKeyEntries = info.getGeoKeyEntries();
        Datum datum = GeoTiffProductReader.getDatum(geoKeyEntries);
        TiePointGrid latGrid = new TiePointGrid(names[0], width, height, xMin, yMin, xDiff, yDiff, fArray);
        TiePointGrid lonGrid = new TiePointGrid(names[1], width, height, xMin, yMin, xDiff, yDiff, lons);
        if (subsetRegion != null) {
            ProductSubsetDef productSubsetDef = new ProductSubsetDef();
            productSubsetDef.setSubsetRegion((AbstractSubsetRegion)new PixelSubsetRegion(subsetRegion, 0));
            productSubsetDef.setSubSampling(1, 1);
            lonGrid = TiePointGrid.createSubset((TiePointGrid)lonGrid, (ProductSubsetDef)productSubsetDef);
            latGrid = TiePointGrid.createSubset((TiePointGrid)latGrid, (ProductSubsetDef)productSubsetDef);
        }
        return new TiePointGeoCoding(latGrid, lonGrid, datum);
    }

    private static boolean canCreateGcpGeoCoding(double[] tiePoints) {
        int numTiePoints = tiePoints.length / 6;
        for (int i = 0; i < numTiePoints; ++i) {
            int offset = i * 6;
            float x = (float)tiePoints[offset + 0];
            float y = (float)tiePoints[offset + 1];
            float lon = (float)tiePoints[offset + 3];
            float lat = (float)tiePoints[offset + 4];
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(lon) || Double.isNaN(lat)) {
                return false;
            }
            PixelPos pixelPos = new PixelPos((double)x, (double)y);
            GeoPos geoPos = new GeoPos((double)lat, (double)lon);
            if (pixelPos.isValid() && geoPos.isValid()) continue;
            return false;
        }
        if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL3.getTermCountP()) {
            return true;
        }
        if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL2.getTermCountP()) {
            return true;
        }
        return numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL1.getTermCountP();
    }

    private static boolean canCreateTiePointGeoCoding(double[] tiePoints) {
        if (tiePoints.length / 6 <= 1) {
            return false;
        }
        for (double tiePoint : tiePoints) {
            if (!Double.isNaN(tiePoint)) continue;
            return false;
        }
        TreeSet<Double> xSet = new TreeSet<Double>();
        TreeSet<Double> ySet = new TreeSet<Double>();
        for (int i = 0; i < tiePoints.length; i += 6) {
            xSet.add(tiePoints[i]);
            ySet.add(tiePoints[i + 1]);
        }
        return GeoTiffProductReader.isEquiDistance(xSet) && GeoTiffProductReader.isEquiDistance(ySet);
    }

    private static boolean isEquiDistance(SortedSet<Double> set) {
        double min = set.first();
        double max = set.last();
        double diff = (max - min) / (double)(set.size() - 1);
        double diff100000 = diff / 100000.0;
        double maxDiff = diff + diff100000;
        double minDiff = diff - diff100000;
        Double[] values = set.toArray(new Double[set.size()]);
        for (int i = 1; i < values.length; ++i) {
            double currentDiff = values[i] - values[i - 1];
            if (!(currentDiff > maxDiff) && !(currentDiff < minDiff)) continue;
            return false;
        }
        return true;
    }

    private static void applyGcpGeoCoding(TiffFileInfo info, double[] tiePoints, Product product) {
        GcpGeoCoding.Method method;
        int numTiePoints = tiePoints.length / 6;
        if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL3.getTermCountP()) {
            method = GcpGeoCoding.Method.POLYNOMIAL3;
        } else if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL2.getTermCountP()) {
            method = GcpGeoCoding.Method.POLYNOMIAL2;
        } else if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL1.getTermCountP()) {
            method = GcpGeoCoding.Method.POLYNOMIAL1;
        } else {
            return;
        }
        GcpDescriptor gcpDescriptor = GcpDescriptor.getInstance();
        PlacemarkGroup gcpGroup = product.getGcpGroup();
        for (int i = 0; i < numTiePoints; ++i) {
            int offset = i * 6;
            float x = (float)tiePoints[offset + 0];
            float y = (float)tiePoints[offset + 1];
            float lon = (float)tiePoints[offset + 3];
            float lat = (float)tiePoints[offset + 4];
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(lon) || Double.isNaN(lat)) continue;
            PixelPos pixelPos = new PixelPos((double)x, (double)y);
            GeoPos geoPos = new GeoPos((double)lat, (double)lon);
            Placemark gcp = Placemark.createPointPlacemark((PlacemarkDescriptor)gcpDescriptor, (String)("gcp_" + i), (String)("GCP_" + i), (String)"", (PixelPos)pixelPos, (GeoPos)geoPos, (GeoCoding)product.getSceneGeoCoding());
            gcpGroup.add((ProductNode)gcp);
        }
        Placemark[] gcps = (Placemark[])gcpGroup.toArray((ProductNode[])new Placemark[gcpGroup.getNodeCount()]);
        SortedMap<Integer, GeoKeyEntry> geoKeyEntries = info.getGeoKeyEntries();
        Datum datum = GeoTiffProductReader.getDatum(geoKeyEntries);
        int productWidth = product.getSceneRasterWidth();
        int productHeight = product.getSceneRasterHeight();
        product.setSceneGeoCoding((GeoCoding)new GcpGeoCoding(method, gcps, productWidth, productHeight, datum));
    }

    private static Datum getDatum(Map<Integer, GeoKeyEntry> geoKeyEntries) {
        int value;
        Datum datum = geoKeyEntries.containsKey(2048) ? ((value = geoKeyEntries.get(2048).getIntValue().intValue()) == 4322 ? Datum.WGS_72 : (value == 4326 ? Datum.WGS_84 : Datum.WGS_84)) : Datum.WGS_84;
        return datum;
    }
}

