/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.metadata.MetadataInspector;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.geotiff.GeoTiffMetadataInspector;
import org.esa.snap.dataio.geotiff.GeoTiffProductReader;
import org.esa.snap.dataio.geotiff.Utils;
import org.esa.snap.engine_utilities.util.FileSystemUtils;
import org.esa.snap.engine_utilities.util.ZipFileSystemBuilder;

public class GeoTiffProductReaderPlugIn
implements ProductReaderPlugIn {
    public static final String[] FORMAT_NAMES = new String[]{"GeoTIFF"};
    public static final String[] TIFF_FILE_EXTENSION = new String[]{".tif", ".tiff", ".gtif", ".btf"};
    public static final String ZIP_FILE_EXTENSION = ".zip";
    private static final String[] ALL_FILE_EXTENSIONS = StringUtils.addToArray((String[])TIFF_FILE_EXTENSION, (String)".zip");

    public MetadataInspector getMetadataInspector() {
        return new GeoTiffMetadataInspector();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DecodeQualification getDecodeQualification(Object productInputFile) {
        try {
            Path productPath = null;
            if (productInputFile instanceof String) {
                productPath = Paths.get((String)productInputFile, new String[0]);
            } else if (productInputFile instanceof File) {
                productPath = ((File)productInputFile).toPath();
            } else if (productInputFile instanceof Path) {
                productPath = (Path)productInputFile;
            } else if (productInputFile instanceof InputStream) {
                try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(productInputFile);){
                    DecodeQualification decodeQualification = GeoTiffProductReaderPlugIn.getDecodeQualificationImpl(imageInputStream);
                    return decodeQualification;
                }
            }
            if (productPath == null) return DecodeQualification.UNABLE;
            String fileExtension = FileUtils.getExtension((String)productPath.getFileName().toString());
            if (fileExtension == null) return DecodeQualification.UNABLE;
            boolean extensionMatches = Arrays.stream(TIFF_FILE_EXTENSION).anyMatch(fileExtension::equalsIgnoreCase);
            if (!extensionMatches) {
                if (!fileExtension.equalsIgnoreCase(ZIP_FILE_EXTENSION)) return DecodeQualification.UNABLE;
                return this.checkZipArchive(productPath);
            }
            try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(productInputFile);){
                DecodeQualification decodeQualification = GeoTiffProductReaderPlugIn.getDecodeQualificationImpl(imageInputStream);
                return decodeQualification;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DecodeQualification.UNABLE;
    }

    private DecodeQualification checkZipArchive(Path productPath) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        try (FileSystem fileSystem = ZipFileSystemBuilder.newZipFileSystem((Path)productPath);){
            TreeSet filePaths = FileSystemUtils.listAllFilePaths((FileSystem)fileSystem);
            boolean foundNtif = false;
            Iterator itFileNames = filePaths.iterator();
            while (itFileNames.hasNext() && !foundNtif) {
                String filePath = (String)itFileNames.next();
                if (!filePath.endsWith("ntf")) continue;
                foundNtif = true;
            }
            boolean foundTiff = false;
            int entryCount = 0;
            itFileNames = filePaths.iterator();
            while (itFileNames.hasNext()) {
                ++entryCount;
                String filePath = ((String)itFileNames.next()).toLowerCase();
                boolean extensionMatch = Arrays.stream(TIFF_FILE_EXTENSION).anyMatch(filePath::endsWith);
                if (extensionMatch) {
                    int startIndex = 0;
                    if (filePath.startsWith(fileSystem.getSeparator())) {
                        startIndex = fileSystem.getSeparator().length();
                    }
                    if (filePath.indexOf(fileSystem.getSeparator(), startIndex) < 0) {
                        foundTiff = true;
                    }
                }
                if (foundNtif || !foundTiff || entryCount <= 1) continue;
                DecodeQualification decodeQualification = DecodeQualification.SUITABLE;
                return decodeQualification;
            }
            if (foundTiff && entryCount == 1) {
                DecodeQualification decodeQualification = DecodeQualification.SUITABLE;
                return decodeQualification;
            }
        }
        return DecodeQualification.UNABLE;
    }

    static DecodeQualification getDecodeQualificationImpl(ImageInputStream stream) {
        try {
            String mode = Utils.getTiffMode(stream);
            if ("Tiff".equals(mode) && GeoTiffProductReaderPlugIn.isImageReaderAvailable(stream)) {
                return DecodeQualification.SUITABLE;
            }
        }
        catch (Exception e) {
            return DecodeQualification.UNABLE;
        }
        return DecodeQualification.UNABLE;
    }

    private static boolean isImageReaderAvailable(ImageInputStream stream) throws Exception {
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
        while (imageReaders.hasNext()) {
            ImageReader reader = imageReaders.next();
            if (!(reader instanceof TIFFImageReader)) continue;
            TIFFImageReader tiffImageReader = (TIFFImageReader)reader;
            tiffImageReader.setInput((Object)stream);
            return !Utils.isCOGGeoTIFF(tiffImageReader);
        }
        return false;
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class, InputStream.class};
    }

    public ProductReader createReaderInstance() {
        return new GeoTiffProductReader(this);
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return ALL_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return "GeoTIFF data product.";
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(FORMAT_NAMES[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

