/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.image.AbstractSubsetTileOpImage;
import org.esa.snap.core.image.ImageReadBoundsSupport;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.dataio.geotiff.GeoTiffBandSource;
import org.esa.snap.dataio.geotiff.GeoTiffRasterRegion;

public class GeoTiffTileOpImage
extends AbstractSubsetTileOpImage {
    private final GeoTiffRasterRegion geoTiffRasterRegion;
    private final GeoTiffBandSource geoTiffBandSource;

    public GeoTiffTileOpImage(GeoTiffRasterRegion geoTiffRasterRegion, GeoTiffBandSource geoTiffBandSource, int dataBufferType, int tileWidth, int tileHeight, int tileOffsetFromReadBoundsX, int tileOffsetFromReadBoundsY, ImageReadBoundsSupport levelImageBoundsSupport) {
        super(dataBufferType, tileWidth, tileHeight, tileOffsetFromReadBoundsX, tileOffsetFromReadBoundsY, levelImageBoundsSupport, geoTiffBandSource.getDefaultJAIReadTileSize());
        this.geoTiffRasterRegion = geoTiffRasterRegion;
        this.geoTiffBandSource = geoTiffBandSource;
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster levelDestinationRaster, Rectangle levelDestinationRectangle) {
        Rectangle normalBoundsIntersection = this.computeIntersectionOnNormalBounds(levelDestinationRectangle);
        if (!normalBoundsIntersection.isEmpty()) {
            if (this.getLevel() == 0) {
                Raster normalRasterData = this.readRasterData(normalBoundsIntersection.x, normalBoundsIntersection.y, normalBoundsIntersection.width, normalBoundsIntersection.height);
                this.writeDataOnLevelRaster(normalRasterData, normalBoundsIntersection, levelDestinationRaster, levelDestinationRectangle, this.geoTiffBandSource.getBandIndex());
            } else if (this.geoTiffBandSource.canDivideTileRegionToRead(this.getLevel())) {
                this.readHigherLevelData(normalBoundsIntersection, levelDestinationRaster, levelDestinationRectangle);
            } else {
                Raster normalRasterData = this.readRasterData(normalBoundsIntersection.x, normalBoundsIntersection.y, normalBoundsIntersection.width, normalBoundsIntersection.height);
                this.writeDataOnLevelRaster(normalRasterData, normalBoundsIntersection, levelDestinationRaster, levelDestinationRectangle, this.geoTiffBandSource.getBandIndex());
            }
        }
    }

    private void readHigherLevelData(Rectangle normalBoundsIntersection, WritableRaster levelDestinationRaster, Rectangle levelDestinationRectangle) {
        int multiplyFactor = 2;
        Dimension defaultJAIReadTileSize = this.geoTiffBandSource.getDefaultJAIReadTileSize();
        int defaultTileWidthToRead = GeoTiffTileOpImage.computeTileSizeToRead(this.getTileWidth(), defaultJAIReadTileSize.width * multiplyFactor, normalBoundsIntersection.width);
        int defaultTileHeightToRead = GeoTiffTileOpImage.computeTileSizeToRead(this.getTileHeight(), defaultJAIReadTileSize.height * multiplyFactor, normalBoundsIntersection.height);
        int columnTileCount = ImageUtils.computeTileCount((int)normalBoundsIntersection.width, (int)defaultTileWidthToRead);
        int rowTileCount = ImageUtils.computeTileCount((int)normalBoundsIntersection.height, (int)defaultTileHeightToRead);
        int bandIndex = this.geoTiffBandSource.getBandIndex();
        int levelOffsetY = this.levelTileOffsetFromReadBoundsY + levelDestinationRectangle.y;
        int levelOffsetX = this.levelTileOffsetFromReadBoundsX + levelDestinationRectangle.x;
        int levelColumnReadOffsetX = 0;
        for (int columnIndex = 0; columnIndex < columnTileCount; ++columnIndex) {
            int tileLeftXToRead = columnIndex * defaultTileWidthToRead;
            int tileWidthToRead = columnIndex < columnTileCount - 1 ? defaultTileWidthToRead : normalBoundsIntersection.width - tileLeftXToRead;
            int tileRightXToRead = (tileLeftXToRead += normalBoundsIntersection.x) + tileWidthToRead - 1;
            int levelColumnReadOffsetY = 0;
            for (int rowIndex = 0; rowIndex < rowTileCount; ++rowIndex) {
                int currentSrcXOffset;
                int tileTopYToRead = rowIndex * defaultTileHeightToRead;
                int tileHeightToRead = rowIndex < rowTileCount - 1 ? defaultTileHeightToRead : normalBoundsIntersection.height - tileTopYToRead;
                int tileBottomYToRead = (tileTopYToRead += normalBoundsIntersection.y) + tileHeightToRead - 1;
                Raster normalRasterData = this.readRasterData(tileLeftXToRead, tileTopYToRead, tileWidthToRead, tileHeightToRead);
                int x = levelColumnReadOffsetX;
                int y = levelColumnReadOffsetY;
                while ((currentSrcXOffset = this.imageBoundsSupport.getSourceX() + this.computeSourceX(levelOffsetX + x)) <= tileRightXToRead) {
                    if (currentSrcXOffset >= tileLeftXToRead) {
                        int currentSrcYOffset;
                        y = levelColumnReadOffsetY;
                        while ((currentSrcYOffset = this.imageBoundsSupport.getSourceY() + this.computeSourceY(levelOffsetY + y)) <= tileBottomYToRead) {
                            if (currentSrcYOffset < tileTopYToRead) {
                                throw new IllegalStateException("Invalid values when iterate on the Y axis: levelColumnReadOffsetY=" + levelColumnReadOffsetY + ", y=" + y + ", currentSrcYOffset=" + currentSrcYOffset + ", tileTopYToRead=" + tileTopYToRead + ".");
                            }
                            double value = normalRasterData.getSampleDouble(currentSrcXOffset, currentSrcYOffset, bandIndex);
                            levelDestinationRaster.setSample(levelDestinationRectangle.x + x, levelDestinationRectangle.y + y, bandIndex, value);
                            if (++y < levelDestinationRectangle.height) continue;
                            break;
                        }
                    } else {
                        throw new IllegalStateException("Invalid values when iterate on the X axis: levelColumnReadOffsetX=" + levelColumnReadOffsetX + ", x=" + x + ", currentSrcXOffset=" + currentSrcXOffset + ".");
                    }
                    if (++x < levelDestinationRectangle.width) continue;
                }
                levelColumnReadOffsetY = y;
                if (rowIndex != rowTileCount - 1) continue;
                levelColumnReadOffsetX = x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Raster readRasterData(int destOffsetX, int destOffsetY, int destWidth, int destHeight) {
        try {
            int sourceStepX = 1;
            int sourceStepY = 1;
            int sourceOffsetX = sourceStepX * destOffsetX;
            int sourceOffsetY = sourceStepY * destOffsetY;
            GeoTiffRasterRegion geoTiffRasterRegion = this.geoTiffRasterRegion;
            synchronized (geoTiffRasterRegion) {
                return this.geoTiffRasterRegion.readRect(this.geoTiffBandSource.isGlobalShifted180(), sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destOffsetX, destOffsetY, destWidth, destHeight);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to read the data: level=" + this.getLevel() + ", region=[x=" + destOffsetX + ", y=" + destOffsetY + ", width=" + destWidth + ", height=" + destHeight + "].", ex);
        }
    }

    private static int computeTileSizeToRead(int actualTileSize, int defaultJAIReadTileSize, int normalBoundsSize) {
        int defaultTileSizeToRead = Math.max(actualTileSize, defaultJAIReadTileSize);
        if (defaultTileSizeToRead > normalBoundsSize) {
            defaultTileSizeToRead = normalBoundsSize;
        }
        return defaultTileSizeToRead;
    }
}

