/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import com.sun.media.jai.codec.TIFFField;
import it.geosolutions.imageio.plugins.tiff.TIFFDirectory;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.geotiff.GeoTIFFMetadata;
import org.esa.snap.dataio.geotiff.TiffFileInfo;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Utils {
    public static final int PRIVATE_BEAM_TIFF_TAG_NUMBER = 65000;

    public static boolean isCOGGeoTIFF(Path filePath) throws Exception {
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(filePath.toFile());){
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
            TIFFImageReader tiffReader = null;
            while (imageReaders.hasNext()) {
                ImageReader reader = imageReaders.next();
                if (!(reader instanceof TIFFImageReader)) continue;
                tiffReader = (TIFFImageReader)reader;
                tiffReader.setInput((Object)imageInputStream);
                break;
            }
            if (tiffReader == null) {
                throw new Exception("No tiff reader found!");
            }
            boolean bl = Utils.isCOGGeoTIFF(tiffReader);
            return bl;
        }
    }

    public static boolean isCOGGeoTIFF(TIFFImageReader tiffReader) throws IOException {
        int numImages = tiffReader.getNumImages(true);
        int numReducedImages = 0;
        if (numImages > 1) {
            for (int i = 1; i < numImages; ++i) {
                TIFFImageMetadata metadata = (TIFFImageMetadata)tiffReader.getImageMetadata(i);
                TiffFileInfo tiffInfo = new TiffFileInfo((TIFFDirectory)metadata.getRootIFD());
                it.geosolutions.imageio.plugins.tiff.TIFFField subFileType = tiffInfo.getField(255);
                it.geosolutions.imageio.plugins.tiff.TIFFField newSubFileType = tiffInfo.getField(254);
                if (newSubFileType == null && subFileType == null) break;
                if (newSubFileType != null && 1 == newSubFileType.getAsInt(0)) {
                    ++numReducedImages;
                }
                if (newSubFileType == null && 2 == subFileType.getAsInt(0)) {
                    ++numReducedImages;
                }
                it.geosolutions.imageio.plugins.tiff.TIFFField imageWidth = tiffInfo.getField(256);
                TIFFImageMetadata prevMetadata = (TIFFImageMetadata)tiffReader.getImageMetadata(i - 1);
                TiffFileInfo prevTiffInfo = new TiffFileInfo((TIFFDirectory)prevMetadata.getRootIFD());
                it.geosolutions.imageio.plugins.tiff.TIFFField prevImageWidth = prevTiffInfo.getField(256);
                if (prevImageWidth.getAsInt(0) < (imageWidth.getAsInt(0) - 1) * 2) break;
            }
        }
        return numImages > 1 && numReducedImages == numImages - 1;
    }

    static List<TIFFField> createGeoTIFFFields(GeoTIFFMetadata geoTIFFMetadata) {
        double[] modelTransformation;
        int numModelTiePoints;
        double[] modelPixelScale;
        String geoAsciiString;
        double[] geoDoubleParams;
        ArrayList<TIFFField> list = new ArrayList<TIFFField>(6);
        int numGeoKeyEntries = geoTIFFMetadata.getNumGeoKeyEntries();
        if (numGeoKeyEntries > 0) {
            GeoTIFFMetadata.KeyEntry[] keyEntries = geoTIFFMetadata.getGeoKeyEntries();
            char[] values = new char[keyEntries.length * 4];
            for (int i = 0; i < keyEntries.length; ++i) {
                int[] data = keyEntries[i].getData();
                for (int j = 0; j < data.length; ++j) {
                    values[i * 4 + j] = (char)data[j];
                }
            }
            TIFFField geoKeyDirectory = new TIFFField(34735, 3, values.length, (Object)values);
            list.add(geoKeyDirectory);
        }
        if ((geoDoubleParams = geoTIFFMetadata.getGeoDoubleParams()) != null && geoDoubleParams.length > 0) {
            list.add(new TIFFField(34736, 12, geoDoubleParams.length, (Object)geoDoubleParams));
        }
        if ((geoAsciiString = geoTIFFMetadata.getGeoAsciiParams()) != null && geoAsciiString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(geoAsciiString, "|");
            String[] geoAsciiStrings = new String[tokenizer.countTokens()];
            for (int i = 0; i < geoAsciiStrings.length; ++i) {
                geoAsciiStrings[i] = tokenizer.nextToken().concat("|");
            }
            list.add(new TIFFField(34737, 2, geoAsciiStrings.length, (Object)geoAsciiStrings));
        }
        if (Utils.isValidModelPixelScale(modelPixelScale = geoTIFFMetadata.getModelPixelScale())) {
            list.add(new TIFFField(33550, 12, modelPixelScale.length, (Object)modelPixelScale));
        }
        if ((numModelTiePoints = geoTIFFMetadata.getNumModelTiePoints()) > 0) {
            double[] tiePointValues = new double[numModelTiePoints * 6];
            for (int i = 0; i < numModelTiePoints; ++i) {
                GeoTIFFMetadata.TiePoint tiePoint = geoTIFFMetadata.getModelTiePointAt(i);
                double[] data = tiePoint.getData();
                System.arraycopy(data, 0, tiePointValues, i * data.length, data.length);
            }
            list.add(new TIFFField(33922, 12, tiePointValues.length, (Object)tiePointValues));
        }
        if (Utils.isValidModelTransformation(modelTransformation = geoTIFFMetadata.getModelTransformation())) {
            list.add(new TIFFField(34264, 12, modelTransformation.length, (Object)modelTransformation));
        }
        return list;
    }

    static boolean isValidModelTransformation(double[] modelTransformation) {
        double[] defaultValues = new double[16];
        return Utils.isValidData(modelTransformation, defaultValues);
    }

    static boolean isValidModelPixelScale(double[] modelTransformation) {
        double[] defaultValues = new double[]{1.0, 1.0, 0.0};
        return Utils.isValidData(modelTransformation, defaultValues);
    }

    private static boolean isValidData(double[] modelTransformation, double[] defaultValues) {
        if (modelTransformation != null && modelTransformation.length == defaultValues.length) {
            for (int i = 0; i < modelTransformation.length; ++i) {
                double v = modelTransformation[i];
                double dv = defaultValues[i];
                if (v == dv) continue;
                return true;
            }
        }
        return false;
    }

    static String[] findSuitableLatLonNames(Product product) {
        String latName;
        String[] latNames = new String[]{"latitude", "latitude_tpg", "lat", "lat_tpg"};
        String[] lonNames = new String[]{"longitude", "longitude_tpg", "lon", "lon_tpg"};
        String[] names = new String[2];
        for (int i = 0; i < latNames.length; ++i) {
            latName = latNames[i];
            String lonName = lonNames[i];
            if (product.containsRasterDataNode(latName) || product.containsRasterDataNode(lonName)) continue;
            names[0] = latName;
            names[1] = lonName;
            return names;
        }
        String lonName = lonNames[0] + "_";
        latName = latNames[0] + "_";
        int index = 1;
        while (product.containsRasterDataNode(latName + index) || product.containsRasterDataNode(lonName + index)) {
            ++index;
        }
        return new String[]{latName + index, lonName + index};
    }

    public static boolean shouldWriteNode(ProductNode node) {
        if (node instanceof VirtualBand) {
            return false;
        }
        return !(node instanceof FilterBand);
    }

    public static Band[] setupBandsFromGdalMetadata(String gdalMetadataXmlString, int productDataType, int width, int height) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(gdalMetadataXmlString));
        Document doc = db.parse(is);
        NodeList nodes = doc.getElementsByTagName("GDALMetadata");
        Element element = (Element)nodes.item(0);
        ArrayList<String> bandnameList = new ArrayList<String>();
        ArrayList<String> descrList = new ArrayList<String>();
        ArrayList<String> unitsList = new ArrayList<String>();
        ArrayList<String> nodataList = new ArrayList<String>();
        ArrayList<String> offsetList = new ArrayList<String>();
        ArrayList<String> scaleList = new ArrayList<String>();
        for (int i = 0; i < element.getElementsByTagName("Item").getLength(); ++i) {
            Node node = element.getElementsByTagName("Item").item(i);
            Node child = node.getFirstChild();
            CharacterData cd = (CharacterData)child;
            if (!node.hasAttributes() || cd == null) continue;
            block17: for (int j = 0; j < node.getAttributes().getLength(); ++j) {
                Node attr = node.getAttributes().item(j);
                if (!attr.getNodeName().equals("name")) continue;
                switch (attr.getNodeValue()) {
                    case "BAND": {
                        bandnameList.add(cd.getData());
                        continue block17;
                    }
                    case "DESCRIPTION": {
                        descrList.add(cd.getData());
                        continue block17;
                    }
                    case "UNITS": {
                        unitsList.add(cd.getData());
                        continue block17;
                    }
                    case "NODATA": {
                        nodataList.add(cd.getData());
                        continue block17;
                    }
                    case "OFFSET": {
                        offsetList.add(cd.getData());
                        continue block17;
                    }
                    case "SCALE": {
                        scaleList.add(cd.getData());
                    }
                }
            }
        }
        Iterator descrListIterator = descrList.iterator();
        Iterator unitsListIterator = unitsList.iterator();
        Iterator nodataListIterator = nodataList.iterator();
        Iterator offsetListIterator = offsetList.iterator();
        Iterator scaleListIterator = scaleList.iterator();
        Band[] bands = new Band[bandnameList.size()];
        for (int i = 0; i < bandnameList.size(); ++i) {
            String scaleValString;
            String offsetValString;
            String nodataValString;
            bands[i] = new Band((String)bandnameList.get(i), productDataType, width, height);
            if (descrListIterator.hasNext()) {
                bands[i].setDescription((String)descrListIterator.next());
            }
            if (unitsListIterator.hasNext()) {
                bands[i].setUnit((String)unitsListIterator.next());
            }
            if (nodataListIterator.hasNext() && (nodataValString = (String)nodataListIterator.next()) != null) {
                double nodataVal = Double.parseDouble(nodataValString);
                bands[i].setNoDataValue(nodataVal);
                bands[i].setNoDataValueUsed(true);
            }
            if (offsetListIterator.hasNext() && (offsetValString = (String)offsetListIterator.next()) != null) {
                double offsetVal = Double.parseDouble(offsetValString);
                bands[i].setScalingOffset(offsetVal);
            }
            if (!scaleListIterator.hasNext() || (scaleValString = (String)scaleListIterator.next()) == null) continue;
            double scaleVal = Double.parseDouble(scaleValString);
            bands[i].setScalingFactor(scaleVal);
        }
        return bands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTiffMode(ImageInputStream stream) throws IOException {
        try {
            stream.mark();
            int byteOrder = stream.readUnsignedShort();
            switch (byteOrder) {
                case 19789: {
                    stream.setByteOrder(ByteOrder.BIG_ENDIAN);
                    break;
                }
                case 18761: {
                    stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                    break;
                }
                default: {
                    stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                }
            }
            int magic = stream.readUnsignedShort();
            switch (magic) {
                case 43: {
                    String string = "BigTiff";
                    return string;
                }
                case 42: {
                    String string = "Tiff";
                    return string;
                }
            }
            String string = "Unknown";
            return string;
        }
        finally {
            stream.reset();
        }
    }
}

