/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import java.util.SortedMap;
import java.util.TreeMap;
import org.esa.snap.dataio.geotiff.internal.TiffDirectoryEntry;
import org.esa.snap.dataio.geotiff.internal.TiffShort;

class TiffDirectoryEntrySet {
    private final SortedMap entryMap = new TreeMap();

    public void set(TiffDirectoryEntry entry) {
        Integer key = TiffDirectoryEntrySet.getKey(entry);
        this.entryMap.put(key, entry);
    }

    public TiffDirectoryEntry[] getEntries() {
        return this.entryMap.values().toArray(new TiffDirectoryEntry[this.entryMap.size()]);
    }

    public TiffDirectoryEntry getEntry(TiffShort tag) {
        Integer key = TiffDirectoryEntrySet.getKey(tag);
        return (TiffDirectoryEntry)this.entryMap.get(key);
    }

    private static Integer getKey(TiffDirectoryEntry entry) {
        return TiffDirectoryEntrySet.getKey(entry.getTag());
    }

    private static Integer getKey(TiffShort tag) {
        return tag.getValue();
    }
}

