/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime;

import com.bc.ceres.core.Assert;

public class ProxyConfig {
    public static final ProxyConfig NULL = new ProxyConfig();
    private String host = "";
    private int port;
    private boolean authorizationUsed;
    private String username = "";
    private char[] password = new char[0];

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        Assert.notNull(host, "host");
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isAuthorizationUsed() {
        return this.authorizationUsed;
    }

    public void setAuthorizationUsed(boolean authorizationUsed) {
        this.authorizationUsed = authorizationUsed;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        Assert.notNull(username, "username");
        this.username = username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        Assert.notNull(password, "password");
        this.password = password;
    }

    public String getScrambledPassword() {
        if (this.password.length > 0) {
            return ProxyConfig.scramble(new String(this.password));
        }
        return "";
    }

    public void setScrambledPassword(String password) {
        if (password != null && password.length() > 0) {
            this.setPassword(ProxyConfig.descramble(password).toCharArray());
        } else {
            this.setPassword(new char[0]);
        }
    }

    static String scramble(String epw) {
        String s = ProxyConfig.extra();
        String p = s + epw;
        return ProxyConfig.swap(p);
    }

    static String descramble(String cpw) {
        String p = ProxyConfig.swap(cpw);
        String s = ProxyConfig.extra();
        return p.substring(s.length());
    }

    private static String swap(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length / 2; i += 2) {
            char tmp = chars[chars.length - i - 1];
            chars[chars.length - i - 1] = chars[i];
            chars[i] = tmp;
        }
        return new String(chars);
    }

    private static String extra() {
        int[] off = new int[]{17, 19, 11, 5, 4, 23, 3, 31, 1, 37, 13, 50, 38};
        char[] chars = new char[off.length];
        for (int i = 0; i < off.length; ++i) {
            chars[i] = (char)(32 + off[i]);
        }
        return new String(chars);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProxyConfig) {
            ProxyConfig proxyConfig = (ProxyConfig)obj;
            return this.host.equals(proxyConfig.host) && this.port == proxyConfig.port && this.authorizationUsed == proxyConfig.authorizationUsed;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.host.hashCode() + this.port;
    }
}

