/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.ConfigurationSchemaElement;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.internal.ConfigurationSchemaElementImpl;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.ModuleRegistry;

public class ExtensionPointImpl
implements ExtensionPoint {
    public static final ExtensionPointImpl[] EMPTY_ARRAY = new ExtensionPointImpl[0];
    private final String id;
    private final ConfigurationSchemaElementImpl configurationSchemaElement;
    private transient String qualifiedId;
    private transient ModuleImpl declaringModule;

    public ExtensionPointImpl(String id, ConfigurationSchemaElementImpl configurationSchemaElement) {
        Assert.notNull(id, "id");
        Assert.notNull(configurationSchemaElement, "configurationSchemaElement");
        this.id = id;
        this.configurationSchemaElement = configurationSchemaElement;
        this.configurationSchemaElement.setDeclaringExtensionPoint(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getQualifiedId() {
        return this.qualifiedId;
    }

    @Override
    public Module getDeclaringModule() {
        return this.declaringModule;
    }

    void setDeclaringModule(ModuleImpl declaringModule) {
        this.declaringModule = declaringModule;
        this.qualifiedId = declaringModule.getSymbolicName() + ':' + this.id;
    }

    public Extension getExtension(String extensionId) {
        Extension[] extensions;
        for (Extension extension : extensions = this.getExtensions()) {
            if (!extensionId.equals(extension.getId())) continue;
            return extension;
        }
        return null;
    }

    @Override
    public Extension[] getExtensions() {
        ModuleRegistry registry = this.declaringModule.getRegistry();
        return registry != null ? registry.getExtensions(this.qualifiedId) : null;
    }

    @Override
    public ConfigurationElement[] getConfigurationElements() {
        Extension[] extensions = this.getExtensions();
        if (extensions == null) {
            return null;
        }
        ConfigurationElement[] configurationElements = new ConfigurationElement[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            configurationElements[i] = extensions[i].getConfigurationElement();
        }
        return configurationElements;
    }

    @Override
    public ConfigurationSchemaElement getConfigurationSchemaElement() {
        return this.configurationSchemaElement;
    }
}

