/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;

class InstallInfo {
    private Date date = new Date();
    private String version = "1.0";
    private String[] items;

    public InstallInfo(String[] items) {
        this.items = items;
    }

    public Date getDate() {
        return this.date;
    }

    public String[] getItems() {
        return this.items;
    }

    public static InstallInfo read(Reader reader) throws IOException {
        try {
            InstallInfo installInfo = (InstallInfo)InstallInfo.createXStream().fromXML(reader);
            if (installInfo.date == null) {
                installInfo.date = new Date();
            }
            if (installInfo.version == null) {
                installInfo.version = "1.0";
            }
            if (installInfo.items == null) {
                installInfo.items = new String[0];
            }
            return installInfo;
        }
        catch (XStreamException e) {
            IOException ioe = new IOException("Failed to read install info.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void write(Writer writer) throws IOException {
        try {
            this.date = new Date();
            InstallInfo.createXStream().toXML((Object)this, writer);
        }
        catch (XStreamException e) {
            IOException ioe = new IOException("Failed to write install info.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static XStream createXStream() {
        XStream xStream = new XStream();
        xStream.alias("install-info", InstallInfo.class);
        return xStream;
    }
}

