/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ProxyConfig;
import com.bc.ceres.core.runtime.internal.DirScanner;
import com.bc.ceres.core.runtime.internal.JarFilenameFilter;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.ModuleManifestParser;
import com.bc.ceres.core.runtime.internal.Platform;
import com.bc.ceres.core.runtime.internal.UrlHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModuleReader {
    private Logger logger;
    public static final String[] NO_LIBS = new String[0];

    public ModuleReader(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleImpl readFromLocation(File locationFile) throws CoreException {
        ModuleImpl module;
        if (locationFile.isDirectory()) {
            module = this.readFromManifest(new File(locationFile, "module.xml"));
        } else {
            try (ZipFile zipFile = new ZipFile(locationFile);){
                ZipEntry entry = zipFile.getEntry("module.xml");
                if (entry == null) {
                    throw new CoreException(String.format("Manifest [%s] not found in [%s]", "module.xml", locationFile.getName()));
                }
                InputStream inputStream = zipFile.getInputStream(entry);
                module = this.readFromManifest(inputStream);
            }
            catch (IOException e) {
                throw new CoreException(String.format("Failed to read manifest [%s] from [%s]", "module.xml", locationFile.getName()), e);
            }
        }
        this.initModule(module, UrlHelper.fileToUrl(locationFile), locationFile);
        return module;
    }

    public ModuleImpl readFromLocation(URL locationUrl) throws CoreException {
        URL manifestUrl = UrlHelper.locationToManifestUrl(locationUrl);
        if (manifestUrl == null) {
            throw new CoreException("Not a module URL: [" + locationUrl + "]");
        }
        ModuleImpl module = this.readFromManifest(manifestUrl, ProxyConfig.NULL);
        this.initModule(module, locationUrl, UrlHelper.urlToFile(locationUrl));
        return module;
    }

    public ModuleImpl readFromManifest(InputStream inputStream) throws CoreException {
        return new ModuleManifestParser().parse(inputStream);
    }

    public ModuleImpl readFromManifest(File manifestFile) throws CoreException {
        try {
            FileReader reader = new FileReader(manifestFile);
            return new ModuleManifestParser().parse(reader);
        }
        catch (FileNotFoundException e) {
            throw new CoreException("Module manifest [" + manifestFile + "] not found", e);
        }
    }

    public ModuleImpl readFromManifest(URL manifestUrl, ProxyConfig proxyConfig) throws CoreException {
        try {
            URLConnection urlConnection = UrlHelper.openConnection(manifestUrl, proxyConfig, "GET");
            InputStream stream = urlConnection.getInputStream();
            return new ModuleManifestParser().parse(stream);
        }
        catch (IOException e) {
            throw new CoreException("Failed to read module manifest from [" + manifestUrl + "]", e);
        }
    }

    private void initModule(ModuleImpl module, URL locationUrl, File locationFile) {
        module.setLocation(locationUrl);
        module.setImpliciteLibs(NO_LIBS);
        module.setImpliciteNativeLibs(NO_LIBS);
        if (locationFile != null) {
            module.setContentLength(locationFile.length());
            module.setLastModified(locationFile.lastModified());
            if (locationFile.isDirectory()) {
                File implicitLibDir = new File(locationFile, "lib");
                if (implicitLibDir.exists() && implicitLibDir.isDirectory()) {
                    String[] libs = ModuleReader.scanImpliciteLibs(implicitLibDir);
                    for (int i = 0; i < libs.length; ++i) {
                        libs[i] = "lib/" + libs[i];
                    }
                    module.setImpliciteLibs(libs);
                }
                if (module.isNative()) {
                    String[] nativeLibs = ModuleReader.scanImpliciteNativeLibs(locationFile);
                    module.setImpliciteNativeLibs(nativeLibs);
                }
            }
        }
        this.logger.info(MessageFormat.format("Module [{0}] read from [{1}].", module.getSymbolicName(), module.getLocation()));
    }

    private static String[] scanImpliciteLibs(File dir) {
        return new DirScanner(dir, true, true).scan(new JarFilenameFilter());
    }

    private static String[] scanImpliciteNativeLibs(File dir) {
        String[] result;
        String platformPath;
        File platformDir;
        String osNameLC = System.getProperty("os.name", "").toLowerCase();
        FilenameFilter ff = osNameLC.contains("windows") ? new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".dll");
            }
        } : (osNameLC.contains("mac os x") ? new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jnilib") || name.endsWith(".dylib");
            }
        } : new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".so");
            }
        });
        Platform currentPlatform = Platform.getCurrentPlatform();
        if (currentPlatform != null && (platformDir = new File(dir, platformPath = Platform.getSourcePathPrefix(currentPlatform.getId(), currentPlatform.getBitCount()))).exists() && platformDir.isDirectory() && (result = new DirScanner(platformDir, true, true).scan(ff)).length > 0) {
            String[] fullResult = new String[result.length];
            for (int i = 0; i < fullResult.length; ++i) {
                fullResult[i] = platformPath + "/" + result[i];
            }
            return fullResult;
        }
        return new DirScanner(dir, true, true).scan(ff);
    }
}

