/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleRegistry {
    private Map<Long, ModuleImpl> idToModuleMap = new HashMap<Long, ModuleImpl>(33);
    private Map<URL, ModuleImpl> locationToModuleMap = new HashMap<URL, ModuleImpl>(33);
    private Map<String, Object> symbolicNameToModulesMap = new HashMap<String, Object>(33);
    private Map<String, ExtensionPoint> extensionPointMap = new HashMap<String, ExtensionPoint>(33);

    public void registerModule(ModuleImpl module) throws CoreException {
        ExtensionPoint oldExtensionPoint;
        Assert.notNull(module, "module");
        Assert.notNull(module.getSymbolicName(), "module.getId()");
        Assert.notNull(module.getLocation(), "module.getLocation()");
        if (this.idToModuleMap.containsKey(module.getModuleId())) {
            throw new CoreException(MessageFormat.format("Duplicate module identifier [{0}]", module.getModuleId()));
        }
        if (this.symbolicNameToModulesMap.containsKey(module.getSymbolicName())) {
            ModuleImpl[] modules = this.getModules(module.getSymbolicName());
            for (ModuleImpl moduleImpl : modules) {
                if (!moduleImpl.getVersion().equals(module.getVersion())) continue;
                throw new CoreException(MessageFormat.format("Module with symbolic name [{0}] and version [{1}] already registered", module.getSymbolicName(), module.getVersion()));
            }
        }
        if (this.locationToModuleMap.containsKey(module.getLocation())) {
            throw new CoreException(MessageFormat.format("Duplicate module location [{0}]", module.getLocation()));
        }
        ExtensionPoint[] extensionPoints = module.getExtensionPoints();
        for (ExtensionPoint extensionPoint : extensionPoints) {
            oldExtensionPoint = this.extensionPointMap.get(extensionPoint.getQualifiedId());
            if (oldExtensionPoint == null || oldExtensionPoint.getDeclaringModule() != module) continue;
            throw new CoreException(String.format("Module [%s]: Duplicate extension point identifier [%s]", module.getSymbolicName(), extensionPoint.getId()));
        }
        this.registerModuleId(module);
        this.registerLocation(module);
        this.registerSymbolicName(module);
        module.setRegistry(this);
        for (ExtensionPoint extensionPoint : extensionPoints) {
            oldExtensionPoint = this.extensionPointMap.get(extensionPoint.getQualifiedId());
            if (oldExtensionPoint != null) continue;
            this.extensionPointMap.put(extensionPoint.getQualifiedId(), extensionPoint);
        }
    }

    public ModuleImpl getModule(long moduleId) {
        Assert.argument(moduleId >= 0L, "moduleId >= 0");
        return this.idToModuleMap.get(moduleId);
    }

    public ModuleImpl getModule(URL url) {
        Assert.notNull(url, "url");
        return this.locationToModuleMap.get(url);
    }

    public ModuleImpl[] getModules(String symbolicName) {
        Assert.notNull(symbolicName, "symbolicName");
        Object o = this.symbolicNameToModulesMap.get(symbolicName);
        if (o == null) {
            return new ModuleImpl[0];
        }
        if (o instanceof ModuleImpl) {
            ModuleImpl module = (ModuleImpl)o;
            return new ModuleImpl[]{module};
        }
        if (o instanceof List) {
            List modules = (List)o;
            return modules.toArray(ModuleImpl.EMPTY_ARRAY);
        }
        throw new IllegalStateException();
    }

    public ModuleImpl[] getModules() {
        Collection<ModuleImpl> modules = this.idToModuleMap.values();
        return modules.toArray(ModuleImpl.EMPTY_ARRAY);
    }

    public ExtensionPoint getExtensionPoint(String extensionPointId) {
        if (extensionPointId == null) {
            throw new NullPointerException("extensionPointId");
        }
        return this.extensionPointMap.get(extensionPointId);
    }

    public ExtensionPoint getExtensionPoint(String extensionPointId, ModuleImpl declaringModule) {
        ExtensionPoint point = this.getExtensionPoint(extensionPointId);
        if (point == null) {
            String extensionPointIdSimple = extensionPointId;
            int index = extensionPointId.indexOf(58);
            if (index > 0) {
                extensionPointIdSimple = extensionPointId.substring(index + 1);
            }
            point = ModuleRegistry.findExtensionPoint(declaringModule, extensionPointIdSimple);
        }
        return point;
    }

    public ExtensionPoint[] getExtensionPoints() {
        Collection<ExtensionPoint> extensionPoints = this.extensionPointMap.values();
        return extensionPoints.toArray(new ExtensionPoint[0]);
    }

    public Extension[] getExtensions(String extensionPointId) {
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointId);
        ArrayList<Extension> list = new ArrayList<Extension>(16);
        if (extensionPoint != null) {
            ModuleImpl[] modules;
            Module declaringModule = extensionPoint.getDeclaringModule();
            this.collectExtensions(declaringModule, extensionPoint, list);
            for (ModuleImpl module : modules = this.getModules()) {
                if (module == declaringModule) continue;
                this.collectExtensions(module, extensionPoint, list);
            }
        }
        return list.toArray(new Extension[0]);
    }

    private void collectExtensions(Module module, ExtensionPoint extensionPoint, ArrayList<Extension> extensionList) {
        Extension[] extensions;
        for (Extension extension : extensions = module.getExtensions()) {
            if (extension.getExtensionPoint() != extensionPoint) continue;
            extensionList.add(extension);
        }
    }

    private void registerModuleId(ModuleImpl module) {
        this.idToModuleMap.put(module.getModuleId(), module);
    }

    private void registerLocation(ModuleImpl module) {
        this.locationToModuleMap.put(module.getLocation(), module);
    }

    private void registerSymbolicName(ModuleImpl module) {
        Object o = this.symbolicNameToModulesMap.get(module.getSymbolicName());
        if (o == null) {
            this.symbolicNameToModulesMap.put(module.getSymbolicName(), module);
        } else if (o instanceof ModuleImpl) {
            ArrayList<ModuleImpl> arrayList = new ArrayList<ModuleImpl>(3);
            arrayList.add((ModuleImpl)o);
            arrayList.add(module);
            this.symbolicNameToModulesMap.put(module.getSymbolicName(), arrayList);
        } else if (o instanceof List) {
            ((List)o).add(module);
        } else {
            throw new IllegalStateException();
        }
    }

    private static ExtensionPoint findExtensionPoint(ModuleImpl module, String extensionPointIdSimple) {
        ExtensionPoint point1;
        ModuleImpl[] dependencies = module.getModuleDependencies();
        if (dependencies == null) {
            return null;
        }
        for (ModuleImpl dependency : dependencies) {
            point1 = dependency.getExtensionPoint(extensionPointIdSimple);
            if (point1 == null) continue;
            return point1;
        }
        for (ModuleImpl dependency : dependencies) {
            point1 = ModuleRegistry.findExtensionPoint(dependency, extensionPointIdSimple);
            if (point1 == null) continue;
            return point1;
        }
        return null;
    }
}

