/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import java.util.HashSet;

public class Platform {
    private static final String LIB_DIR = "lib";
    private static final String[] VM_PLATFORM_ARCH_KEYS = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"};
    private static final HashSet<String> PLATFORM_DIRS = new HashSet();
    private final ID id;
    private final int bitCount;
    private final String sourcePathPrefix;

    public Platform(ID id, int bitCount) {
        this.id = id;
        this.bitCount = bitCount;
        this.sourcePathPrefix = Platform.getSourcePathPrefix(id, bitCount);
    }

    public ID getId() {
        return this.id;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public boolean isPlatformDir(String entryName) {
        return entryName.startsWith(this.sourcePathPrefix);
    }

    public String truncatePlatformDir(String entryName) {
        if (this.isPlatformDir(entryName)) {
            return "lib/" + entryName.substring(this.sourcePathPrefix.length());
        }
        return entryName;
    }

    public static boolean isAnyPlatformDir(String entryName) {
        for (String platformDir : PLATFORM_DIRS) {
            if (!entryName.startsWith(platformDir)) continue;
            return true;
        }
        return false;
    }

    public static Platform getCurrentPlatform() {
        ID platformId = Platform.getCurrentPlatformId();
        if (platformId != null) {
            return new Platform(platformId, Platform.getCurrentPlatformBitCount());
        }
        return null;
    }

    static ID getCurrentPlatformId() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            return Platform.getPlatformId(osName);
        }
        return null;
    }

    static int getCurrentPlatformBitCount() {
        for (String key : VM_PLATFORM_ARCH_KEYS) {
            String property = System.getProperty(key);
            if (property == null || property.indexOf("64") <= 0) continue;
            return 64;
        }
        return 32;
    }

    static ID getPlatformId(String osName) {
        String osNameLC = osName.toLowerCase();
        for (ID platformId : ID.values()) {
            if (!osNameLC.startsWith(platformId.osNamePattern)) continue;
            return platformId;
        }
        return null;
    }

    static String getSourcePathPrefix(ID id, int numBits) {
        return String.format("%s/%s%d/", new Object[]{LIB_DIR, id, numBits});
    }

    static {
        for (ID platformId : ID.values()) {
            PLATFORM_DIRS.add(Platform.getSourcePathPrefix(platformId, 32));
            PLATFORM_DIRS.add(Platform.getSourcePathPrefix(platformId, 64));
        }
    }

    public static enum ID {
        aix("aix"),
        hpux("hp ux"),
        linux("linux"),
        macosx("mac os x"),
        solaris("solaris"),
        win("win");

        private final String osNamePattern;

        private ID(String osNamePattern) {
            this.osNamePattern = osNamePattern;
        }
    }
}

