/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel;

import org.esa.snap.core.datamodel.Band;

public final class Unit {
    public static final String AMPLITUDE = "amplitude";
    public static final String INTENSITY = "intensity";
    public static final String PHASE = "phase";
    public static final String ABS_PHASE = "abs_phase";
    public static final String COHERENCE = "coherence";
    public static final String REAL = "real";
    public static final String IMAGINARY = "imaginary";
    public static final String DB = "db";
    public static final String AMPLITUDE_DB = "amplitude_db";
    public static final String INTENSITY_DB = "intensity_db";
    public static final String METERS = "meters";
    public static final String CENTIMETERS = "centimeters";
    public static final String MICROMETERS = "micrometers";
    public static final String NANOMETERS = "nanometers";
    public static final String METERS_PER_DAY = "m/day";
    public static final String CLASS = "class";
    public static final String INDEX = "index";
    public static final String SOIL_MOISTURE = "m^3water/m^3soil";
    public static final String DEGREES = "deg";
    public static final String RADIANS = "radians";
    public static final String NANOSECONDS = "ns";
    public static final String BIT = "bit";

    public static UnitType getUnitType(Band sourceBand) {
        if (sourceBand.getUnit() == null) {
            return UnitType.UNKNOWN;
        }
        String unit = sourceBand.getUnit().toLowerCase();
        if (unit.contains(AMPLITUDE)) {
            if (unit.contains(DB)) {
                return UnitType.AMPLITUDE_DB;
            }
            return UnitType.AMPLITUDE;
        }
        if (unit.contains(INTENSITY)) {
            if (unit.contains(DB)) {
                return UnitType.INTENSITY_DB;
            }
            return UnitType.INTENSITY;
        }
        if (unit.contains(PHASE)) {
            return UnitType.PHASE;
        }
        if (unit.contains(ABS_PHASE)) {
            return UnitType.ABS_PHASE;
        }
        if (unit.contains(REAL)) {
            return UnitType.REAL;
        }
        if (unit.contains(IMAGINARY)) {
            return UnitType.IMAGINARY;
        }
        if (unit.contains(METERS)) {
            return UnitType.METERS;
        }
        if (unit.contains(CENTIMETERS)) {
            return UnitType.CENTIMETERS;
        }
        if (unit.contains(METERS_PER_DAY)) {
            return UnitType.METERS_PER_DAY;
        }
        if (unit.contains(COHERENCE)) {
            return UnitType.COHERENCE;
        }
        if (unit.contains(CLASS)) {
            return UnitType.CLASS;
        }
        if (unit.contains(INDEX)) {
            return UnitType.INDEX;
        }
        if (unit.contains(SOIL_MOISTURE)) {
            return UnitType.SOIL_MOISTURE;
        }
        if (unit.contains(DEGREES)) {
            return UnitType.DEGREES;
        }
        if (unit.contains(RADIANS)) {
            return UnitType.RADIANS;
        }
        if (unit.contains(NANOSECONDS)) {
            return UnitType.NANOSECONDS;
        }
        if (unit.contains(BIT)) {
            return UnitType.BIT;
        }
        return UnitType.UNKNOWN;
    }

    public static enum UnitType {
        AMPLITUDE,
        INTENSITY,
        REAL,
        IMAGINARY,
        PHASE,
        ABS_PHASE,
        COHERENCE,
        AMPLITUDE_DB,
        INTENSITY_DB,
        METERS,
        CENTIMETERS,
        METERS_PER_DAY,
        CLASS,
        INDEX,
        SOIL_MOISTURE,
        DEGREES,
        RADIANS,
        NANOSECONDS,
        BIT,
        UNKNOWN;

    }
}

