/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel.metadata;

import java.io.IOException;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataBase;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataInterface;

public class AbstractMetadataOptical
extends AbstractMetadataBase
implements AbstractMetadataInterface {
    private static final String METADATA_VERSION = "6.0";
    private static final String abstracted_metadata_version = "optical_metadata_version";
    private static final String OPTICAL_METADATA_ROOT = "Optical_Metadata";

    public static AbstractMetadataOptical getOpticalAbstractedMetadata(Product sourceProduct) throws IOException {
        AbstractMetadata abstractMetadata = AbstractMetadata.getAbstractedMetadata(sourceProduct);
        if (abstractMetadata == null) {
            throw new IOException("no metadata found in product");
        }
        MetadataElement absRoot = abstractMetadata.getAbsRoot();
        return new AbstractMetadataOptical(absRoot, absRoot.getElement(OPTICAL_METADATA_ROOT));
    }

    private AbstractMetadataOptical(MetadataElement root, MetadataElement abstractedMetadata) {
        super(root, abstractedMetadata);
    }

    @Override
    protected boolean isCurrentVersion() {
        String version = this.absRoot.getAttributeString(abstracted_metadata_version, "");
        return version.equals(METADATA_VERSION);
    }

    @Override
    protected void migrateToCurrentVersion(MetadataElement abstractedMetadata) {
        if (this.isCurrentVersion()) {
            return;
        }
    }

    @Override
    protected MetadataElement addAbstractedMetadataHeader(MetadataElement root) {
        MetadataElement absRoot;
        if (root == null) {
            absRoot = new MetadataElement(OPTICAL_METADATA_ROOT);
        } else {
            absRoot = root.getElement(OPTICAL_METADATA_ROOT);
            if (absRoot == null) {
                absRoot = new MetadataElement(OPTICAL_METADATA_ROOT);
                root.addElementAt(absRoot, 0);
            }
        }
        MetadataAttribute att = AbstractMetadataOptical.addAbstractedAttribute(absRoot, abstracted_metadata_version, 41, "", "AbsMetadata version");
        att.getData().setElems((Object)METADATA_VERSION);
        return absRoot;
    }
}

