/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel.metadata;

import java.io.IOException;
import java.text.DateFormat;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataBase;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataInterface;

public final class AbstractMetadataSAR
extends AbstractMetadataBase
implements AbstractMetadataInterface {
    private static final String METADATA_VERSION = "6.0";
    private static final String abstracted_metadata_version = "sar_metadata_version";
    private static final String SAR_METADATA_ROOT = "SAR_Metadata";
    public static final String antenna_pointing = "antenna_pointing";
    public static final String incidence_near = "incidence_near";
    public static final String incidence_far = "incidence_far";
    public static final String mds1_tx_rx_polar = "mds1_tx_rx_polar";
    public static final String mds2_tx_rx_polar = "mds2_tx_rx_polar";
    public static final String mds3_tx_rx_polar = "mds3_tx_rx_polar";
    public static final String mds4_tx_rx_polar = "mds4_tx_rx_polar";
    public static final String polarization = "polarization";
    public static final String polsarData = "polsar_data";
    public static final String[] polarTags = new String[]{"mds1_tx_rx_polar", "mds2_tx_rx_polar", "mds3_tx_rx_polar", "mds4_tx_rx_polar"};
    public static final String azimuth_looks = "azimuth_looks";
    public static final String range_looks = "range_looks";
    public static final String range_spacing = "range_spacing";
    public static final String azimuth_spacing = "azimuth_spacing";
    public static final String pulse_repetition_frequency = "pulse_repetition_frequency";
    public static final String radar_frequency = "radar_frequency";
    public static final String srgr_flag = "srgr_flag";
    public static final String ant_elev_corr_flag = "ant_elev_corr_flag";
    public static final String range_spread_comp_flag = "range_spread_comp_flag";
    public static final String inc_angle_comp_flag = "inc_angle_comp_flag";
    public static final String abs_calibration_flag = "abs_calibration_flag";
    public static final String calibration_factor = "calibration_factor";
    public static final String replica_power_corr_flag = "replica_power_corr_flag";
    public static final String range_sampling_rate = "range_sampling_rate";
    public static final String avg_scene_height = "avg_scene_height";
    public static final String multilook_flag = "multilook_flag";
    public static final String ref_inc_angle = "ref_inc_angle";
    public static final String ref_slant_range = "ref_slant_range";
    public static final String ref_slant_range_exp = "ref_slant_range_exp";
    public static final String rescaling_factor = "rescaling_factor";
    public static final String coregistered_stack = "coregistered_stack";
    public static final String external_calibration_file = "external_calibration_file";
    public static final String orbit_state_vector_file = "orbit_state_vector_file";
    public static final String target_report_file = "target_report_file";
    public static final String wind_field_report_file = "wind_field_report_file";
    public static final String srgr_coefficients = "SRGR_Coefficients";
    public static final String srgr_coef_list = "srgr_coef_list";
    public static final String srgr_coef_time = "zero_doppler_time";
    public static final String ground_range_origin = "ground_range_origin";
    public static final String coefficient = "coefficient";
    public static final String srgr_coef = "srgr_coef";
    public static final String dop_coefficients = "Doppler_Centroid_Coefficients";
    public static final String dop_coef_list = "dop_coef_list";
    public static final String dop_coef_time = "zero_doppler_time";
    public static final String slant_range_time = "slant_range_time";
    public static final String dop_coef = "dop_coef";
    public static final String is_terrain_corrected = "is_terrain_corrected";
    public static final String DEM = "DEM";
    public static final String geo_ref_system = "geo_ref_system";
    public static final String lat_pixel_res = "lat_pixel_res";
    public static final String lon_pixel_res = "lon_pixel_res";
    public static final String slant_range_to_first_pixel = "slant_range_to_first_pixel";
    public static final String range_bandwidth = "range_bandwidth";
    public static final String azimuth_bandwidth = "azimuth_bandwidth";
    public final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    public static final String compact_mode = "compact_mode";

    public static AbstractMetadataSAR getSARAbstractedMetadata(Product sourceProduct) throws IOException {
        AbstractMetadata abstractMetadata = AbstractMetadata.getAbstractedMetadata(sourceProduct);
        if (abstractMetadata == null) {
            throw new IOException("no metadata found in product");
        }
        MetadataElement absRoot = abstractMetadata.getAbsRoot();
        return new AbstractMetadataSAR(absRoot, absRoot.getElement(SAR_METADATA_ROOT));
    }

    private AbstractMetadataSAR(MetadataElement root, MetadataElement abstractedMetadata) {
        super(root, abstractedMetadata);
    }

    @Override
    protected boolean isCurrentVersion() {
        String version = this.absRoot.getAttributeString(abstracted_metadata_version, "");
        return version.equals(METADATA_VERSION);
    }

    @Override
    protected void migrateToCurrentVersion(MetadataElement abstractedMetadata) {
        if (this.isCurrentVersion()) {
            return;
        }
    }

    @Override
    protected MetadataElement addAbstractedMetadataHeader(MetadataElement root) {
        MetadataElement sarRoot;
        if (root == null) {
            sarRoot = new MetadataElement(SAR_METADATA_ROOT);
        } else {
            sarRoot = root.getElement(SAR_METADATA_ROOT);
            if (sarRoot == null) {
                sarRoot = new MetadataElement(SAR_METADATA_ROOT);
                root.addElementAt(sarRoot, 0);
            }
        }
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, antenna_pointing, 41, "", "Right or left facing");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, incidence_near, 31, "deg", "");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, incidence_far, 31, "deg", "");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, mds1_tx_rx_polar, 41, "", "Polarization");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, mds2_tx_rx_polar, 41, "", "Polarization");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, mds3_tx_rx_polar, 41, "", "Polarization");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, mds4_tx_rx_polar, 41, "", "Polarization");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, azimuth_looks, 31, "", "");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, range_looks, 31, "", "");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, range_spacing, 31, "m", "Range sample spacing");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, azimuth_spacing, 31, "m", "Azimuth sample spacing");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, pulse_repetition_frequency, 31, "Hz", "PRF");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, radar_frequency, 31, "MHz", "Radar frequency");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, range_bandwidth, 31, "MHz", "Bandwidth total in range");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, azimuth_bandwidth, 31, "Hz", "Bandwidth total in azimuth");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, srgr_flag, 20, "flag", "SRGR applied");
        MetadataAttribute att = AbstractMetadataSAR.addAbstractedAttribute(sarRoot, avg_scene_height, 31, "m", "Average scene height ellipsoid");
        att.getData().setElemInt(0);
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, is_terrain_corrected, 20, "flag", "orthorectification applied");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, DEM, 41, "", "Digital Elevation Model used");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, geo_ref_system, 41, "", "geographic reference system");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, lat_pixel_res, 31, "deg", "pixel resolution in geocoded image");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, lon_pixel_res, 31, "deg", "pixel resolution in geocoded image");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, slant_range_to_first_pixel, 31, "m", "Slant range to 1st data sample");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, ant_elev_corr_flag, 20, "flag", "Antenna elevation applied");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, range_spread_comp_flag, 20, "flag", "range spread compensation applied");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, replica_power_corr_flag, 20, "flag", "Replica pulse power correction applied");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, abs_calibration_flag, 20, "flag", "Product calibrated");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, calibration_factor, 31, "", "Calibration constant");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, inc_angle_comp_flag, 20, "flag", "incidence angle compensation applied");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, ref_inc_angle, 31, "", "Reference incidence angle");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, ref_slant_range, 31, "", "Reference slant range");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, ref_slant_range_exp, 31, "", "Reference slant range exponent");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, rescaling_factor, 31, "", "Rescaling factor");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, range_sampling_rate, 31, "MHz", "Range Sampling Rate");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, polsarData, 20, "flag", "Polarimetric Matrix");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, multilook_flag, 20, "flag", "Multilook applied");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, coregistered_stack, 20, "flag", "Coregistration applied");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, external_calibration_file, 41, "", "External calibration file used");
        AbstractMetadataSAR.addAbstractedAttribute(sarRoot, orbit_state_vector_file, 41, "", "Orbit file used");
        sarRoot.addElement(new MetadataElement(srgr_coefficients));
        sarRoot.addElement(new MetadataElement(dop_coefficients));
        att = AbstractMetadataSAR.addAbstractedAttribute(sarRoot, abstracted_metadata_version, 41, "", "AbsMetadata version");
        att.getData().setElems((Object)METADATA_VERSION);
        return sarRoot;
    }

    public static SRGRCoefficientList[] getSRGRCoefficients(MetadataElement absRoot) {
        MetadataElement elemRoot = absRoot.getElement(srgr_coefficients);
        MetadataElement[] srgr_coef_listElem = elemRoot.getElements();
        SRGRCoefficientList[] srgrCoefficientList = new SRGRCoefficientList[srgr_coef_listElem.length];
        int k = 0;
        for (MetadataElement listElem : srgr_coef_listElem) {
            SRGRCoefficientList srgrList = new SRGRCoefficientList();
            srgrList.time = listElem.getAttributeUTC("zero_doppler_time");
            srgrList.timeMJD = srgrList.time.getMJD();
            srgrList.ground_range_origin = listElem.getAttributeDouble(ground_range_origin);
            int numSubElems = listElem.getNumElements();
            srgrList.coefficients = new double[numSubElems];
            for (int i = 0; i < numSubElems; ++i) {
                MetadataElement coefElem = listElem.getElementAt(i);
                srgrList.coefficients[i] = coefElem.getAttributeDouble(srgr_coef, 0.0);
            }
            srgrCoefficientList[k++] = srgrList;
        }
        return srgrCoefficientList;
    }

    public static DopplerCentroidCoefficientList[] getDopplerCentroidCoefficients(MetadataElement absRoot) {
        MetadataElement elemRoot = absRoot.getElement(dop_coefficients);
        MetadataElement[] dop_coef_listElem = elemRoot.getElements();
        DopplerCentroidCoefficientList[] dopCoefficientList = new DopplerCentroidCoefficientList[dop_coef_listElem.length];
        int k = 0;
        for (MetadataElement listElem : dop_coef_listElem) {
            DopplerCentroidCoefficientList dopList = new DopplerCentroidCoefficientList();
            dopList.time = listElem.getAttributeUTC("zero_doppler_time");
            dopList.timeMJD = dopList.time.getMJD();
            dopList.slant_range_time = listElem.getAttributeDouble(slant_range_time, 0.0);
            int numSubElems = listElem.getNumElements();
            dopList.coefficients = new double[numSubElems];
            for (int i = 0; i < numSubElems; ++i) {
                MetadataElement coefElem = listElem.getElementAt(i);
                dopList.coefficients[i] = coefElem.getAttributeDouble(dop_coef, 0.0);
            }
            dopCoefficientList[k++] = dopList;
        }
        return dopCoefficientList;
    }

    public static class DopplerCentroidCoefficientList {
        public ProductData.UTC time = null;
        public double timeMJD = 0.0;
        public double slant_range_time = 0.0;
        public double[] coefficients = null;
    }

    public static class SRGRCoefficientList {
        public ProductData.UTC time = null;
        public double timeMJD = 0.0;
        public double ground_range_origin = 0.0;
        public double[] coefficients = null;
    }
}

