/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.download;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.esa.snap.core.dataop.downloadable.FtpDownloader;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.util.DefaultPropertyMap;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.engine_utilities.download.DownloadableContent;
import org.esa.snap.engine_utilities.download.DownloadableFile;

public abstract class DownloadableContentImpl
implements DownloadableContent {
    private File localFile;
    private final File localZipFile;
    private boolean localFileExists = false;
    private boolean remoteFileExists = true;
    private boolean errorInLocalFile = false;
    private DownloadableFile contentFile = null;
    private FtpDownloader ftp = null;
    private Map<String, Long> fileSizeMap = null;
    private boolean unrecoverableError = false;
    private final URL remoteURL;
    private int remoteVersion = 0;
    private static final String versionFileName = "contentVersion.txt";

    public DownloadableContentImpl(File localFile, URL remoteURL, String archiveExt) {
        this.remoteURL = remoteURL;
        this.localFile = localFile;
        this.localZipFile = FileUtils.exchangeExtension((File)localFile, (String)archiveExt);
    }

    @Override
    public void dispose() {
        try {
            if (this.ftp != null) {
                this.ftp.disconnect();
            }
            this.ftp = null;
            this.contentFile.dispose();
            this.contentFile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final DownloadableFile getContentFile() throws IOException {
        if (this.contentFile == null) {
            if (!this.remoteFileExists && !this.localFileExists) {
                return null;
            }
            this.findFile();
        }
        return this.contentFile;
    }

    @Override
    public String getFileName() {
        return this.localFile.getName();
    }

    protected abstract DownloadableFile createContentFile(File var1);

    private boolean findLocalFile() {
        return this.localFile.exists() && this.localFile.isFile() || this.localZipFile.exists() && this.localZipFile.isFile();
    }

    private boolean getRemoteFile() throws IOException {
        block5: {
            if (this.remoteURL == null) {
                throw new IOException("DownloadableContent: Remote archive url not set");
            }
            if (this.remoteURL.getProtocol().contains("http")) {
                try {
                    boolean newVersionAvailable = this.checkForNewRemoteHttpFile(this.remoteURL, this.localZipFile);
                    if (newVersionAvailable) {
                        DownloadableContentImpl.getRemoteHttpFile(this.remoteURL, this.localZipFile);
                        this.saveNewVersion(this.localZipFile);
                        return true;
                    }
                    break block5;
                }
                catch (Exception e) {
                    SystemUtils.LOG.warning("http error:" + e.getMessage() + " on " + this.remoteURL.toString() + this.localZipFile.getName());
                    this.remoteFileExists = false;
                    return false;
                }
            }
            return this.getRemoteFTPFile(this.remoteURL);
        }
        return false;
    }

    private boolean checkForNewRemoteHttpFile(URL remoteURL, File localZipFile) throws IOException {
        File remoteVersionFile = new File(localZipFile.getParent(), "remote_contentVersion.txt");
        try {
            DownloadableContentImpl.downloadFile(new URL(remoteURL.toString() + remoteVersionFile.getName()), remoteVersionFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean newVersion = true;
        if (remoteVersionFile.exists()) {
            DefaultPropertyMap remoteVersionMap = new DefaultPropertyMap();
            remoteVersionMap.load(remoteVersionFile.toPath());
            this.remoteVersion = remoteVersionMap.getPropertyInt(localZipFile.getName());
            File localVersionFile = new File(localZipFile.getParent(), versionFileName);
            if (localVersionFile.exists()) {
                DefaultPropertyMap localVersionMap = new DefaultPropertyMap();
                localVersionMap.load(localVersionFile.toPath());
                int localVersion = localVersionMap.getPropertyInt(localZipFile.getName());
                if (this.remoteVersion != 0 && localVersion != 0 && this.remoteVersion == localVersion) {
                    newVersion = false;
                }
            }
            remoteVersionFile.delete();
        }
        return newVersion;
    }

    private void saveNewVersion(File localZipFile) throws IOException {
        if (this.remoteVersion == 0) {
            return;
        }
        File localVersionFile = new File(localZipFile.getParent(), versionFileName);
        DefaultPropertyMap localVersionMap = new DefaultPropertyMap();
        if (localVersionFile.exists()) {
            localVersionMap.load(localVersionFile.toPath());
        }
        localVersionMap.setPropertyInt(localZipFile.getName(), Integer.valueOf(this.remoteVersion));
        localVersionMap.store(localVersionFile.toPath(), "");
    }

    private synchronized void findFile() throws IOException {
        block10: {
            try {
                if (this.contentFile != null) {
                    return;
                }
                if (!this.localFileExists && !this.errorInLocalFile) {
                    this.localFileExists = this.findLocalFile();
                }
                if (this.localFileExists) {
                    this.getLocalFile();
                } else if (this.remoteFileExists && this.getRemoteFile()) {
                    this.getLocalFile();
                }
                if (this.contentFile != null) {
                    this.errorInLocalFile = false;
                } else {
                    if (!this.remoteFileExists && this.localFileExists) {
                        SystemUtils.LOG.warning("Unable to read product " + this.localFile.getAbsolutePath());
                    }
                    this.localFileExists = false;
                    this.errorInLocalFile = true;
                }
            }
            catch (Exception e) {
                SystemUtils.LOG.warning(e.getMessage());
                this.contentFile = null;
                this.localFileExists = false;
                this.errorInLocalFile = true;
                if (!this.unrecoverableError) break block10;
                throw new IOException(e);
            }
        }
    }

    private void getLocalFile() throws IOException {
        File dataFile = this.localFile;
        if (!dataFile.exists()) {
            dataFile = this.getFileFromZip(this.localZipFile);
        }
        if (dataFile != null) {
            this.contentFile = this.createContentFile(dataFile);
        }
    }

    public static File getRemoteHttpFile(URL remoteURL, File localZipFile) throws IOException {
        String remotePath = remoteURL.toString() + localZipFile.getName();
        SystemUtils.LOG.info("http retrieving " + remotePath);
        AtomicReference returnValue = new AtomicReference();
        Runnable operation = () -> {
            try {
                returnValue.set(DownloadableContentImpl.downloadFile(new URL(remotePath), localZipFile));
            }
            catch (IOException e) {
                SystemUtils.LOG.log(Level.SEVERE, "Failed to download remote file.", e);
            }
        };
        operation.run();
        return (File)returnValue.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadFile(URL fileUrl, File localZipFile) throws IOException {
        BufferedOutputStream os;
        File outputFile = new File(localZipFile.getParentFile(), new File(fileUrl.getFile()).getName());
        URLConnection urlConnection = fileUrl.openConnection();
        int contentLength = urlConnection.getContentLength();
        BufferedInputStream is = new BufferedInputStream(urlConnection.getInputStream(), contentLength);
        try {
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                SystemUtils.LOG.severe("Unable to create folders in " + outputFile.getParentFile());
            }
            os = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            ((InputStream)is).close();
            throw e;
        }
        StatusProgressMonitor pm = new StatusProgressMonitor(StatusProgressMonitor.TYPE.DATA_TRANSFER);
        pm.beginTask("Downloading " + localZipFile.getName() + "... ", contentLength);
        try {
            int b;
            int n;
            int size = 32768;
            byte[] buf = new byte[32768];
            while ((n = ((InputStream)is).read(buf, 0, 32768)) > -1) {
                ((OutputStream)os).write(buf, 0, n);
                pm.worked(n);
            }
            while ((b = ((InputStream)is).read()) != -1) {
                ((OutputStream)os).write(b);
            }
        }
        catch (IOException e) {
            outputFile.delete();
            throw e;
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            finally {
                ((InputStream)is).close();
            }
            pm.done();
        }
        return outputFile;
    }

    private boolean getRemoteFTPFile(URL remoteURL) throws IOException {
        try {
            if (this.ftp == null) {
                this.ftp = new FtpDownloader(remoteURL.getHost());
                this.fileSizeMap = FtpDownloader.readRemoteFileList((FtpDownloader)this.ftp, (String)remoteURL.getHost(), (String)remoteURL.getPath());
            }
            String remoteFileName = this.localZipFile.getName();
            Long fileSize = this.fileSizeMap.get(remoteFileName);
            FtpDownloader.FTPError result = this.ftp.retrieveFile(remoteURL.getPath() + remoteFileName, this.localZipFile, fileSize);
            if (result == FtpDownloader.FTPError.OK) {
                return true;
            }
            if (result == FtpDownloader.FTPError.FILE_NOT_FOUND) {
                this.remoteFileExists = false;
            } else {
                this.dispose();
            }
            this.localZipFile.delete();
            return false;
        }
        catch (SocketException e) {
            this.unrecoverableError = true;
            throw e;
        }
        catch (Exception e) {
            SystemUtils.LOG.warning(e.getMessage());
            if (this.ftp == null) {
                this.unrecoverableError = false;
                this.remoteFileExists = false;
                throw new IOException("Failed to connect to FTP " + remoteURL.getHost() + '\n' + e.getMessage());
            }
            this.dispose();
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private File getFileFromZip(File dataFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

