/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.engine_utilities.file.FileHelper;
import org.esa.snap.engine_utilities.util.NotRegularFileException;

public abstract class AbstractFile {
    private static final Logger logger = Logger.getLogger(AbstractFile.class.getName());
    public static final int BUFFER_SIZE = 0x100000;
    private final Path file;

    protected AbstractFile(Path file) {
        this.file = file;
    }

    protected abstract Path getLocalTempFolder() throws IOException;

    public String getFileName() {
        return this.file.getFileName().toString();
    }

    public Path getLocalFile() throws IOException {
        if (Files.exists(this.file, new LinkOption[0])) {
            if (Files.isRegularFile(this.file, new LinkOption[0])) {
                Path localFile;
                if (AbstractFile.isLocalPath(this.file)) {
                    localFile = this.file;
                } else {
                    String fileName;
                    Path localTempFolder = this.getLocalTempFolder();
                    localFile = localTempFolder.resolve(fileName = this.file.getFileName().toString());
                    if (FileHelper.canCopyOrReplaceFile(this.file, localFile)) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Copy file '" + this.file.toString() + "' to local folder '" + localTempFolder.toString() + "'.");
                        }
                        FileHelper.copyFileUsingInputStream(this.file, localFile.toString(), 0x100000);
                    }
                }
                return localFile;
            }
            throw new NotRegularFileException(this.file.toString());
        }
        throw new FileNotFoundException(this.file.toString());
    }

    public static boolean isLocalPath(Path path) {
        return path.getFileSystem().provider() == FileSystems.getDefault().provider();
    }
}

