/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.snap.engine_utilities.util.NotRegularFileException;

public class FileHelper {
    private FileHelper() {
    }

    public static boolean canCopyOrReplaceFile(Path sourceFile, Path destinationFile) throws IOException {
        boolean copyOrReplaceFile = true;
        if (Files.exists(destinationFile, new LinkOption[0])) {
            if (Files.isRegularFile(destinationFile, new LinkOption[0])) {
                long sourceFileSizeInBytes = Files.size(sourceFile);
                long destinationFileSizeInBytes = Files.size(destinationFile);
                copyOrReplaceFile = destinationFileSizeInBytes != sourceFileSizeInBytes;
            } else {
                throw new NotRegularFileException(destinationFile.toString());
            }
        }
        return copyOrReplaceFile;
    }

    public static void copyFileUsingInputStream(Path sourcePath, String destinationLocalFilePath, int maximumBufferSize) throws IOException {
        try (InputStream inputStream = sourcePath.getFileSystem().provider().newInputStream(sourcePath, new OpenOption[0]);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, maximumBufferSize);
             ReadableByteChannel readableByteChannel = Channels.newChannel(bufferedInputStream);
             FileOutputStream fileOutputStream = new FileOutputStream(destinationLocalFilePath, false);){
            FileChannel destinationFileChannel = fileOutputStream.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(maximumBufferSize);
            while (readableByteChannel.read(buffer) > 0) {
                buffer.flip();
                destinationFileChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                destinationFileChannel.write(buffer);
            }
        }
    }

    public static void copyFileUsingByteChannel(Path sourcePath, Path destinationPath) throws IOException {
        Set options = Collections.emptySet();
        FileSystemProvider fileSystemProvider = sourcePath.getFileSystem().provider();
        try (FileChannel sourceFileChannel = fileSystemProvider.newFileChannel(sourcePath, options, new FileAttribute[0]);
             WritableByteChannel writableByteChannel = Channels.newChannel(Files.newOutputStream(destinationPath, new OpenOption[0]));){
            long bytesReadNow;
            long sourceFileSize = sourceFileChannel.size();
            long transferredSize = 0L;
            while ((bytesReadNow = sourceFileChannel.transferTo(transferredSize, sourceFileSize - transferredSize, writableByteChannel)) > 0L) {
                transferredSize += bytesReadNow;
            }
        }
    }

    public static void copyFileUsingFileChannel(Path sourcePath, String destinationLocalFilePath) throws IOException {
        Set options = Collections.emptySet();
        FileSystemProvider fileSystemProvider = sourcePath.getFileSystem().provider();
        try (FileChannel sourceFileChannel = fileSystemProvider.newFileChannel(sourcePath, options, new FileAttribute[0]);
             FileOutputStream fileOutputStream = new FileOutputStream(destinationLocalFilePath, false);){
            long bytesReadNow;
            long sourceFileSize = sourceFileChannel.size();
            FileChannel destinationFileChannel = fileOutputStream.getChannel();
            long transferredSize = 0L;
            while ((bytesReadNow = sourceFileChannel.transferTo(transferredSize, sourceFileSize - transferredSize, destinationFileChannel)) > 0L) {
                transferredSize += bytesReadNow;
            }
        }
    }

    public static File getFile(String basePath, String ... pathFragments) throws IOException {
        File file = new File(basePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (pathFragments != null) {
            for (int i = 0; i < pathFragments.length; ++i) {
                file = new File(file, pathFragments[i]);
                if (i < pathFragments.length - 1) {
                    file.mkdirs();
                    continue;
                }
                if (file.exists()) continue;
                file.createNewFile();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(URL sourceURL, Path destinationFile) throws IOException {
        if (sourceURL == null || destinationFile == null) {
            throw new IllegalArgumentException("One of the arguments is null");
        }
        try (InputStream inputStream = sourceURL.openStream();){
            File dest = destinationFile.toFile();
            dest.getParentFile().mkdirs();
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest));){
                int read;
                byte[] buffer = new byte[4096];
                while ((read = inputStream.read(buffer)) > 0) {
                    bos.write(buffer, 0, read);
                }
            }
        }
    }

    public static void unzip(Path sourceFile, Path destination, boolean keepFolderStructure) throws IOException {
        if (sourceFile == null || destination == null) {
            throw new IllegalArgumentException("One of the arguments is null");
        }
        if (!Files.exists(destination, new LinkOption[0])) {
            Files.createDirectory(destination, new FileAttribute[0]);
        }
        try (ZipFile zipFile = new ZipFile(sourceFile.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() && !keepFolderStructure) continue;
                Path filePath = destination.resolve(entry.getName());
                Path strippedFilePath = destination.resolve(filePath.getFileName());
                if (Files.exists(filePath, new LinkOption[0])) continue;
                if (entry.isDirectory()) {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                    continue;
                }
                InputStream inputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(keepFolderStructure ? filePath.toFile() : strippedFilePath.toFile()));
                    Throwable throwable2 = null;
                    try {
                        int read;
                        byte[] buffer = new byte[4096];
                        while ((read = inputStream.read(buffer)) > 0) {
                            bos.write(buffer, 0, read);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bos == null) continue;
                        if (throwable2 != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }
}

