/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

public final class StackUtils {
    public static final String MST = "_mst";
    public static final String SLV = "_slv";

    public static boolean isCoregisteredStack(Product product) {
        if (!AbstractMetadata.hasAbstractedMetadata(product)) {
            return false;
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        return absRoot != null && absRoot.getAttributeInt("coregistered_stack", 0) == 1;
    }

    public static boolean isBiStaticStack(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        return absRoot != null && absRoot.getAttributeInt("bistatic_stack", 0) == 1;
    }

    public static String createBandTimeStamp(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        if (absRoot != null) {
            String dateString = OperatorUtils.getAcquisitionDate(absRoot);
            if (!dateString.isEmpty()) {
                dateString = '_' + dateString;
            }
            return StringUtils.createValidName((String)dateString, (char[])new char[]{'_', '.'}, (char)'_');
        }
        return "";
    }

    public static void saveMasterProductBandNames(Product targetProduct, String[] masterProductBands) {
        MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata(targetProduct.getMetadataRoot());
        StringBuilder value = new StringBuilder(255);
        for (String name : masterProductBands) {
            value.append(name);
            value.append(' ');
        }
        String masterBandNames = value.toString().trim();
        if (!masterBandNames.isEmpty()) {
            targetSlaveMetadataRoot.setAttributeString("Master_bands", masterBandNames);
        }
    }

    public static void saveSlaveProductNames(Product[] sourceProducts, Product targetProduct, Product masterProduct, Map<Band, Band> sourceRasterMap) throws Exception {
        for (Product prod : sourceProducts) {
            if (prod == masterProduct) continue;
            String suffix = StackUtils.createBandTimeStamp(prod);
            ArrayList<String> bandNames = new ArrayList<String>(10);
            for (Band tgtBand : sourceRasterMap.keySet()) {
                Band srcBand = sourceRasterMap.get(tgtBand);
                Product srcProduct = srcBand.getProduct();
                if (srcProduct != prod) continue;
                bandNames.add(tgtBand.getName());
            }
            String[] slvBandNames = new String[bandNames.size()];
            Product tgtBands = targetProduct.getBands();
            int cnt = 0;
            for (Product tgtBand : tgtBands) {
                if (bandNames.contains(tgtBand.getName())) {
                    slvBandNames[cnt++] = tgtBand.getName();
                }
                if (cnt >= slvBandNames.length) break;
            }
            String prodName = prod.getName() + suffix;
            StackUtils.saveSlaveProductBandNames(targetProduct, prodName, slvBandNames);
        }
    }

    public static void saveSlaveProductBandNames(Product targetProduct, String slvProductName, String[] bandNames) throws Exception {
        Guardian.assertNotNull((String)"targetProduct", (Object)targetProduct);
        Guardian.assertNotNull((String)"slvProductName", (Object)slvProductName);
        Guardian.assertNotNullOrEmpty((String)"bandNames", (Object[])bandNames);
        MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata(targetProduct.getMetadataRoot());
        MetadataElement elem = targetSlaveMetadataRoot.getElement(slvProductName);
        if (elem == null) {
            throw new Exception(slvProductName + " metadata not found");
        }
        StringBuilder value = new StringBuilder(255);
        for (String name : bandNames) {
            value.append(name);
            value.append(' ');
        }
        elem.setAttributeString("Slave_bands", value.toString().trim());
    }

    public static String findOriginalSlaveProductName(Product sourceProduct, Band slvBand) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            String slvBandName = slvBand.getName();
            for (MetadataElement elem : slaveMetadataRoot.getElements()) {
                String slvBandNames = elem.getAttributeString("Slave_bands", "");
                if (!slvBandNames.contains(slvBandName)) continue;
                return elem.getName();
            }
        }
        return null;
    }

    public static String[] getMasterBandNames(Product sourceProduct) {
        String mstBandNames;
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null && !(mstBandNames = slaveMetadataRoot.getAttributeString("Master_bands", "")).isEmpty()) {
            return StringUtils.stringToArray((String)mstBandNames, (String)" ");
        }
        ArrayList<String> bandNames = new ArrayList<String>();
        for (String bandName : sourceProduct.getBandNames()) {
            if (!bandName.toLowerCase().contains(MST)) continue;
            bandNames.add(bandName);
        }
        return bandNames.toArray(new String[0]);
    }

    public static MetadataElement getSlaveMetadata(Product sourceProduct, String slvProductName) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            MetadataElement elem = slaveMetadataRoot.getElement(slvProductName);
            return elem.createDeepClone();
        }
        return null;
    }

    public static String[] getSlaveBandNames(Product sourceProduct, String slvProductName) {
        String slvBandNames;
        MetadataElement elem;
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null && (elem = slaveMetadataRoot.getElement(slvProductName)) != null && !(slvBandNames = elem.getAttributeString("Slave_bands", "")).isEmpty()) {
            return StringUtils.stringToArray((String)slvBandNames, (String)" ");
        }
        String dateSuffix = slvProductName.contains("_") ? slvProductName.substring(slvProductName.lastIndexOf(95)).toLowerCase() : "";
        ArrayList<String> bandNames = new ArrayList<String>();
        for (String bandName : sourceProduct.getBandNames()) {
            String name = bandName.toLowerCase();
            if (!name.contains(SLV) || !name.endsWith(dateSuffix)) continue;
            bandNames.add(bandName);
        }
        return bandNames.toArray(new String[0]);
    }

    public static boolean isMasterBand(String bandName, Product sourceProduct) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            String mstBandNames = slaveMetadataRoot.getAttributeString("Master_bands", "");
            return mstBandNames.contains(bandName);
        }
        for (String srcBandName : sourceProduct.getBandNames()) {
            if (!srcBandName.toLowerCase().contains(MST) || !srcBandName.contains(bandName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSlaveBand(String bandName, Product sourceProduct) {
        String[] slvProductNames;
        for (String slvProductName : slvProductNames = StackUtils.getSlaveProductNames(sourceProduct)) {
            if (!StackUtils.isSlaveBand(bandName, sourceProduct, slvProductName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSlaveBand(String bandName, Product sourceProduct, String slvProductName) {
        MetadataElement elem;
        String slvBandNames;
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null && !(slvBandNames = (elem = slaveMetadataRoot.getElement(slvProductName)).getAttributeString("Slave_bands", "")).isEmpty()) {
            return slvBandNames.contains(bandName);
        }
        String dateSuffix = slvProductName.substring(slvProductName.lastIndexOf(95)).toLowerCase();
        for (String srcBandName : sourceProduct.getBandNames()) {
            String name = srcBandName.toLowerCase();
            if (!name.contains(SLV) || !name.endsWith(dateSuffix) || !srcBandName.contains(bandName)) continue;
            return true;
        }
        return false;
    }

    public static String[] getSlaveProductNames(Product sourceProduct) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            return slaveMetadataRoot.getElementNames();
        }
        return new String[0];
    }

    public static String getBandNameWithoutDate(String bandName) {
        if (bandName.contains(MST)) {
            return bandName.substring(0, bandName.lastIndexOf(MST));
        }
        if (bandName.contains(SLV)) {
            return bandName.substring(0, bandName.lastIndexOf(SLV));
        }
        if (bandName.contains("_")) {
            return bandName.substring(0, bandName.lastIndexOf(95));
        }
        return bandName;
    }

    public static String[] getBandSuffixes(Band[] bands) {
        TreeSet<String> suffixSet = new TreeSet<String>();
        for (Band b : bands) {
            suffixSet.add(StackUtils.getBandSuffix(b.getName()));
        }
        return suffixSet.toArray(new String[0]);
    }

    public static String[] getBandDates(Band[] bands) {
        TreeSet<String> suffixSet = new TreeSet<String>();
        for (Band b : bands) {
            if (!b.getName().contains("_")) continue;
            suffixSet.add(b.getName().substring(b.getName().lastIndexOf("_")));
        }
        return suffixSet.toArray(new String[0]);
    }

    public static String getBandSuffix(String bandName) {
        String suffix = bandName.contains(MST) ? bandName.substring(bandName.lastIndexOf(MST)) : (bandName.contains(SLV) ? bandName.substring(bandName.lastIndexOf(SLV)) : (bandName.contains("_") ? bandName.substring(bandName.lastIndexOf(95)) : bandName));
        return suffix;
    }

    public static String getSlaveProductName(Product sourceProduct, Band slvBand, String mstPol) {
        MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveMetadataRoot != null) {
            String slvBandName = slvBand.getName();
            for (MetadataElement elem : slaveMetadataRoot.getElements()) {
                String slvBandNames = elem.getAttributeString("Slave_bands", "");
                if (mstPol == null && slvBandNames.contains(slvBandName)) {
                    return elem.getName();
                }
                if (mstPol == null) continue;
                String[] bandNames = StringUtils.toStringArray((String)slvBandNames, (String)" ");
                boolean polExist = false;
                for (String slvName : bandNames) {
                    String slvPol = OperatorUtils.getPolarizationFromBandName(slvName);
                    if (slvPol == null || !slvPol.equalsIgnoreCase(mstPol)) continue;
                    polExist = true;
                    if (!slvName.equals(slvBandName)) continue;
                    return elem.getName();
                }
                if (polExist || !slvBandNames.contains(slvBandName)) continue;
                return elem.getName();
            }
        }
        return null;
    }

    public static ProductData.UTC[] getProductTimes(Product sourceProduct) {
        ArrayList<ProductData.UTC> utcList = new ArrayList<ProductData.UTC>();
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(sourceProduct);
        if (absRoot != null) {
            utcList.add(absRoot.getAttributeUTC("first_line_time"));
            MetadataElement slaveMetadataRoot = sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
            if (slaveMetadataRoot != null) {
                for (MetadataElement elem : slaveMetadataRoot.getElements()) {
                    utcList.add(elem.getAttributeUTC("first_line_time"));
                }
            }
        }
        return utcList.toArray(new ProductData.UTC[0]);
    }

    public static String[] bandsToStringArray(Band[] bands) {
        String[] names = new String[bands.length];
        int i = 0;
        for (Band band : bands) {
            names[i++] = band.getName();
        }
        return names;
    }
}

