/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class FileIOUtils {
    private static Boolean supportsPosix;

    public static void replaceText(File inFile, File outFile, String oldText, String newText) throws IOException {
        List lines;
        try (FileReader fileReader = new FileReader(inFile);){
            lines = IOUtils.readLines((Reader)fileReader);
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                if (!line.contains(oldText)) continue;
                lines.set(i, line.replaceAll(oldText, newText));
            }
        }
        if (!lines.isEmpty()) {
            var6_5 = null;
            try (FileWriter fileWriter = new FileWriter(outFile);){
                IOUtils.writeLines((Collection)lines, (String)"\n", (Writer)fileWriter);
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
        }
    }

    public static Path copyFolderNew(Path sourcePath, Path targetPath) throws IOException {
        return FileIOUtils.copyOrMoveFolder(sourcePath, targetPath, false);
    }

    public static Path moveFolderNew(Path sourcePath, Path targetPath) throws IOException {
        return FileIOUtils.copyOrMoveFolder(sourcePath, targetPath, true);
    }

    private static Path copyOrMoveFolder(Path sourcePath, Path targetPath, boolean move) throws IOException {
        if (sourcePath == null) {
            throw new NullPointerException("The source path is null.");
        }
        if (targetPath == null) {
            throw new NullPointerException("The target path is null.");
        }
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            throw new FileNotFoundException("The source path '" + sourcePath + "' does not exist.");
        }
        if (!Files.exists(targetPath, new LinkOption[0])) {
            throw new FileNotFoundException("The target path '" + targetPath + "' does not exist.");
        }
        if (!Files.isDirectory(targetPath, new LinkOption[0])) {
            throw new NotDirectoryException("The target path '" + targetPath + "' is not a directory.");
        }
        Path target = targetPath.resolve(sourcePath.getFileName());
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        CopyDirVisitor visitor = new CopyDirVisitor(sourcePath, target, move);
        Files.walkFileTree(sourcePath, opts, Integer.MAX_VALUE, visitor);
        return target;
    }

    public static void copyFolder(Path source, Path target) throws IOException {
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        CopyDirVisitor tc = new CopyDirVisitor(source, target, false);
        Files.walkFileTree(source, opts, Integer.MAX_VALUE, tc);
    }

    public static void moveFolder(Path source, Path target) throws IOException {
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        CopyDirVisitor tc = new CopyDirVisitor(source, target, true);
        Files.walkFileTree(source, opts, Integer.MAX_VALUE, tc);
    }

    public static void deleteFolder(Path source) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        });
    }

    public static long computeFileSize(Path path) throws IOException {
        FileSizeVisitor fileSizeVisitor = new FileSizeVisitor();
        Files.walkFileTree(path, fileSizeVisitor);
        return fileSizeVisitor.getSizeInBytes();
    }

    public static Path ensureExists(Path folder) throws IOException {
        if (!Files.exists(folder, new LinkOption[0])) {
            if (FileIOUtils.isPosixFileSystem()) {
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
                FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(perms);
                folder = Files.createDirectories(folder, attrs);
            } else {
                folder = Files.createDirectories(folder, new FileAttribute[0]);
            }
        }
        return folder;
    }

    public static Path ensurePermissions(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0]) && FileIOUtils.isPosixFileSystem()) {
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
            file = Files.setPosixFilePermissions(file, perms);
        }
        return file;
    }

    private static boolean isPosixFileSystem() {
        block1: {
            FileStore fs;
            if (supportsPosix != null) break block1;
            supportsPosix = Boolean.FALSE;
            FileSystem fileSystem = FileSystems.getDefault();
            Iterable<FileStore> fileStores = fileSystem.getFileStores();
            Iterator<FileStore> iterator = fileStores.iterator();
            while (iterator.hasNext() && !(supportsPosix = Boolean.valueOf((fs = iterator.next()).supportsFileAttributeView(PosixFileAttributeView.class))).booleanValue()) {
            }
        }
        return supportsPosix;
    }

    private static class FileSizeVisitor
    extends SimpleFileVisitor<Path> {
        private long sizeInBytes = 0L;

        private FileSizeVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.sizeInBytes += Files.size(file);
            return FileVisitResult.CONTINUE;
        }

        private long getSizeInBytes() {
            return this.sizeInBytes;
        }
    }

    static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path target;
        private final boolean isMove;

        CopyDirVisitor(Path source, Path target, boolean move) {
            this.source = source;
            this.target = target;
            this.isMove = move;
        }

        private boolean copyFile(Path source, Path target) throws IOException {
            try {
                if (this.isMove) {
                    Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(source, target, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.target.resolve(this.source.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            FileVisitResult visitResult = super.postVisitDirectory(dir, exc);
            if (this.isMove) {
                Files.delete(dir);
            }
            return visitResult;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.copyFile(file, this.target.resolve(this.source.relativize(file)));
            return FileVisitResult.CONTINUE;
        }
    }
}

