/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.TreeSet;
import org.esa.snap.engine_utilities.util.AllFilesVisitor;
import org.esa.snap.engine_utilities.util.ZipFileSystemBuilder;

public class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static String replaceFileSeparator(String path, String fileSystemSeparator) {
        return path.replace("\\", fileSystemSeparator).replace("/", fileSystemSeparator);
    }

    public static boolean isZipFile(Path zipPath) throws IllegalAccessException, InstantiationException, InvocationTargetException, IOException {
        try (FileSystem fileSystem = ZipFileSystemBuilder.newZipFileSystem(zipPath);){
            boolean bl = fileSystem != null;
            return bl;
        }
    }

    public static TreeSet<String> listAllFilePaths(FileSystem fileSystem) throws IOException {
        AllFilesVisitor filesVisitor = new AllFilesVisitor();
        for (Path zipArchiveRoot : fileSystem.getRootDirectories()) {
            Files.walkFileTree(zipArchiveRoot, filesVisitor);
        }
        return filesVisitor.getFilePaths();
    }
}

