/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class PathUtils {
    public static Path get(File basePath, String ... relatives) {
        if (relatives == null || relatives.length == 0) {
            return basePath.toPath();
        }
        return Paths.get(basePath.getAbsolutePath(), relatives);
    }

    public static Path get(Path basePath, String ... relatives) {
        if (relatives == null || relatives.length == 0) {
            return basePath;
        }
        return Paths.get(basePath.toAbsolutePath().toString(), relatives);
    }

    public static List<Path> listFiles(Path basePath) throws IOException {
        return PathUtils.listFiles(basePath, 1);
    }

    public static List<Path> listFiles(Path basePath, int depth) throws IOException {
        if (basePath == null) {
            return null;
        }
        depth = depth <= 0 ? 255 : depth;
        final ArrayList<Path> files = new ArrayList<Path>();
        Files.walkFileTree(basePath, EnumSet.noneOf(FileVisitOption.class), depth, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    public static String[] list(Path basePath) throws IOException {
        if (basePath == null) {
            return null;
        }
        final ArrayList files = new ArrayList();
        Files.walkFileTree(basePath, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(file.toAbsolutePath().toString());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return files.toArray(new String[files.size()]);
    }

    public static String getFileNameWithoutExtension(Path path) {
        if (path == null || Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        String fileName = path.getFileName().toString();
        return fileName.substring(0, fileName.lastIndexOf("."));
    }
}

