/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;

public class ProductFunctions {
    private static final String[] validExtensions = new String[]{".dim", ".safe", ".n1", ".e1", ".e2", ".h5", ".zip"};
    private static final String[] xmlPrefix = new String[]{"product", "tsx1_sar", "tsx2_sar", "tdx1_sar", "tdx2_sar", "tdm1_sar", "xfdumanifest", "metadata"};
    private static final String[] txtPrefix = new String[]{"LC8"};
    private static final String[] excludedExtensions = new String[0];
    private static final String[] nonValidExtensions = new String[]{"xsd", "xsl", "xls", "pdf", "doc", "docx", "ps", "db", "rtf", "ief", "ord", "rrd", "lbl", "aux", "ovr", "brs", "self", "report", "raw", "tgz", "pox", "img", "hdr", "ras", "ntf", "tfw", "gif", "jpg", "jgw", "log", "html", "htm", "png", "bmp", "kml", "kmz", "sav", "7z", "z", "gz", "tar", "exe", "so", "dll", "bat", "sh", "prj", "dbf", "shx", "shp", "ace", "ace2", "tooldes"};
    private static final String[] nonValidprefixes = new String[]{"led", "trl", "tra_", "nul", "lea", "dat", "img", "imop", "sarl", "sart", "par_", "dfas", "dfdn", "lut", "readme", "l1b_iif", "dor_vor", "imagery_", "browse"};
    static final String[] invalidFolders = new String[]{"annotation", "measurement", "auxraster", "auxfiles", "imagedata", "preview", "support", "quality", "source_images", "schemas", "aux_data", "granule", "datastrip", "rep_info", "html", "iif", "tools"};
    public static final DirectoryFileFilter directoryFileFilter = new DirectoryFileFilter();

    public static boolean isValidProduct(File file) {
        ProductReader reader;
        block4: {
            String name;
            block3: {
                name = file.getName().toLowerCase();
                for (String str : validExtensions) {
                    if (!name.endsWith(str)) continue;
                    return true;
                }
                if (!name.endsWith("xml")) break block3;
                for (String str : xmlPrefix) {
                    if (!name.contains(str)) continue;
                    return true;
                }
                break block4;
            }
            if (!name.endsWith("txt")) break block4;
            for (String str : txtPrefix) {
                if (!name.startsWith(str)) continue;
                return true;
            }
        }
        return (reader = ProductIO.getProductReaderForInput((Object)file)) != null;
    }

    public static void scanForValidProducts(File inputFolder, ArrayList<String> pathList) {
        ValidProductFileFilter dirFilter = new ValidProductFileFilter();
        File[] files = inputFolder.listFiles(dirFilter);
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ProductFunctions.scanForValidProducts(file, pathList);
                    continue;
                }
                if (!ProductFunctions.isValidProduct(file)) continue;
                pathList.add(file.getAbsolutePath());
            }
        }
    }

    public static long getRawStorageSize(Product product) {
        long size = 0L;
        if (product != null) {
            for (Band band : product.getBands()) {
                size += band.getRawStorageSize(null);
            }
        }
        return size;
    }

    public static long getTotalPixels(Product product) {
        long size = 0L;
        for (Band band : product.getBands()) {
            if (band instanceof VirtualBand) continue;
            size += (long)(band.getRasterWidth() * band.getRasterHeight());
        }
        return size;
    }

    public static String getProcessingStatistics(Long totalSeconds) {
        return ProductFunctions.getProcessingStatistics(totalSeconds, null, null);
    }

    public static String getProcessingStatistics(Long totalSeconds, Long totalBytes, Long totalPixels) {
        String durationStr;
        if (totalSeconds > 120L) {
            float minutes = (float)totalSeconds.longValue() / 60.0f;
            durationStr = minutes + " minutes";
        } else {
            durationStr = totalSeconds + " seconds";
        }
        String throughPutStr = "";
        if (totalBytes != null && totalBytes > 0L && totalSeconds > 0L) {
            long BperSec = totalBytes / totalSeconds;
            if ((double)BperSec > 1.0E9) {
                long GiBperSec = Math.round((double)totalBytes.longValue() / 1.073741824E9) / totalSeconds;
                throughPutStr = " (" + GiBperSec + " GB/s)";
            } else if ((double)BperSec > 1000000.0) {
                long MiBperSec = Math.round((double)totalBytes.longValue() / 1048576.0) / totalSeconds;
                throughPutStr = " (" + MiBperSec + " MB/s";
            } else {
                throughPutStr = " (" + BperSec + " B/s";
            }
        }
        String pixelsRateStr = "";
        if (totalPixels != null && totalPixels > 0L && totalSeconds > 0L) {
            long PperSec = totalPixels / totalSeconds;
            if ((double)PperSec > 1.0E9) {
                long GiBperSec = (long)Math.round(totalPixels / 1000000000L) / totalSeconds;
                pixelsRateStr = " (" + GiBperSec + " GPixel/s)";
            } else if ((double)PperSec > 1000000.0) {
                long MiBperSec = (long)Math.round(totalPixels / 1000000L) / totalSeconds;
                pixelsRateStr = " " + MiBperSec + " MPixel/s)";
            } else {
                pixelsRateStr = " " + PperSec + " Pixels/s)";
            }
        }
        return "Processing completed in " + durationStr + throughPutStr + pixelsRateStr;
    }

    public static class DirectoryFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            String name = file.getName().toLowerCase();
            if (name.endsWith(".data")) {
                return false;
            }
            if (name.endsWith("safe")) {
                return true;
            }
            for (String foldername : invalidFolders) {
                if (!name.endsWith(foldername)) continue;
                return false;
            }
            return true;
        }
    }

    public static class ValidProductFileFilter
    implements FileFilter {
        private final boolean includeFolders;

        public ValidProductFileFilter() {
            this.includeFolders = false;
        }

        public ValidProductFileFilter(boolean includeFolders) {
            this.includeFolders = includeFolders;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return this.includeFolders;
            }
            String name = file.getName().toLowerCase();
            for (String ext : validExtensions) {
                if (!name.endsWith(ext)) continue;
                return true;
            }
            if (name.endsWith("xml")) {
                for (String str : xmlPrefix) {
                    if (!name.contains(str)) continue;
                    return true;
                }
            } else if (name.endsWith("txt")) {
                for (String str : txtPrefix) {
                    if (!name.startsWith(str)) continue;
                    return true;
                }
            }
            for (String pre : nonValidprefixes) {
                if (!name.startsWith(pre)) continue;
                return false;
            }
            for (String ext : excludedExtensions) {
                if (!name.endsWith(ext)) continue;
                return false;
            }
            for (String ext : nonValidExtensions) {
                if (!name.endsWith(ext)) continue;
                return false;
            }
            return true;
        }
    }
}

