/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import java.io.File;
import java.util.prefs.Preferences;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;

public final class Settings {
    private static Settings _instance = new Settings();
    static final String SNAP_AUXDATA = "snap.auxdata";
    private final Preferences auxdataPreferences = Config.instance((String)"snap.auxdata").load().preferences();

    public static Settings instance() {
        return _instance;
    }

    private Settings() {
        this.auxdataPreferences.put("AuxDataPath", SystemUtils.getAuxDataPath().toString());
    }

    public String get(String key) {
        return this.auxdataPreferences.get(key, "");
    }

    public String get(String key, String deafault) {
        String propVal = System.getProperty(key);
        if (propVal != null) {
            return propVal;
        }
        return this.auxdataPreferences.get(key, deafault);
    }

    public static String getPath(String tag) {
        String path = Settings.instance().get(tag);
        if (!(path = path.replace("\\", "/")).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public File getAuxDataFolder() {
        return new File(this.auxdataPreferences.get("AuxDataPath", ""));
    }
}

