/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.util;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.logging.Logger;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.main.GPT;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.CommonReaders;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.runtime.Config;

public class TestUtils {
    private static final boolean FailOnSkip = false;
    private static final boolean FailOnLargeTestProducts = false;
    private static final boolean FailOnAllNoData = false;
    private static final int LARGE_DIMENSION = 100;
    private static final ProductData.UTC NO_TIME = new ProductData.UTC();
    private static boolean testEnvironmentInitialized = false;
    public static final String SKIPTEST = "skipTest";
    public static final Logger log = SystemUtils.LOG;

    public static void initTestEnvironment() {
        if (testEnvironmentInitialized) {
            return;
        }
        try {
            SystemUtils.init3rdPartyLibs(GPT.class);
            TestUtils.initAuxData();
            testEnvironmentInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initAuxData() throws Exception {
        Path propFile = SystemUtils.getApplicationHomeDir().toPath().resolve("snap-engine").resolve("etc/snap.auxdata.properties");
        if (!Files.exists(propFile, new LinkOption[0])) {
            propFile = SystemUtils.getApplicationHomeDir().toPath().resolve("../etc/snap.auxdata.properties");
        }
        if (!Files.exists(propFile, new LinkOption[0])) {
            propFile = SystemUtils.getApplicationHomeDir().toPath().resolve("../../snap-engine/etc/snap.auxdata.properties");
        }
        if (!Files.exists(propFile, new LinkOption[0])) {
            Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath(TestUtils.class);
            propFile = moduleBasePath.resolve("etc/snap.auxdata.properties");
        }
        if (!propFile.toFile().exists()) {
            throw new Exception("etc/snap.auxdata.properties not found");
        }
        System.out.println("Auxdata properties loaded from " + propFile);
        Config.instance((String)"snap.auxdata").load(propFile);
    }

    public static Product readSourceProduct(File inputFile) throws IOException {
        if (!inputFile.exists()) {
            throw new IOException(inputFile.getAbsolutePath() + " not found");
        }
        Product product = CommonReaders.readProduct(inputFile);
        if (product == null) {
            throw new IOException("Unable to read " + inputFile.toString());
        }
        return product;
    }

    public static void verifyProduct(Product product, boolean verifyTimes, boolean verifyGeoCoding) throws Exception {
        TestUtils.verifyProduct(product, verifyTimes, verifyGeoCoding, false);
    }

    public static void verifyProduct(Product product, boolean verifyTimes, boolean verifyGeoCoding, boolean verifyBandData) throws Exception {
        if (product == null) {
            throw new Exception("product is null");
        }
        if (verifyGeoCoding && product.getSceneGeoCoding() == null) {
            SystemUtils.LOG.warning("Geocoding is null for " + product.getFileLocation().getAbsolutePath());
        }
        if (product.getMetadataRoot() == null) {
            throw new Exception("metadataroot is null");
        }
        if (product.getNumBands() == 0 && verifyBandData) {
            throw new Exception("numbands is zero");
        }
        if (product.getProductType() == null || product.getProductType().isEmpty()) {
            throw new Exception("productType is null");
        }
        if (product.getSceneRasterWidth() == 0 || product.getSceneRasterHeight() == 0 || product.getSceneRasterWidth() == 99999 || product.getSceneRasterHeight() == 99999) {
            throw new Exception("product scene raster dimensions are " + product.getSceneRasterWidth() + " x " + product.getSceneRasterHeight());
        }
        if (verifyTimes) {
            if (product.getStartTime() == null || product.getStartTime().getMJD() == NO_TIME.getMJD()) {
                throw new Exception("startTime is null");
            }
            if (product.getEndTime() == null || product.getEndTime().getMJD() == NO_TIME.getMJD()) {
                throw new Exception("endTime is null");
            }
        }
        if (verifyBandData) {
            // empty if block
        }
    }

    public static Product createProduct(String type, int w, int h) {
        Product product = new Product("name", type, w, h);
        ProductData.UTC startTime = AbstractMetadata.parseUTC("10-MAY-2008 20:30:46.890683");
        ProductData.UTC endTime = AbstractMetadata.parseUTC("10-MAY-2008 20:35:46.890683");
        product.setStartTime(startTime);
        product.setEndTime(endTime);
        product.setDescription("description");
        TestUtils.addGeoCoding(product);
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader(product.getMetadataRoot());
        absRoot.setAttributeUTC("first_line_time", startTime);
        absRoot.setAttributeUTC("last_line_time", endTime);
        absRoot.setAttributeDouble("line_time_interval", ReaderUtils.getLineTimeInterval(startTime, endTime, h));
        return product;
    }

    public static Band createBand(Product testProduct, String bandName, int w, int h) {
        return TestUtils.createBand(testProduct, bandName, 12, "amplitude", w, h, true);
    }

    public static Band createBand(Product testProduct, String bandName, int dataType, String unit, int w, int h, boolean increasing) {
        Band band = new Band(bandName, dataType, w, h);
        testProduct.addBand(band);
        band.setUnit(unit);
        int size = w * h;
        if (dataType == 30) {
            float[] floatValues = new float[size];
            for (int i = 0; i < size; ++i) {
                floatValues[increasing ? i : size - 1 - i] = (float)i + 1.5f;
            }
            band.setData(ProductData.createInstance((float[])floatValues));
        } else if (dataType == 10 || dataType == 20) {
            byte[] intValues = new byte[size];
            int val = 0;
            for (int i = 0; i < size; ++i) {
                if (val > 127) {
                    val = 0;
                }
                intValues[increasing ? i : size - 1 - i] = (byte)val;
                ++val;
            }
            if (dataType == 20) {
                band.setData(ProductData.createUnsignedInstance((byte[])intValues));
            } else {
                band.setData(ProductData.createInstance((byte[])intValues));
            }
        } else if (dataType == 11 || dataType == 21) {
            short[] intValues = new short[size];
            int val = 0;
            for (int i = 0; i < size; ++i) {
                if (val > Short.MAX_VALUE) {
                    val = 0;
                }
                intValues[increasing ? i : size - 1 - i] = (short)val;
                ++val;
            }
            if (dataType == 21) {
                band.setData(ProductData.createUnsignedInstance((short[])intValues));
            } else {
                band.setData(ProductData.createInstance((short[])intValues));
            }
        } else {
            int[] intValues = new int[size];
            for (int i = 0; i < size; ++i) {
                intValues[increasing ? i : size - 1 - i] = i + 1;
            }
            band.setData(ProductData.createInstance((int[])intValues));
        }
        return band;
    }

    private static void addGeoCoding(Product product) {
        TiePointGrid latGrid = new TiePointGrid("latitude", 4, 4, 0.5, 0.5, (double)product.getSceneRasterWidth(), (double)product.getSceneRasterHeight(), new float[]{46.99964f, 47.078053f, 47.153496f, 47.226784f, 46.64042f, 46.71869f, 46.79402f, 46.867233f, 46.28112f, 46.359253f, 46.43448f, 46.507614f, 45.921745f, 45.999744f, 46.07487f, 46.14794f});
        TiePointGrid lonGrid = new TiePointGrid("longitude", 4, 4, 0.5, 0.5, (double)product.getSceneRasterWidth(), (double)product.getSceneRasterHeight(), new float[]{11.11786f, 10.570571f, 10.024274f, 9.472965f, 11.006959f, 10.463262f, 9.920575f, 9.372928f, 10.897017f, 10.356847f, 9.817702f, 9.273651f, 10.788004f, 10.251297f, 9.715628f, 9.175106f}, 360);
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        product.setSceneGeoCoding((GeoCoding)tpGeoCoding);
    }

    public static void attributeEquals(MetadataElement elem, String name, double trueValue) throws Exception {
        double val = elem.getAttributeDouble(name, 0.0);
        if (Double.compare(val, trueValue) != 0 && Float.compare((float)val, (float)trueValue) != 0) {
            TestUtils.throwErr(name + " is " + val + ", expecting " + trueValue);
        }
    }

    public static void attributeEquals(MetadataElement elem, String name, String trueValue) throws Exception {
        String val = elem.getAttributeString(name, "");
        if (!val.equals(trueValue)) {
            TestUtils.throwErr(name + " is " + val + ", expecting " + trueValue);
        }
    }

    private static void compareMetadata(Product testProduct, Product expectedProduct, String[] exemptionList) throws Exception {
        MetadataAttribute[] attribList;
        MetadataElement expectedAbsRoot;
        MetadataElement testAbsRoot = AbstractMetadata.getAbstractedMetadata(testProduct);
        if (testAbsRoot == null) {
            TestUtils.throwErr("Metadata is null");
        }
        if ((expectedAbsRoot = AbstractMetadata.getAbstractedMetadata(expectedProduct)) == null) {
            TestUtils.throwErr("Metadata is null");
        }
        if (exemptionList != null) {
            Arrays.sort(exemptionList);
        }
        for (MetadataAttribute expectedAttrib : attribList = expectedAbsRoot.getAttributes()) {
            ProductData expectedData;
            if (exemptionList != null && Arrays.binarySearch(exemptionList, expectedAttrib.getName()) >= 0) continue;
            MetadataAttribute result = testAbsRoot.getAttribute(expectedAttrib.getName());
            if (result == null) {
                TestUtils.throwErr("Metadata attribute " + expectedAttrib.getName() + " is missing");
            }
            if ((expectedData = result.getData()).equalElems(expectedAttrib.getData()) || (expectedData.getType() == 30 || expectedData.getType() == 31) && Double.compare(expectedData.getElemDouble(), result.getData().getElemDouble()) == 0 || expectedData.toString().trim().equalsIgnoreCase(result.getData().toString().trim())) continue;
            TestUtils.throwErr("Metadata attribute " + expectedAttrib.getName() + " expecting " + expectedAttrib.getData().toString() + " got " + result.getData().toString());
        }
    }

    public static void compareProducts(Product targetProduct, Product expectedProduct) throws Exception {
        TestUtils.compareMetadata(targetProduct, expectedProduct, null);
        if (targetProduct.getNumBands() != expectedProduct.getNumBands()) {
            TestUtils.throwErr("Different number of bands");
        }
        if (!targetProduct.isCompatibleProduct(expectedProduct, 0.0f)) {
            TestUtils.throwErr("Geocoding is different");
        }
        for (TiePointGrid tiePointGrid : expectedProduct.getTiePointGrids()) {
            TiePointGrid trgTPG = targetProduct.getTiePointGrid(tiePointGrid.getName());
            if (trgTPG == null) {
                TestUtils.throwErr("TPG " + tiePointGrid.getName() + " not found");
            }
            float[] expectedTiePoints = tiePointGrid.getTiePoints();
            float[] trgTiePoints = trgTPG.getTiePoints();
            if (Arrays.equals(trgTiePoints, expectedTiePoints)) continue;
            TestUtils.throwErr("TPGs are different in file " + expectedProduct.getFileLocation().getAbsolutePath());
        }
        for (TiePointGrid tiePointGrid : expectedProduct.getBands()) {
            Band trgBand = targetProduct.getBand(tiePointGrid.getName());
            if (trgBand == null) {
                TestUtils.throwErr("Band " + tiePointGrid.getName() + " not found");
            }
            float[] floatValues = new float[2500];
            trgBand.readPixels(40, 40, 50, 50, floatValues, ProgressMonitor.NULL);
            float[] expectedValues = new float[2500];
            tiePointGrid.readPixels(40, 40, 50, 50, expectedValues, ProgressMonitor.NULL);
            if (Arrays.equals(floatValues, expectedValues)) continue;
            TestUtils.throwErr("Pixels are different in file " + expectedProduct.getFileLocation().getAbsolutePath());
        }
    }

    public static void comparePixels(Product targetProduct, String bandName, float[] expected) throws IOException {
        TestUtils.comparePixels(targetProduct, bandName, 0, 0, expected);
    }

    public static void comparePixels(Product targetProduct, String bandName, int x, int y, float[] expected) throws IOException {
        Band band = targetProduct.getBand(bandName);
        if (band == null) {
            throw new IOException(bandName + " not found");
        }
        float[] actual = new float[expected.length];
        band.readPixels(x, y, expected.length, 1, actual, ProgressMonitor.NULL);
        for (int i = 0; i < expected.length; ++i) {
            if (!((double)Math.abs(expected[i] - actual[i]) > 1.0E-4)) continue;
            String msg = "actual:";
            for (float anActual : actual) {
                msg = msg + anActual + ", ";
            }
            log.info(msg);
            msg = "expected:";
            for (float anExpected : expected) {
                msg = msg + anExpected + ", ";
            }
            log.info(msg);
            throw new IOException("Mismatch [" + i + "] " + actual[i] + " is not " + expected[i] + " for " + targetProduct.getName() + " band:" + bandName);
        }
    }

    public static void compareProducts(Product targetProduct, String expectedPath, String[] exemptionList) throws Exception {
        Band targetBand = targetProduct.getBandAt(0);
        if (targetBand == null) {
            TestUtils.throwErr("targetBand at 0 is null");
        }
        float[] floatValues = new float[2500];
        targetBand.readPixels(40, 40, 50, 50, floatValues, ProgressMonitor.NULL);
        File expectedFile = new File(expectedPath);
        if (!expectedFile.exists()) {
            TestUtils.throwErr("Expected file not found " + expectedFile.toString());
        }
        ProductReader reader2 = ProductIO.getProductReaderForInput((Object)expectedFile);
        Product expectedProduct = reader2.readProductNodes((Object)expectedFile, null);
        Band expectedBand = expectedProduct.getBandAt(0);
        float[] expectedValues = new float[2500];
        expectedBand.readPixels(40, 40, 50, 50, expectedValues, ProgressMonitor.NULL);
        if (!Arrays.equals(floatValues, expectedValues)) {
            TestUtils.throwErr("Pixels are different in file " + expectedPath);
        }
        TestUtils.compareMetadata(targetProduct, expectedProduct, exemptionList);
    }

    public static void compareArrays(float[] actual, float[] expected, float threshold) throws IOException {
        if (actual.length != expected.length) {
            throw new IOException("The actual array and expected array have different lengths");
        }
        for (int i = 0; i < actual.length; ++i) {
            if (!(Math.abs(expected[i] - actual[i]) > threshold)) continue;
            String msg = "actual:";
            for (float anActual : actual) {
                msg = msg + anActual + ", ";
            }
            log.info(msg);
            msg = "expected:";
            for (float anExpected : expected) {
                msg = msg + anExpected + ", ";
            }
            log.info(msg);
            throw new IOException("Mismatch [" + i + "] " + actual[i] + " is not " + expected[i]);
        }
    }

    public static boolean containsProductType(String[] productTypeExemptions, String productType) {
        if (productTypeExemptions != null) {
            for (String str : productTypeExemptions) {
                if (!productType.contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean skipTest(Object obj, String msg) throws Exception {
        SystemUtils.LOG.severe(obj.getClass().getName() + " skipped " + msg);
        return true;
    }

    private static void throwErr(String description) throws Exception {
        throw new Exception(description);
    }
}

